
#define NEED_REPLIES
#include"xmx.h"

#define SEC			1
#define SERV_TCP_PORT           6000
#define MAXSIZE                 512
#define BACKLOG                 5
#define MAXNAMESIZE     	30
#define TIMEOUT     		(SEC * 30)


/* extern 	int servsockfd, clisockfd, newsockfd; */
/*
 *============================================================================
 * Read the message that is received from the server and then send it to
 * the server.
 *============================================================================
 */

/* send_to_x_server FUNCTION IS DELETED */

/*
 *==========================================================================
 * read the reply and copy the contents of the reply to the buffer
 *==========================================================================
 */

int
recv_reply(sockfd, buff, a_data)
int sockfd;
char * buff;
int a_data;
{
    unsigned int nread, nleft, r;
    fd_set rdfds;
    struct timeval timeout;
    char *data;
    int nbytes;

    nbytes = MAX_BUFF_LEN;
    nread = 0;
    timeout.tv_sec = 0;
    timeout.tv_usec = 0;
    nleft = nbytes;

    data = (char *)(buff + a_data);
    while( nleft > 0 ) {
	/* oops!@!! I was reading more data */
        nread = read(sockfd, data, nleft);
        if(nread < 0)
	    return nread;
 	else if( nread == 0 )
	    break;
        FD_ZERO(&rdfds);
        FD_SET(sockfd, &rdfds);
        r = select(sockfd+1, &rdfds, (fd_set *)0, (fd_set *)0, &timeout);
        if( r == 0) {
            nleft -= nread;
            break;
        }
	nleft -= nread;
	data += nread;
    }
    return (nbytes - nleft);
}

/************************************************************************
*                                                                       *
*       Test if the buffer contains at least as much active data as     *
*       the next available reply's size.  If so, return that size       *
*       and set the pointer to point to the beginning of the reply.     *
*       If the request is larger than the remaining data in the buffer  *
*       return 0.                                                       *
*                                                                       *
*       The first time this is called for a particular buffer, *cp      *
*       should be set to zero, it is incremented thereafter until       *
*       there isn't enough data.                                        *
*                                                                       *
************************************************************************/
int
get_reply(buff, cp)
buffer_t *buff;
char **cp;
{
   register len, bytes_left;
   register xGenericReply *reply;

   if (*cp) {
      reply = (xGenericReply *)(*cp);
      if (reply->type == X_Reply)
         *cp += ( (reply->length << 2) + sz_xGenericReply );
      else
         *cp += sz_xEvent;
      bytes_left = (buff->n + buff->size) - (*cp - buff->data);
   }
   else {
      *cp = buff->data;
      bytes_left = buff->size + buff->n;
   }
   if (bytes_left == 0)
      return 0;
                /* because of this, slaves must have their own buffers... */
   /*****
   if (sz_xGenericReply > bytes_left) {
     printf(" Loosing data from the reply \n");
      return 0;
   }
   *****/

   reply = (xGenericReply *)*cp;
   switch (reply->type) {
      case X_Error:
         len = sz_xError;
         break;
      case X_Reply:
         len = (reply->length << 2) + sz_xGenericReply;
         break;
      default:
         len = sz_xEvent;
         break;
   }

   if (len > bytes_left) {
      len = 0;
   }
   return len;
}

void
store_atoms(data, atoms, fd)
char *data;
ATOM *atoms;
int fd;
{
    xGenericReply * reply = (xGenericReply *)data;
    ATOM *am;
    int seq_no;

    seq_no = reply->sequenceNumber;
    for(am = atoms; am && seq_no != am->seq_no; am = am->next);
    if( am ) {
	if( fd != 0 )
	    am->slave_atom_ids[fd] = ((xInternAtomReply *)data)->atom;
	else /* if master server */
	    am->master_atom_id = ((xInternAtomReply *)data)->atom;
    }
}

/*
 ***************************************************************************
 * First check that buffer contains as much active data as the next reply's
 * size. If yes than cp will point to the next reply, otherwise it will 
 * return the zero length.
 ****************************************************************************
 */

/*****
int
get_reply(buff, cp)
char *buff;
char **cp;
{
    int nleft, len;

    if(*cp){
	*cp += (sz_xGenericReply + ((*((xGenericReply **)cp))->length << 2));
	nleft = 
	}
}
*****/
