#include "xmx.h"
#include <sys/un.h>
#include<fcntl.h>
#include <netinet/tcp.h>
#include<arpa/inet.h>
#include<X11/X.h> 
#include<sys/un.h>
#include <sys/file.h>

#ifndef INADDR_NONE
#define INADDR_NONE	0xffffffff
#endif
#define NEED_REPLIES
#define X_UNIX_PATH	"/tmp/.X11-unix/X"
#define SERV_ADDR	"128.163.215.184"
#define MAXNAMESIZE	30      /* maximum size allocated for the host name */
#define BACKLOG		5       /* # of requests we are willing to queue */	
#define SERV_PORT	6000	/* service ports for X server starts from
				 * 6000
				 */
/* 
 **************************************************************************
 * Structure Definitions 
 **************************************************************************
 */

typedef struct Depth_t {
    xDepth *			depth;
    xVisualType *		visual;
}depth_t;

typedef struct Root_t {
    depth_t *			depth;
    xWindowRoot *		root;
}root_t;

typedef struct Display_t {
    xConnSetupPrefix * 		prefix;
    xConnSetup *		setup;
    char *			vendor;
    xPixmapFormat *		pix_format;
    root_t *			root;
}display_t;

/* Global variables */
static display_t *display = (display_t *)0;
extern char *packet;
extern int max_len;

int conn_serv(char *hostname);
display_t *structurize_setup_info(char *dp);
void map_master(int sockfd, display_t *display);
int test_slave_block(int s, display_t *);
void flush(display_t *);

/*
 *============================================================================
 * Create a socket at port that is available after 6000, and accept the 
 * messages from the all X client and forward the messages to the X 
 * server. 
 *============================================================================
 */

int open_conn_with_client(s)
int *s;
{
    int sockfd;
    struct linger linger;
    int cliAddrLen; /* i is a poor variable name.  So are s, t */
    int counter, display_no;
    struct sockaddr_in servAddr;
    struct hostent *hp;
    char hostname[MAXNAMESIZE +1];

    display_no = 0;

    /* Get the name of the host machine */
    if(gethostname(hostname, MAXNAMESIZE) < 0) {
	printf("Cannot find the host name\n");
	exit(1);
    }

    /* Put the address family information and our address information into the 
     * socket address structure structure
     */

    servAddr.sin_family = AF_INET;
    servAddr.sin_addr.s_addr = htonl(INADDR_ANY);

    /* Allocate an open socket for incomming connections */
    if((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("socket");
	return -1;
    }

    /* Bind the socket to the service port, which is not in use, so that we hear
     * incoming messages
     */

    servAddr.sin_port = 0;
    for(;;) {
	servAddr.sin_port = 6000 + display_no;
    	if(bind(sockfd, (struct sockaddr *)&servAddr, sizeof(servAddr)) < 0){
		display_no = display_no + 1;
		servAddr.sin_port = 0;
	}
	else
		break;
    }

    /* Give information to the clients about setting the display, so
     * that the clients can talk to the multiplexer
     */

    printf("The Clients should do the following to talk to the X-multiplexer 
       :\n\n");
    printf("setenv DISPLAY %s:%d.0\n", hostname, display_no); 

    /* linger.l_onoff = 0;
    linger.l_linger = 0;

    if (setsockopt(sockfd, SOL_SOCKET, SO_LINGER, (char *)&linger, sizeof(linger)) < 0) {
	perror("setsockopt");
	return -1;
   } */

    /* set maximum connections we will fall behind */
    listen(sockfd, BACKLOG);

    return sockfd;
}

/*
 *=========================================================================
 * This function sends the connection setup information to the server and
 * buffers the information if it is a success.
 *=========================================================================
 */

int
open_display(serv_name, display_no, buffer )
char *serv_name;
int display_no;
struct buff_t *buffer;
{
	int sockfd, packet_len;
	static inited = 0;
	int one = 1;
	int len;
	static xConnClientPrefix client;
	xConnSetupPrefix *prefix;
	static struct buff_t *buf, bp;
	display_t *dp;

	if (!inited) {
		client.byteOrder = *(char *)&one ? 'l' : 'B';
		client.pad = 0;
		client.majorVersion = X_PROTOCOL;
		client.minorVersion = X_PROTOCOL_REVISION;
		client.nbytesAuthProto = 0;
		client.nbytesAuthString =0;
		client.pad2 = 0;

		inited = 1;
	}

	init_buffer(&bp);
	if((bp.foo = (char *)malloc(sizeof(xConnClientPrefix))) == 0) {
		printf("ERROR: Out of Space\n");
		exit(1);
	}

	memcpy((void *)bp.foo, (void *)&client, sizeof(xConnClientPrefix));

	/* open connection with the X server as a client */
	if ((sockfd = conn_serv(serv_name)) < 0) {
		printf("%s: host not found\n", serv_name);
		return -1;
	}

	len = sizeof(xConnClientPrefix);
	if(writen(sockfd, &bp, len) != len) {
		printf("writen error\n");
		return -1;
	}
	free((void *)bp.foo);

	init_buffer(buffer);
	if(read_socket(sockfd, buffer, sizeof(xConnSetupPrefix)) < 0) {
		fprintf(stderr, "error in read_buffer\n");
		return -1;
	}

	prefix = (xConnSetupPrefix *)buffer->foo;	

	if(prefix->success != xTrue)
		packet_len = prefix->lengthReason;	
	else
		packet_len = 4 * (prefix->length);

	/* copy the remaining data to the buffer supplied by
	 * the function
	 */

	if((read_socket(sockfd, buffer, packet_len)) < 0) {
		fprintf(stderr, "read_buffer error\n");
		exit(1);
	}
	prefix = (xConnSetupPrefix *)buffer->foo;
	if(prefix->success != xTrue) {
		if(packet_len) {
		    printf(" ERROR: %s %s\n", prefix + 1, serv_name);
		    return -1;
		}
		else {
		    printf("Connection not accepted : no reason is given\n");
		    return -1;
		}
	}
	/* Structurize the connection setup information received by the
	 * mutliplexer from the server
	 */
	dp = structurize_setup_info((char *)prefix);

	if(!display) {
		display = dp;
		map_master(sockfd, display);
		/****
	 	*max_len = (display->setup)->maxRequestSize;
		*packet = (char *)malloc((display->setup)->maxRequestSize);
		*if(packet == 0)
		*    quit(1, "ERROR out of space\n"); 
		*max_len = MAX_SIZE;
		*****/
		packet = (char *)malloc(max_len);
		if(packet == NULL)
		    quit(1, "ERROR out of space\n");
	}

	else {
	    if(test_slave_block(sockfd, dp) < 0)
		quit(1, "Slave configuration does not match with the master\n");
	    flush(dp);
    	}

	/* make a copy of the buffer */
	/* copy_buf(buf, buffer); */

	return sockfd;
}

/*
 *============================================================================
 * Connect the Xmultiplexer to the X server as a client
 *============================================================================
 */

int
conn_serv(serv_name)
char *serv_name;
{
    int fd;
    int childpid;
    unsigned long saddr;
    int cliAddrLen; /* i is a poor variable name.  So are s, t */
    int counter, display_no;
    struct sockaddr_in servAddr, cliAddr;
    struct hostent *hp;
    char hostname[MAXNAMESIZE +1];
    char *str;

    counter = 0;
    display_no = 0;

/*    servAddr.sin_family = hp->h_addrtype; */
/*    memcpy((void *)&servAddr.sin_addr, (void *)hp->h_addr, hp->h_length); */
/*    servAddr.sin_addr.s_addr = htonl(INADDR_ANY); */
    servAddr.sin_family = AF_INET;
    servAddr.sin_port = 6000;

    if(( saddr = inet_addr(serv_name)) == INADDR_NONE) {
    	if ((hp = gethostbyname(serv_name)) == 0) {
	    return -1;
	}

        if (hp->h_addrtype != AF_INET) {
	    printf("%s: not an internet host\n", serv_name);
	    return -1;
	}

	/****
	printf("sin addr: %lu\n", hp->h_addr[0]);
	****/
        memcpy((void *)&servAddr.sin_addr, (void *)hp->h_addr, hp->h_length);
    }

    else
	servAddr.sin_addr.s_addr = saddr;

    if((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("socket");
	exit(1);
    }

    if(connect(fd, (struct sockaddr *)&servAddr, sizeof(servAddr)) < 0) {
	perror("connect");
	exit(1);
    }

    return fd;
}

/*
 *===========================================================================
 * accept the connection request from the client
 *===========================================================================
 */

int
accept_conn(sockfd)
int sockfd;
{
	int newsockfd, cli_len;
	int i;
	struct sockaddr_in cli_addr;

	cli_len = sizeof(cli_addr);
	if( ( newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &cli_len)) < 0) {
		perror("accept");
		return -1;
	}
	/* if (cli_addr.sin_family == AF_INET) {
	      i = 1;
	    if (setsockopt(newsockfd, IPPROTO_TCP, TCP_NODELAY, (char *)&i, sizeof(i)) < 0) {
		perror("client socket");
		return -1;
	    }
	}
	   (void)fcntl(newsockfd, F_SETFL, FNDELAY); */

	return newsockfd;
}

/* read the request from the socket and test whether it is
 * according to the x multiplexer's qualifications or not
 */

int
test_conn_request(sockfd)
int sockfd;
{
	xConnClientPrefix *client;
	int bool = 1;
	struct buff_t buffer;

	init_buffer(&buffer);
	if(read_socket(sockfd, &buffer, sizeof(xConnClientPrefix)) < 0) {
		fprintf(stderr, "error: read_socket error\n");
		return -1;
	}

	client = (xConnClientPrefix *)buffer.foo;
	if(client->byteOrder != 'B'){
		printf("byte order of the client differs\n");
		return -1;
	}
	if(client->majorVersion != X_PROTOCOL)
		printf("warning: major version of protocol differs\n");
	if(client->minorVersion != X_PROTOCOL_REVISION)
		printf("warning: minor version of the protocol differs\n");

	/*****
	printf("the major version of the protocol in the client is %d \n",
		client->majorVersion);
	printf("the minor version of the protocol in the client is %d \n",
		client->minorVersion);
	printf("the byte order of the protocol in the client is %d \n",
		client->byteOrder);
		*****/
/* TO BE REMOVED */
/*	free(buffer.foo); */
	return 1;
}

/*
 ****************************************************************************
 Store the information about the display sent by slave or master
 ****************************************************************************
 */

display_t *
structurize_setup_info(dp)
char *dp;
{
   display_t *foo;
   int nbytes, pad, i, j;
   xWindowRoot *r;
   xDepth *d;

   if((foo = (display_t *)malloc(sizeof(display_t))) == 0 ) {
       printf("ERROR out of space \n");
       exit(1);
   }

   foo->prefix = (xConnSetupPrefix *)dp;
   foo->setup = (xConnSetup *)(foo->prefix + 1);
   foo->vendor = (char *)(foo->setup + 1);

   nbytes = (foo->setup)->nbytesVendor;
   pad = (4 - (nbytes % 4)) % 4;

   foo->pix_format = (xPixmapFormat *)(foo->vendor + nbytes + pad);
   foo->root = (root_t *)malloc(sizeof(root_t) * (foo->setup)->numRoots);
   r = (xWindowRoot *)(foo->pix_format + (foo->setup)->numFormats);
   
   for(i = 0; i < ((foo->setup)->numRoots); i++) {
       foo->root[i].root = r;
       foo->root[i].depth = (depth_t *)malloc(
	   sizeof(depth_t) * foo->root[i].root->nDepths);
       d = (xDepth *)(foo->root[i].root + 1);
       for(j = 0; j < ((foo->root[i].root)->nDepths); j++) {
	   foo->root[i].depth[j].depth = d;
	   foo->root[i].depth[j].visual = (xVisualType *)(foo->root[i].depth[j].depth + 1);
	   d = (xDepth *)(foo->root[i].depth[j].visual + 
	    (foo->root[i].depth[j].depth)->nVisuals);
       }
       r = (xWindowRoot *)d;
   }

   return (display_t *)foo;
}

/*
 ***********************************************************************
 *
 * map the id's that are passed in the information from the server to the
 * multiplexer in the connection set up information
 *
 ***********************************************************************
 */

void
map_master(sockfd, display)
int sockfd;
display_t *display;
{
    int i, j, k;

    map_init(sockfd, display->setup->ridMask, display->setup->ridBase);
    for(i = 0; i < (display->setup)->numRoots; i++) {
	add_new_window(	sockfd, 
		      	display->root[i].root->windowId,
			display->root[i].root->defaultColormap,
			display->root[i].root->rootVisualID,
			display->root[i].root->whitePixel,
			display->root[i].root->blackPixel
		      );
        for(j = 0; j < (display->root[i].root)->nDepths; j++)
	    for(k = 0; k < (display->root[i].depth[j].depth)->nVisuals; k++)
		add_map_server_id(sockfd, 
				  (display->root[i].depth[j].visual)->visualID,
				  (char *)0
				 );
    }
}

/* 
 *********************************************************************
 * test the slave information with the master and if it matches the map
 * the slave ids
 *********************************************************************
 */

int
test_slave_block(s, dp)
int s;
display_t *dp;
{
    int i, j, k;

    if(display->setup->numRoots > dp->setup->numRoots) {
	fprintf(stderr, "Slave server has too few screens\n");
	return -1;
    }

    /* we should match the information of the slave with the master and if
     * it is compatible only then proceed. I am not implementing it right 
     * now but I will do it afterwards
     */

    map_init(s, (dp->setup)->ridMask, (dp->setup)->ridBase);
    for(i = 0; i < (dp->setup)->numRoots; i++) {
	add_map_server_id(s, (dp->root[i].root)->windowId, (char *)0);
	add_map_server_id(s, (dp->root[i].root)->defaultColormap, (char *)0);
	for(j = 0; j < (dp->root[i].root)->nDepths; j++)
	    for(k = 0; k < (dp->root[i].depth[j].depth)->nVisuals; k++)
		add_map_server_id(s, 
				  (dp->root[i].depth[j].visual)->visualID,
				  (char *)0
				  );
    }
}

/* 
 ***************************************************************************
 *
 * free the memory space taken by the display structure 
 *
 **************************************************************************
 */

void
flush(dp)
display_t *dp;
{
    int i;
    for(i = 0; i<dp->setup->numRoots; i++)
	free((void *)dp->root[i].depth);
    free((void *)dp->root);
    free((void *)dp);
}

void
reinitialize_display()
{
/****
  memset((void *)display, 0, sizeof(display_t));
  ****/
  display = (display_t *)0;
}
