/* timeout.h -- definitions having to do with timeout structures */

#ifndef _TIMEOUT_H
#define _TIMEOUT_H

#include <linux/timer.h>

/* if we have not calculated rtt */
#define CR_RTO  200              	/* timeout duration for CR    */
#define CA_RTO  200                 	/* retrans timeout for CA     */
#define FREEZE_TO 500                   /* 2MPL timeout */

/* Arrange for func(arg) to be called in t ticks. 	*/
  extern void startTimer(struct timer_list *tp, int t, void (*func)(), int arg);

/* Cancel a previously-arranged timeout.		*/
  extern void cancelTimer(struct timer_list *);

#endif
