/* utppcb.h -- declaration of the protocol control block. 	*/
/* This structure is one per connection.			*/
/* All protocol state information is kept here.			*/

#ifndef UTPPCB_H
#define	UTPPCB_H

#include <linux/utp/utp.h>
#include <linux/net.h>
#include <linux/in.h>
#include <net/sock.h>
#include <asm/atomic.h>

/* the protocol control block	*/

typedef struct pcb {
   int		up_socketfd;    /* socket fd associated with this connection*/
   struct socket *up_socket;
   struct sock  *up_sock;
   int		up_state;	/* connection state, see below	*/
   u_short	up_rcv_nxt,	/* first unreceived	*/
		up_rcv_acnt,	/* number of times ack has been sent	*/
   		up_rcv_win,	/* current size of receive window	*/
		up_snd_nxt,	/* seq # of up_unsentfirst 		*/
				/* invariant: up_unsentfirst != NULL => */
				/*   up_unsentfirst->pb_seq == up_snd_nxt */
				/* && up_snd_una+up_snd_win <= up_snd_nxt */
		up_snd_una,	/* first unacked	*/
		up_snd_win,	/* sender's idea of peer's rcv window 	*/
		up_snd_ass;	/* ack subsequence	*/
   short	up_snd_acc,	/* number SDUs accepted from user	*/
		up_flags;	/* bottom half-top half communication */
   short	up_retries,	/* number of retransmission attempts */
		up_lastackdiff; /* difference betw XA and snd_una	*/
		
   Addr_t   	up_rempsip;	/* remote PSIP address */
   u_short  	up_remport;	/* remote utp port 	*/
   u_short 	up_localport;   /* local utp port */
   u_char	up_remref;	/* remote reference number */
   struct timer_list *up_sto,
		     *up_cto;

   pbuf_t 	*up_sentfirst,	/* linked list of PDUs awaiting ack	*/
		*up_sentlast,	/* end of list				*/
	        *up_unsentfirst,/* front of list of PDUs awaitng xmsn	*/
	        *up_unsentlast,	/* rear of list of PDUs awaitng xmsn	*/
		*up_delfirst,	/* front of list waiting for delivery	*/
		*up_dellast,	/* rear of list waiting for delivery	*/
		*up_rcvlist;	/* received but not deliverable (OOO)	*/
   conbuf_t	*up_rdyfirst,	/* front of list of opened conns	*/
   		*up_rdylast;	/* rear of list of opened conns	*/
   int		up_parent;	/* parent of this passive conn.	*/
   short	congest_window, /* congestion window size */
   		congest_threshold; /* congestion threshold */
   short	slowstart_ref;
   long 	startmicro;     /* for rtt calc */
   long		endmicro;
   unsigned long rtt;
   unsigned long max_rtt;

} pcb_t;

pcb_t pcbs[MAXPCB];                     /* per-connection state info */
pbuf_t pbufs[MAXPBUF], *pbuffreelist;   /* PDU buffers */
int n_pbufs;

#endif
