/* implements the system call sys_utpUsrReq() */
#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/socket.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/net.h>
#include <linux/proc_fs.h>
#include <linux/smp_lock.h>
#include <net/utp.h>
#include <linux/utp/utppdu.h>
#include <linux/utp/utppcb.h>
#include <linux/utp/utpaux.h>
#include <linux/utp/utptimeout.h>
#include <net/checksum.h>
#include <asm/delay.h>

/* syscall for SEND, RCV, NBRCV, ACCEPT, NBACCEPT, STAT */
int sys_utpUsrReq(utpConn_t ref,int command,void *buf,int *len)
{
pcb_t *p_pcb;			// pointer to pcb
pbuf_t *pbufp;			// pointer to buffer
struct utp_stat *status;
int err;
int length;
struct sock *p_sock; 
unsigned int rto=0;		// round-trip timeout
int delay;			// for probe timer

	//printk("In sys_utpUsrReq\n");

    	if (ref < 1 || ref > MAXPCB)
        	return ERR_INVALID;

    	p_pcb = &pcbs[ref];
	pcb_lock(ref);
	p_sock = p_pcb->up_sock;

    	if (p_pcb->up_state == CLOSED) 
    	{ 
		/* conn went away when we weren't looking */
        	p_pcb->up_state = FROZEN;
        	*len = 0;               
                startTimer(p_pcb->up_cto,FREEZE_TO,(void *)freepcb,(int) ref);
		pcb_unlock(ref);
        	return ERR_CLOSED;
    	}
	
    	if (p_pcb->up_state != OPEN &&
        	(p_pcb->up_state != LSTNG || (command != UTPCOM_ACCEPT &&
                                   command != UTPCOM_NBACCEPT))) 
	{
		// unlockpcb
		pcb_unlock(ref);
        	return ERR_INVALID;
	}

    	/* state == OPEN || state == LSTNG */
    	switch (command) 
    	{
	
        case UTPCOM_STAT:
                /* returns utp_stat structure */
                //printk("In UTPCOM_STAT\n");
                status = kmalloc(sizeof(struct utp_stat),GFP_KERNEL);

                /* fill status */
                status->utps_snxt = p_pcb->up_snd_nxt;
                status->utps_st = p_pcb->up_state;
                status->utps_sndlim = p_pcb->up_snd_una + p_pcb->up_snd_win;
                status->utps_rnxt = p_pcb->up_rcv_nxt;
                status->utps_rw = p_pcb->up_rcv_win;

                /* copy status to buf */
                err = copy_to_user(buf,status,sizeof(struct utp_stat));
                if (err) //unlock
		{
			pcb_unlock(ref);
                        return err;
		}

                /* fill len */
                length = sizeof(struct utp_stat);
                err = copy_to_user(len,&length,sizeof(int));
                if (err)	//unlock
		{
			pcb_unlock(ref);
                        return err;
		}

                kfree_s(status,sizeof(struct utp_stat));
                break;

        case UTPCOM_SEND:
                {
                int advertised_window;          // for congestion control
                int effective_window;

                /* copy from len (user space) to length (kernel space) */
		pcb_lock(ref);
                err = copy_from_user(&length,len,sizeof(int));
                if (err)
		{
			pcb_unlock(ref);
			printk("Error in copy_from_user\n");
                        return err;
		}

                /* get a buffer; copy in the data       */
		if(n_pbufs==0)
                        printk("n_pbufs = %d No buffers available\n", n_pbufs);
                while ((pbufp = allocpbuf())==NULL)
                {
			pcbblock(ref);
                }
		pcbunblock(ref);

                /* copy up to MAX_UTP_DATA bytes into the buffer */
                length = (length > MAX_UTP_DATA ? MAX_UTP_DATA : length);
                copy_from_user(pbufp->pb_pdu.sd_data, buf, length);
		pbufp->pb_dcsum=csum_utp((__u32 *)pbufp->pb_pdu.sd_data,length);
                pbufp->pb_dlen = length;

                pbufp->pb_seq = p_pcb->up_snd_acc++;/* PDU/SDU sequence number*/                advertised_window = p_pcb->up_snd_win;
                effective_window = MIN(advertised_window,p_pcb->congest_window);

                /* check for congestion window size */
                printk("snd_nxt = %d, snd_una = %d, eff win= %d \n",p_pcb->up_snd_nxt, p_pcb->up_snd_una, effective_window);
		while((p_pcb->up_snd_nxt-p_pcb->up_snd_una) >= effective_window)
		{
			pcbblock(ref);
		}
		pcbunblock(ref);
                if (((u_short) p_pcb->up_snd_nxt - p_pcb->up_snd_una) < effective_window)
                {
                        /* there is room in the send window; send it now */
                        /* first we put it on the sent-list */
                        if (p_pcb->up_sentlast==NULL)
                        {
                                p_pcb->up_sentfirst = pbufp;
                                p_pcb->up_sentlast = pbufp;
                        }
                        else
                        {	
				/* Insert in the sorted list */
				if(p_pcb->up_sentlast->pb_seq >= pbufp->pb_seq)
					printk("SENT LIST NOT SORTED\n");
                                p_pcb->up_sentlast->pb_next = pbufp;
                                p_pcb->up_sentlast = pbufp;
                        }

                        p_pcb->up_snd_nxt += 1;
                        pbufp->pb_next = NULL;

			if(p_pcb->slowstart_ref == -1)
                		p_pcb->slowstart_ref = pbufp->pb_seq;

                        if(senddata(ref,pbufp)<=0)
			{
				pcb_unlock(ref);
				printk("Error in senddata\n");
                                return -1;
			}
                	{
                		struct timeval tv;
                		do_gettimeofday(&tv);
                		p_pcb->startmicro = tv.tv_usec;
                	}

                	if(p_pcb->up_flags & RTTO_PENDING)
                        	cancelTimer(p_pcb->up_sto);
			rto = (2 * p_pcb->rtt)/1000;
                	startTimer(p_pcb->up_sto,rto,(void *)retransdata,ref);
                	p_pcb->up_flags |= RTTO_PENDING;

                }
                else
                {
                        printk("didn't send the data bcos of congestion\n");
                /* no room in the send window; put on unsent list to wait */
                /* till something opens.                                  */

                        if (p_pcb->up_unsentlast==NULL)
                        {
                                /* implies unsentfirst==NULL */
                                p_pcb->up_unsentfirst = pbufp;
                                p_pcb->up_unsentlast = pbufp;
                        }
                        else
                        {
                                p_pcb->up_unsentlast->pb_next = pbufp;
                                p_pcb->up_unsentlast = pbufp;
                        }
                        pbufp->pb_next = NULL;

                        if (p_pcb->up_snd_nxt == p_pcb->up_snd_una)/* nothing to retrans */
                        {
				//cancelTimer(p_pcb->up_cto);
				delay = 2 * p_pcb->max_rtt /1000;
				if(!(p_pcb->up_flags & PB_PENDING))	
                                	startTimer(p_pcb->up_cto,delay,(void *)sendprobe,ref);
                                p_pcb->up_flags |= PB_PENDING;
                        }

                }
		/* if we are short of window size we better slow down */
                /*if (((u_short) p_pcb->up_snd_nxt - p_pcb->up_snd_una) > (effective_window/2))
		{
			unsigned long delay = 0;
			if(p_pcb->up_snd_win != 0)
				delay = (p_pcb->rtt/(2*p_pcb->up_snd_win));
			else
				delay = (p_pcb->rtt/2);

			udelay(delay);
			printk("delaying by %d microsecs \n", delay);
		}*/
                break;
		}
        case UTPCOM_NBRCV:
                /* non-blocking recv */
                //printk("In NBRECV\n");
                if (p_pcb->up_delfirst == NULL)  // unlock
		{
			pcb_unlock(ref);
                        return ERR_NODATA;
		}

                /* otherwise fall through and do it again */

        case UTPCOM_RCV:
                /* blocking recv */
                while (p_pcb->up_delfirst==NULL && p_pcb->up_state==OPEN)
		{
                	if (signal_pending(current))
                        	break;
                        pcbblock(ref);
		}

                /* p_pcb->up_delfirst != NULL || p_pcb->up_state != OPEN */

                if (p_pcb->up_state != OPEN)
                {     /* we must have CLOSED */
			int freeze_to = SAFETY_FACTOR * p_pcb->max_rtt /1000;
                        p_pcb->up_state = FROZEN;

                        startTimer(p_pcb->up_cto,freeze_to,(void *)freepcb,ref);
			pcb_unlock(ref);
                        return ERR_CLOSED;
                }

                pbufp = p_pcb->up_delfirst;        /* != NULL */

                err = copy_from_user(&length,len,sizeof(int));
                if (err)
		{
			pcb_unlock(ref);
                        return err;
		}

                /* copy out the data */
                if (length < pbufp->pb_dlen)
                {
                        err = copy_to_user(buf,pbufp->pb_data,length);
                        if (err)
			{
				pcb_unlock(ref);
                                return err;
			}

                        err = copy_to_user(len, &length ,sizeof(int));
                        if (err)
			{
				pcb_unlock(ref);
                                return err;
			}

                        /* shift the pointer */
                        pbufp->pb_data += (length);
                        pbufp->pb_dlen -= (length);

                        break;
                }

                err = copy_to_user(buf,pbufp->pb_data,pbufp->pb_dlen);
                if (err)
		{
			pcb_unlock(ref);
                        return err;
		}

                err = copy_to_user(len, &(pbufp->pb_dlen),sizeof(int));
                if (err)
		{
			pcb_unlock(ref);
                        return err;
		}

                p_pcb->up_delfirst = pbufp->pb_next;
                if (p_pcb->up_delfirst == NULL)
                        p_pcb->up_dellast = NULL;
                freepbuf(pbufp);

                p_pcb->up_rcv_win += 1;

                if (p_pcb->up_rcv_win == 1)
                {
                        /* window just opened;inform peer */
                        if(sendctl(AK_TYPE,ref)<0)
			{
				pcb_unlock(ref);
                                return -1;
			}
                }

                break;

    	case UTPCOM_NBACCEPT:
    	case UTPCOM_ACCEPT:
        {
        	conbuf_t *cb;
    
		lock_kernel();
		
		/* server should be in LSTNG state */
        	if (p_pcb->up_state != LSTNG) 
		{
			pcb_unlock(ref);
            		return ERR_INVALID;
		}
        
		/* for UTPCOM_NBACCEPT */	
		if (command==UTPCOM_NBACCEPT && p_pcb->up_rdyfirst==NULL) 
		{
			pcb_unlock(ref);
            		return ERR_NODATA;
		}

		if (p_sock->state != TCP_LISTEN) {
                	p_sock->ack_backlog = 0;
                	p_sock->state = TCP_LISTEN;
        	}
		p_sock->socket->flags |= SO_ACCEPTCON;

		/* for UTPCOM_ACCEPT */
        	while (p_pcb->up_rdyfirst == NULL)
		{
		        if (signal_pending(current))
                        	break;
            		pcbblock(ref);
		}
		pcbunblock(ref);

		/*  assign the front of list of open connection id to len */
        	cb = p_pcb->up_rdyfirst;
		err = copy_to_user(len, &(cb->cb_conn),sizeof(int));
    		if (err)
		{
			pcb_unlock(ref);
    			return err;
		}
        	p_pcb->up_rdyfirst = cb->cb_next;
        	freeconbuf(cb);
        	if (p_pcb->up_rdyfirst==NULL)
            		p_pcb->up_rdylast = NULL;

		unlock_kernel();
        	break;
	}
      	}	/* switch */
	pcb_unlock(ref);
    	return 0;
}

        




