/*  timeout.c -- aux routines for timeouts.		*/
#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/utp/utptimeout.h>
#include <linux/utp/utppcb.h>
#include <linux/timer.h>
#include <linux/sched.h>

/* Arrange for func to be called with argument arg in when "ticks" */
void startTimer(struct timer_list *tp, int when, void (*func)(), int arg)
{
  	if(when < 0)
  	{
		printk("when = %d ", when);
		printk("StartTimer called with nonpositive arg\n");
		return ;
  	}
	if(when == 0)
		when ++;

	init_timer(tp);
  	tp->expires =  jiffies+when; 
  	tp->function = func;
  	tp->data = arg;

	add_timer(tp);
  	return ;
}

/* Modify the timer */
void modifyTimer(struct timer_list *tp, int when, void (*func)(), int arg)
{
  	if(when <= 0)
  	{
		printk("modifyTimer called with nonpositive arg\n");
		return ;
  	}
   	del_timer (tp);

	init_timer(tp);
  	tp->expires =  jiffies+when; 
  	tp->function = func;
  	tp->data = arg;

	add_timer(tp);
  	return ;
}

/* Cancel the timer */
void cancelTimer(struct timer_list *tp)
{
   	if (tp==NULL) 
   	{
		printk("Tried to cancel a NULL timeout\n");
		return;
   	}

   	del_timer (tp);
	tp = NULL;
   	return;
}
