#include <linux/socket.h>
#include <linux/sched.h>
#include <net/sock.h>
#include <net/ip.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/mm.h>
#include <linux/net.h>
#include <linux/file.h>
#include <linux/smp_lock.h>
#include <linux/string.h>
#include <linux/tcp.h>
#include <linux/netdevice.h>
#include <linux/proc_fs.h>
#include <net/utp.h>
#include <linux/utp/utppdu.h>
#include <linux/utp/utppcb.h>
#include <linux/utp/utpaux.h>
#include <linux/utp/utptimeout.h>
#include <net/checksum.h>
#include <net/icmp.h>

extern int AddressToString(Addr_t *, char *);
extern int AddressToStr(u32 , char *);
extern int inet_autobind(struct sock* );
/* this function returns the checksum for the pdu */
__u32 csum_utp(__u32 *wp, int pdulen)
{
__u32 csum=0;
u_char *cp;

	while (pdulen >= 4) 
    	{
        	csum ^= *wp++;
        	pdulen -= 4;
    	}

    	if (pdulen) 
    	{
        	int index;
		printk("pdu is not multiple of four \n");
        	cp = (u_char *) wp;
        	for (index=pdulen; index<4; index++)
            		cp[index] = (__u32) 0;
        	csum ^= *wp;
    	}
    	return csum;
}

/* This function sends the control PDU like CR, CA, C3, XX, XA, PB, AK */
int sendctl(int which, int ref)
{
pcb_t *p_pcb;
pdu_t send_pdu;		// the pdu to be sent
struct sockaddr_in *usin;
int size=0;		// size of pdu
int err= 0xAABB;

int ulen;
struct rtable *rt;
u32 nexthop, daddr;
struct utphdr *uh;
int tmp;
struct sk_buff *skb;
struct sock *p_sock;

int utp_header_size = sizeof(struct utphdr);

	p_pcb = &pcbs[ref];
	
	send_pdu.ch_destref = p_pcb->up_remref;
	send_pdu.ch_vers = UTP_VERSION;
	send_pdu.ch_type = which;
	send_pdu.ch_csum = CSUMRESULT;

	/* fill in the send_pdu depending on which */ 
	switch(which)
	{
	case CR_TYPE:
		send_pdu.cr_origport = p_pcb->up_localport;
		send_pdu.cr_destport = p_pcb->up_remport;
		send_pdu.cr_origref = ref;
		send_pdu.cr_initwin = p_pcb->up_rcv_win;
		size = sizeof(cr_pdu_t);
		break;

	case CA_TYPE:
		send_pdu.ca_origport = p_pcb->up_remport;
		send_pdu.ca_destport = p_pcb->up_localport;
		send_pdu.ca_respref = ref;
		send_pdu.ca_initwin = p_pcb->up_rcv_win;
		size = sizeof(ca_pdu_t);
		break;

	case C3_TYPE:
    	case XX_TYPE:
    	case PB_TYPE:
		size = sizeof(c3_pdu_t);
		break;

    	case AK_TYPE:
		printk("sending AK pdu with ack seq no %d\n",p_pcb->up_rcv_nxt);
        	send_pdu.a_ack = p_pcb->up_rcv_nxt;
        	send_pdu.a_subseq = p_pcb->up_rcv_acnt++; /* automatic modulus */
        	send_pdu.a_win = p_pcb->up_rcv_win;
        	p_pcb->up_flags &= ~ACK_OWED;      /* not owed any more ! */
        	size = sizeof(a_pdu_t);
        	break;

	default:
		return ERR_INVALID;	
	
	}

	/* compute checksum on send_pdu */
	send_pdu.ch_csum = csum_utp((__u32 *)&send_pdu,size);
    	usin = (struct sockaddr_in *)&(p_pcb->up_rempsip);

	if(p_pcb->up_sock == NULL)
	{
		printk("p_pcb->up_sock NULL \n");
                return -EAGAIN; 
	}

	p_sock = p_pcb->up_sock;
		
        if(inet_autobind(p_sock) != 0)
	{
		printk("Error in inet_autobind\n");
                return -EAGAIN; 
	}

       	nexthop = daddr = usin->sin_addr.s_addr;

       	if (p_sock->opt && p_sock->opt->srr)
       	{
               	if (daddr == 0)
                       	return -EINVAL;
               	nexthop = p_sock->opt->faddr;
       	}
       	err = ip_route_output(&rt, nexthop, p_sock->saddr,
        	RT_TOS(p_sock->ip_tos)|RTO_CONN|p_sock->localroute, p_sock->bound_dev_if);
       	if (err < 0)
	{
		printk("Error in ip_route_connect\n");
               	return err;
	}

       	dst_release(xchg(&p_sock->dst_cache, rt));

       	p_sock->dport = usin->sin_port;
	p_sock->daddr = rt->rt_dst;
       	if (p_sock->opt && p_sock->opt->srr)
               	p_sock->daddr = daddr;
       	if (!p_sock->saddr)
               	p_sock->saddr = rt->rt_src; 
       	p_sock->rcv_saddr = p_sock->saddr;

	tmp = MAX_HEADER + p_sock->prot->max_header + size;
	skb = alloc_skb(tmp, GFP_ATOMIC);
	if(!skb)
	{
		printk("Error in sock_wmalloc\n");
		return -1;
	}
	skb_reserve(skb, MAX_HEADER + p_sock->prot->max_header);
	bcopy((char *)&send_pdu, skb_put(skb, size), size);

	lock_sock(p_sock);
	p_sock->prot->hash(p_sock);
        uh = (struct utphdr *) skb_push(skb, utp_header_size);
        skb->h.uth = uh;
        skb_set_owner_w(skb, p_sock);

	uh->source = p_sock->sport;
	uh->dest = p_sock->dport;
	uh->len = size + utp_header_size;
	uh->check = 0;
	
	/* calling the ip layer */
	ip_queue_xmit(skb);

        utp_statistics.UtpOutDatagrams++;
	release_sock(p_sock);
	return size;
}

int senddata(int ref, pbuf_t *pbuf)
{
pcb_t *p_pcb;
pdu_t *du;
int size;
int len,err,ulen;
int tmp;
struct rtable *rt;
struct sk_buff *skb;
struct sockaddr_in *usin;
u32 nexthop, daddr;
struct utphdr *uh;
struct sock *p_sock;
int utp_header_size = sizeof(struct utphdr);

        p_pcb = &pcbs[ref];
        du = &pbuf->pb_pdu;
        /* check whether we owe an ack.  If so, send AD, else send D */
        if (p_pcb->up_flags & ACK_OWED)
        {
                size = sizeof(struct comhdr) +
                        sizeof(struct a_rest) +
                        sizeof(struct d_rest);

                /* fill in the pdu*/
                du->ch_destref = p_pcb->up_remref;
                du->ch_vers = UTP_VERSION;
                du->ch_type = AD_TYPE;
                du->ch_csum = CSUMRESULT;
                du->ad_ack = p_pcb->up_rcv_nxt;
                du->ad_win = p_pcb->up_rcv_win;
                du->ad_subseq = p_pcb->up_rcv_acnt++;
                du->ad_seq = pbuf->pb_seq;
                du->ad_len = pbuf->pb_dlen;
                du->ch_csum = pbuf->pb_dcsum ^ csum_utp((__u32 *)du,size);
                //du->ch_csum = pbuf->pb_dcsum ^ csum_partial((u_long *)du,size,0);

                len = du->ad_len+size;
                p_pcb->up_flags &= ~ACK_OWED;      /* not any more! */

        }
        else
        {
                /* send data with no ack info */
                size = sizeof(struct comhdr) + sizeof(struct d_rest);

                du->sd_destref = p_pcb->up_remref;
                du->sd_vers = UTP_VERSION;
                du->sd_type = DT_TYPE;
                du->sd_csum = CSUMRESULT;
                du->sd_seq = pbuf->pb_seq;
                du->sd_len = pbuf->pb_dlen;
                du->sd_csum = pbuf->pb_dcsum ^ csum_utp((__u32 *)&(du->sd.ch), size);
                //du->sd_csum = pbuf->pb_dcsum ^ csum_partial((u_long *)&(du->sd.ch), size, 0);
                len = du->sd_len+size;

        }

        usin = (struct sockaddr_in *)&(p_pcb->up_rempsip);
        ulen = len + sizeof(struct utphdr);
        if(p_pcb->up_sock == NULL)
        {
                printk("p_pcb->up_sock NULL \n");
                return -EAGAIN;
        }

        p_sock = p_pcb->up_sock;

        if(inet_autobind(p_sock) != 0)
	{
		printk("Error in inet_autobind\n");
                return -EAGAIN;
	}

        nexthop = daddr = usin->sin_addr.s_addr;

        if (p_sock->opt && p_sock->opt->srr)
        {
                if (daddr == 0)
                        return -EINVAL;
                nexthop = p_sock->opt->faddr;
        }
        err = ip_route_output(&rt, nexthop, p_sock->saddr,
                RT_TOS(p_sock->ip_tos)|RTO_CONN|p_sock->localroute, p_sock->bound_dev_if);
        if (err < 0)
        {
                printk("Error in ip_route_connect\n");
                return err;
        }

        dst_release(xchg(&p_sock->dst_cache, rt));

        p_sock->dport = usin->sin_port;
        p_sock->daddr = rt->rt_dst;
        if (p_sock->opt && p_sock->opt->srr)
                p_sock->daddr = daddr;
        if (!p_sock->saddr)
                p_sock->saddr = rt->rt_src;
        p_sock->rcv_saddr = p_sock->saddr;

        tmp = MAX_HEADER + p_sock->prot->max_header + len;
        //skb = sock_wmalloc(p_sock, tmp, 0, GFP_KERNEL);
        skb = alloc_skb( tmp, GFP_ATOMIC);
        if(!skb)
	{
		printk("Error in  sock_wmalloc\n");
                return -1;
	}
        skb_reserve(skb, MAX_HEADER + p_sock->prot->max_header);
        bcopy((char *)&(du->sd.ch), skb_put(skb, len), len);

        lock_sock(p_sock);
        p_sock->prot->hash(p_sock);
        uh = (struct utphdr *) skb_push(skb, utp_header_size);
        skb->h.uth = uh;
        skb_set_owner_w(skb, p_sock);

        uh->source = p_sock->sport;
        uh->dest = p_sock->dport;
        uh->len = len + utp_header_size;
        uh->check = 0;

        /* calling the ip layer */
        ip_queue_xmit(skb);

        utp_statistics.UtpOutDatagrams++;
        release_sock(p_sock);
	//sock_wfree(skb);
	//kfree_skb(skb);
	
        return len;             
}


/* retransmit one of the conn mgmt PDUs.  */
void retransctl(int ref)
{
pcb_t *p_pcb;
int delay = 0;
int freeze_to;

    	/* paranoia */
    	if (ref< 1 || ref>= MAXPCB)     
        	return;
    	p_pcb = &pcbs[ref];

    	if (++(p_pcb->up_retries) < MAXRETRY) 
	{
        	switch (p_pcb->up_state) 
		{
        	case AOPNG:
            		sendctl(CR_TYPE,ref);
            		delay = CR_RTO;
            		break;
        	case POPNG:
            		sendctl(CA_TYPE,ref);
            		delay = CA_RTO;
            		break;
        	case PCLSNG:
            		sendctl(XX_TYPE,ref);
            		delay = 2 * p_pcb->max_rtt/1000;
            		break;
        	default:        
            		return;
        	}

        	startTimer(p_pcb->up_cto, delay,(void *)retransctl,ref);

    	} 
	else 
	{       /* give up */
        	switch (p_pcb->up_state) 
		{
        	case POPNG:
            		p_pcb->up_state = FROZEN;
			freeze_to = SAFETY_FACTOR * p_pcb->max_rtt /1000;
            		startTimer(p_pcb->up_cto, freeze_to,(void *)freepcb,(int) ref);
            		break;

        	default:
            		pcbunblock(ref);    
				/* else they'll never wakeup! */

        	} /* switch */
    	}

} /* retransctl */

/* send connection confirm (C3) PDU */
void sendC3(int ref)
{
    	sendctl(C3_TYPE,ref);
}

/* send probe pdu which will force the peer to send the ack*/
void sendprobe(int ref)
{
pcb_t *p_pcb;
int delay;

        p_pcb = &pcbs[ref];

        if (p_pcb->up_state==OPEN && p_pcb->up_snd_win==0 &&
                p_pcb->up_unsentfirst != NULL)
        {
                /* something to send but send window is closed */
                sendctl(PB_TYPE,ref);
            	delay = 2 * p_pcb->max_rtt/1000;
                startTimer(p_pcb->up_cto,delay,(void *)sendprobe,ref);
                p_pcb->up_flags |= PB_PENDING;
        }
        else if (p_pcb->up_state==OPEN)
        {
                p_pcb->up_flags &= ~PB_PENDING;
        }

}

void retransdata(int ref)
{
pcb_t *p_pcb;
pbuf_t *pbuf;
unsigned int rto=0;

        if (ref< 1 || ref>= MAXPCB)
                return;

        p_pcb = &pcbs[ref];
	pcb_lock(ref);

        /* reduce the size of congestion window by half */
        p_pcb->congest_window /= 2;
	if(p_pcb->congest_window < 1)
		p_pcb->congest_window = 1;
        p_pcb->congest_threshold = p_pcb->congest_window;

	/* to ignore the rtt calculation */
	p_pcb->startmicro = -1;
		
        p_pcb->up_flags &= ~RTTO_PENDING;
        if (p_pcb->up_state != OPEN || p_pcb->up_sentfirst == NULL)
        {       /* nothing to do */
		pcb_unlock(ref);
                return;
        }

        pbuf = p_pcb->up_sentfirst;

	if(p_pcb->slowstart_ref == -1)
        	p_pcb->slowstart_ref = pbuf->pb_seq;

        if(senddata(ref,pbuf)<0)
	{
		printk("Error in senddata\n");
		pcb_unlock(ref);
        	return;
	}
        rto = (2 * p_pcb->rtt)/1000;

       	startTimer(p_pcb->up_sto,rto,(void *)retransdata,ref);
       	p_pcb->up_flags |= RTTO_PENDING;

	pcb_unlock(ref);
        return;
}

/* This routine causes an ack to be sent if one hasn't in the meantime. */
/* It is the only way up_ato gets set to NULL                           */
void sendack(int ref)
{
pcb_t *p_pcb;
        p_pcb = &pcbs[ref];
        if ((p_pcb->up_state == OPEN) && (p_pcb->up_flags & ACK_OWED))
        {
                sendctl(AK_TYPE,ref);  /* this resets the flag */
        }
        return;
}












		

	
	




