#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/socket.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/net.h>
#include <linux/proc_fs.h>
#include <linux/utp/utp.h>
#include <linux/utp/utppdu.h>
#include <linux/utp/utppcb.h>
#include <net/udp.h>

/* This function converts address in dotted decimal format to string */
int AddressToString(Addr_t *address,char *string)
{
        if(string==NULL)  
        {
              printk("AddressToString given NULL string\n");
              return -1;
        }
        if(address==NULL)
        {
              printk("AddressToString given NULL address\n");
              return -1;
        }
  	sprintf(string,"%u.%u.%u.%u!%d",
        	(unsigned int)ntohl(address->sa.sin_addr.s_addr)>>24 & 0xff,
        	(unsigned int)ntohl(address->sa.sin_addr.s_addr)>>16 & 0xff,
        	(unsigned int)ntohl(address->sa.sin_addr.s_addr)>>8 & 0xff,
        	(unsigned int)ntohl(address->sa.sin_addr.s_addr) & 0xff,
        	(int)(address->sa.sin_port));
	
        return 0;
}

int AddressToStr(u32 address,char *string)
{
  	sprintf(string,"%u.%u.%u.%u",
        	(unsigned int)ntohl(address)>>24 & 0xff,
        	(unsigned int)ntohl(address)>>16 & 0xff,
        	(unsigned int)ntohl(address)>>8 & 0xff,
        	(unsigned int)ntohl(address) & 0xff);
	
        return 0;
}
/*  This function returns 1 */                                                                                                                                                                                                                
int IsWildcardAddress(Addr_t *addr)
{
        char tempString[ADDR_STRING_LEN];  
   
        if(addr==NULL)
        {
                printk("IsWildcardAddress given NULL addr\n");
                return 0;
        }
 
        if(AddressToString(addr,tempString)!=0)
        {
                printk("Unable to convert from address to string\n");
                return 0;
        }

        return (! strcmp(tempString,"0.0.0.0!0"));
}


int EqualAddresses(Addr_t *one,Addr_t *two)
{
  	char oneString[ADDR_STRING_LEN];
  	char twoString[ADDR_STRING_LEN];
                
  	if(one == NULL)
  	{
        	printk("IsWildcardAddress given NULL one");
        	return 0;
  	}
 
  	if(two == NULL)
  	{
        	printk("IsWildcardAddress given NULL two");
        	return 0;
  	}
  	if (IsWildcardAddress(one)) 
		return 1;
  	if (IsWildcardAddress(two)) 
		return 1;
   
        
  	if(AddressToString(one,oneString)!=0)
  	{
        	printk("Unable to convert one to a string");
        	return 0;
  	}

  	if(AddressToString(two,twoString)!=0)
  	{
        	printk("Unable to convert two to a string");
        	return 0;
  	}
        
  	return (! strcmp(oneString,twoString));  
}  


