/* implements the system call sys_utpClose() */

#include <asm/uaccess.h>
#include <asm/system.h>
#include <linux/socket.h>
#include <net/sock.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/net.h>
#include <linux/proc_fs.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/utp/utp.h>
#include <linux/utp/utppdu.h>
#include <linux/utp/utppcb.h>
#include <linux/utp/utpaux.h>
#include <linux/utp/utptimeout.h>
#include <net/utp.h>
#include <net/udp.h>

/* skip the CLOSED state, directly freeze the connection */
void abortconn(int indx)
{
pcb_t *p_pcb;
int freeze_to;
    
   	p_pcb = &pcbs[indx];
   	sendctl(XX_TYPE,indx);
   	p_pcb->up_state = FROZEN;
	freeze_to = SAFETY_FACTOR * p_pcb->max_rtt /1000;
   	startTimer(p_pcb->up_cto, freeze_to,freepcb,indx);
}

/* This system call is used to close the connection */
asmlinkage int sys_utpClose(utpConn_t ref)
{
pcb_t *p_pcb;		// pointer to pcb
int retval;
struct sock *p_sock; 
int delay, freeze_to;

	/* check for valid ref no */
    	if (ref < 1 || ref >= MAXPCB)
        	return ERR_INVALID;

    	p_pcb = &pcbs[ref];
	pcb_lock(ref);
        p_sock = p_pcb->up_sock;

    	switch(p_pcb->up_state) 
	{

    	case OPEN:
       		p_pcb->up_state = PCLSNG;
       		if (p_pcb->up_flags & RTTO_PENDING) 
		{           
         		cancelTimer(p_pcb->up_sto);
            		p_pcb->up_flags &= ~RTTO_PENDING;
        	}
		delay = 2 * p_pcb->max_rtt/1000;
        	startTimer(p_pcb->up_cto, delay, (void *)retransctl, ref);

      		if(sendctl(XX_TYPE,ref)<0)
		{
			pcb_unlock(ref);
			return -1;
		}

		/* block until you recieve XX */
        	while (p_pcb->up_state != CLOSED && p_pcb->up_retries<MAXRETRY)
		{
                	if (signal_pending(current))
                        	break;
            		pcbblock(ref);
		}

            	/* Input() will shut off the retrans timer, when XX arrives. */

    	case CLOSED:                        /* they may have closed first */
        	p_pcb->up_state = FROZEN;
		freeze_to = SAFETY_FACTOR * p_pcb->max_rtt /1000;
        	startTimer(p_pcb->up_cto,freeze_to,(void *)freepcb,ref);

        	retval = !(p_pcb->up_flags&CLEAN_CLOSE);

		pcb_unlock(ref);
        	return retval;

    	case LSTNG:        
        	/* abort them, skipping the CLOSED state. */
        	if (p_pcb->up_rdyfirst != NULL) 
		{
            		conbuf_t *p_conbuf, *temp;
            		p_conbuf = p_pcb->up_rdyfirst;
            		do 
			{
                		temp = p_conbuf->cb_next;
                		abortconn(p_conbuf->cb_conn);
                		p_conbuf = temp;
            		} while (p_conbuf != NULL);
        	}
        	freepcb(ref);
		pcb_unlock(ref);
        	return 0;


    	default:
		pcb_unlock(ref);
        	return ERR_INVALID;
    	}
	pcb_unlock(ref);
    	return -1;          
}


