/****************************************************************/
/*     utp.h -- defines/prototypes utp constants/types/macros	*/
/*     as defined in the utp protocol spec.                     */
/*                                                              */
/****************************************************************/
#ifndef UTP_H
#define UTP_H
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/socket.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/ip.h>
#include <linux/netdevice.h>
#include <linux/uio.h>
#include <linux/time.h>
#include <net/sock.h>
#include <net/snmp.h>
#include "utppdu.h"

#define UTPSEQ_LT(a,b)     ((short)((a)-(b)) < 0)
#define MIN(a,b)     (a < b ? a : b )

#define INITWIN   8	/* init window size */
#define MAXRETRY 5		/* max retries */
#define ADDR_STRING_LEN 100
#define UTP_VERSION 2
#define CSUMRESULT 0xfaceface	/* for checksum */
#define MAXPCB  5		/* max no. of pcbs */
#define MAXPBUF 100		/* max bo. of buffers */
#define MAXCBUF  5 		/* max connection buffers */
#define MAX_SOCK_ADDR 128
#define SAFETY_FACTOR 10

#define UTP_ACTIVE      1	/* for active connection */
#define UTP_PASSIVE     2	/* for passive connection */

/* The legal error codes from utp functions */
typedef enum utpErrors {
	ERR_ABORT=-1000,
	ERR_TIMEOUT,
	ERR_INVALID,
	ERR_NOTCONN,
	ERR_TOOMANY,
	ERR_REFUSED,
	ERR_NODATA,
	ERR_NOBUFS,
	ERR_CLOSED,
	ERR_TOOBIG
} utpErrors_t;

typedef u_short utpPort_t;
typedef int utpConn_t;

/* different commands available with utp_usreq system call */
#define UTPCOM_SEND	100
#define UTPCOM_RCV	101
#define UTPCOM_NBRCV	102
#define UTPCOM_STAT	103
#define UTPCOM_ABORT	104	/* Currently not implemented */
#define UTPCOM_NBACCEPT	105
#define UTPCOM_ACCEPT	106

/* connection states    */

#define IDLE    -1
#define MARKED 1024
#define LSTNG   0
#define AOPNG   1
#define POPNG   2
#define OPEN    3
#define PCLSNG  4
#define CLOSED  8
#define FROZEN  32

/* flags, mostly for top-half bottom-half communication */

#define RTTO_PENDING    16      /* pending timeout? */
#define ACK_OWED        32	/* ack owed? */
#define PB_PENDING      64	/* probe pending ? */
#define CLEAN_CLOSE     128     /* inform top half whether XX or XA rcv'd */

/* utpheader */ 
struct utphdr 
{
	unsigned short        source;
	unsigned short        dest;
	unsigned short        len;
	unsigned short        check;
};

struct utpfakehdr
{
       	struct utphdr uh;
        __u32 daddr;
        __u32 saddr;
	struct iovec iov;
        __u32 wcheck;
};

typedef struct psip_addr 
{
 	struct sockaddr_in sa;
} Addr_t;
	
typedef struct utp_ports
{
	int lport;		/* local port */
	int dport;		/* destination port */
} utpPorts_t;

/* element of the list of connections waiting to be UTPCOM_ACCEPTed */
/* This only goes in a pcb created as a result of a PASSIVE open.   */

typedef struct conbuf {
   int cb_conn;                 /* indx of the pcb.             */
   struct conbuf *cb_next;      /* list of ready connections    */
} conbuf_t;

/* structure returned from status call */
struct utp_stat 
{
	int utps_st;		/* state */
	u_short utps_snxt,	/* first unacked */
		utps_sndlim,	/* first unsendable */
		utps_rnxt;	/* first unreceived */
	u_char utps_rw;		/* receive window */
};

/* global variables */
int first_time ;		/* for calling utpInit */
struct utp_mib utp_statistics;
conbuf_t conbufs[MAXCBUF];
conbuf_t *conbuffreelist;


/* function prototypes */
void utpInit(void);
extern int utp_rcv(struct sk_buff *skb, unsigned short len);
extern struct sock *utp_v4_lookup(u32 saddr, u16 sport, u32 daddr, u16 dport, 
	int dif);
extern int utp_queue_rcv_skb(struct sock * sk, struct sk_buff *skb);
extern int utpInput(char *inbuf, int buflen, Addr_t *from);
extern struct socket *sockfd_lookup(int fd, int *err);
extern int EqualAddresses(Addr_t *one, Addr_t *two);
extern int IsWildcardAddress(Addr_t *addr);
extern void sendack(int);
extern int senddata(int, pbuf_t *);
extern void retransdata(int);
extern int sendctl( int, int);
extern void retransctl (int);
extern void sendprobe(int);
extern __u32 copyandcsum(char *fp, __u32 *wp, int pdulen);
extern __u32 csum_utp(__u32 *wp, int pdulen);

#endif /* UTP_H */
