#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>  /* for gethostbyname() and struct hostent */
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <netinet/in.h> /* for sockaddr_in */
#include <sys/time.h>   /* for struct timeval */
#include <string.h>
#include <syscall.h>
#include <ctype.h>
#include <unistd.h>
#include "test_server.h"

int AddressToString(Addr_t *address,char *string)
{
  if(string==NULL)
  {
    printf("AddressToString given NULL string\n");
    return -1;
  }
  if(address == NULL)
  {
       printf("AddressToString given NULL address");
       return -1;
  }

  sprintf(string,"%u.%u.%u.%u!%d",
        (unsigned int)ntohl(address->sa.sin_addr.s_addr)>>24 & 0xff,
        (unsigned int)ntohl(address->sa.sin_addr.s_addr)>>16 & 0xff,
        (unsigned int)ntohl(address->sa.sin_addr.s_addr)>>8 & 0xff,
        (unsigned int)ntohl(address->sa.sin_addr.s_addr) & 0xff,
        (int)(address->sa.sin_port));

  return 0;
}

int psipStringToAddress(char *string,Addr_t *address)
{
  int a,b,c,d,p;

  if(string==NULL)
  {
  	printf("psipStringToAddress given NULL string");
        return -1;
  }
  if(address==NULL)
  {
  	printf("psipStringToAddress given NULL address");
        return -1;
  }

  address->sa.sin_family = ourPSIPAddr.sa.sin_family;

  /* throw away leading blanks, since they make gethostbyname() choke.  */
  while (string[0]==' ' || string[0]=='\t') string++;

  /* is the first character a digit?
     If so, we assume "w.x.y.z!port"
     If not, we assume "hostname!port" */
  if (isdigit(string[0]))
  {
    if(sscanf(string,"%d.%d.%d.%d!%d",&a,&b,&c,&d,&p) != 5)
    {
       printf("Unable to parse address\n");
       return -1;
    }
    address->sa.sin_addr.s_addr = a<<24 | b<<16 | c<<8 | d;
    address->sa.sin_port = p;
  }
  else /* we dont have a digit first */
  {
    char *port;

    /* find the '!' in string: format must be hostname!port*/
      if( (port = index(string,'!')) == NULL)
      {
          printf("Unable to parse address");
	  return -1;
      }

    /* split string in two... hostname\0port\0 and increment port past \0 */
      *port++ = '\0';

    /* look-up hostentry for the hostname */
    {
      struct hostent *destHostEntry;

      /* find the hostEntry for string */
      if( (destHostEntry = gethostbyname(string)) == NULL)
      { 
            printf("Unable to get address for our string");
            return -1;
      }
      /* copy the address from the hostEntry into ourPSIPAddr.sa */
      bcopy(destHostEntry->h_addr_list[0], &address->sa.sin_addr.s_addr,
      					destHostEntry->h_length);


      address->sa.sin_port = atoi(port);
    } /* look-up the hostentry for hostname */

  } /* else (we have hostname!port) */

  return 0;
}

int OSinit(myport)
{
  unsigned long args[3];
  if (ourSocket != -1)
  {
    /* We're already initialized, just return 0 */
    return 0;
  }
  args[0]= (u_long)AF_INET;
  args[1]= (u_long)SOCK_UTP_DGRAM;
  args[2]= (u_long)0;
  if((ourSocket = syscall(102,SYS_SOCKET,args)) < 0)
  {
    printf("SYS_SOCKET = %d\n",SYS_SOCKET);
    printf("Failed to allocate our socket!");
    return 0;
  }
  ourPSIPAddr.sa.sin_addr.s_addr = INADDR_ANY;  
  ourPSIPAddr.sa.sin_port = myport;
  ourPSIPAddr.sa.sin_family = AF_INET;
  if (bind(ourSocket, (struct sockaddr *) &ourPSIPAddr.sa,
			sizeof(ourPSIPAddr.sa)) < 0)
  {
     printf("Unable to bind our socket!");
     return 0;
  }

  {
    char ourHostName[200];
    struct hostent *ourHostEntry;
      
    /* first, find our local hostname */  
    if(gethostname(ourHostName, sizeof(ourHostName)) != 0)
    {
	printf("Unable to get our hostname");
	return 0;
    }
                          
    /* now, find the hostEntry for our hostname */
    if((ourHostEntry = gethostbyname(ourHostName)) == NULL)
    {
    	printf("Unable to get address for our hostname");
    	return 0; 
    }

    /* copy the address from the hostEntry into ourPSIPAddr.sa */
    bcopy(ourHostEntry->h_addr_list[0],&ourPSIPAddr.sa.sin_addr.s_addr,
      					ourHostEntry->h_length);
  }
  return 1;
}
	
int main()
{
  int myport = SERVER_PORT;
  char destInput[40];
  Addr_t destAddr;
  char aString[40];
  int rv=0;
  //utpPort_t  activePort;
  utpPorts_t ports;
  utpConn_t echoConn;
  char databuf[MAX_UTP_DATA];
	int bufsize,result,dummy,i;

  if (OSinit(myport) <= 0) 
  {  
        printf("Error in initialization\n");
        exit(1);
  }
	
  ports.dport = 0;
  ports.lport = myport;
  bzero(&destAddr,sizeof(Addr_t));
  
  rv = syscall(191,ourSocket,&destAddr,ports,UTP_PASSIVE);
  if (rv < 0) 
  {
	printf("rv = %d\n",rv);
        printf("Open failed, returned %d\n",rv);
	return 0;
  }
  else
  {
	printf("rv = %d Successful\n",rv);
	echoConn = (utpConn_t) rv;
  }
  while (1)
  {
	bufsize = MAX_UTP_DATA;
        result = syscall(192,echoConn,UTPCOM_ACCEPT,&destAddr,&dummy);
        if (result < 0) 
	{
            printf("ACCEPT returned %d",result);
            continue;
        }
	//printf("dummy = %d\n",dummy);
	for(i=0;i<5;i++)
	{
        result = syscall(192,dummy,UTPCOM_RCV,(void *)databuf,&bufsize);
	if(result>=0)
	{
		//printf("The data recd is %s\n", databuf);
		//break;
	}
        else if (result==-998) 
	{
		printf("Invalid\n");
		getchar();
           	continue;      
        }
        else if (result==ERR_NODATA) 
	{
		printf("ERR_NODATA\n");
		getchar();
           	continue;      
        }
	}
	break;
	/*bufsize = 10;
        result = syscall(192,dummy,UTPCOM_RCV,(void *)&databuf,&bufsize);
	printf("!!!!!!!!!!!!!!!!!!!!!!!!!! result = %d\n",result);
	if(result>=0)
	{
		printf("The data recd is %s\n", databuf);
		break;
	}
        else if (result==-998) 
	{
		printf("Invalid\n");
		getchar();
           	continue;      
        }
        else if (result==ERR_NODATA) 
	{
		printf("ERR_NODATA\n");
		getchar();
           	continue;      
        }*/
  }
	sleep(2);
  	result = syscall(193,dummy);
  	//printf("result = %d\n",result);
  	if(result < 0)
         	printf("Close Unsuccessful\n");


	//printf("calling close from userspace\n");
	close(ourSocket);
	return 0;

	
}

