#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <assert.h>

#include "xmdefs.h"
#include "xmerror.h"

/* Tries to "connect" to the server socket specified and returns TRUE/FALSE if 
   it is successful/unsuccessful.  Information about the server to connect to 
   is pointed to by "current". */

Boolean 
xmConnectToServer(XServer *current, int serv_socket, 
                  struct hostent *xserver_info)
{
  struct in_addr *ptr;
  int retval;
  int tries;

  /* Open a socket for this X server */
  if ((current->socketd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    xmerror = SOCKETOPENERROR;
    xmErrorQuitSYS("xmConnectToServer() Cannot open socket");
  }

  /* Fill in sockaddr_in structure for this connection */
  memset((char *) &current->xserv_address, 0, sizeof(struct sockaddr_in));
  current->xserv_address.sin_family = AF_INET;

  /*  Dereference it into ptr for easier code reading */
  ptr = (struct in_addr *) *(xserver_info->h_addr_list);
  current->xserv_address.sin_addr.s_addr = ptr->s_addr;
  current->xserv_address.sin_port = htons(serv_socket);

  /* Try to connect to the server.  Try 5 times waiting 1 second between 
     tries. */
  for(tries = 0; tries < 5; tries++) {
    retval = connect(current->socketd, 
                    (struct sockaddr *) &current->xserv_address, 
                    sizeof(struct sockaddr_in));
		if (retval == -1) {
			xmErrorNoQuitSYS("xmConnectToServer - ");
			break;
    }
    if (retval == 0)
      break;  /* Made a successful connection */

    xmDEBUG("Trying to connect to %s\n", xserver_info->h_name);

    xmSleep(1000);   /* Make another attempt to connect after 1 second */
  }

  return retval == 0;
}


/* Gets information on a host.  Host could be a name or in dot address 
   format */
struct hostent *
xmGetHostInfo(char *host)
{
  struct sockaddr_in hostaddress; /* For gethostbyaddr() */

  /* host could be an address in dot notation or a name.  
     First, check if it is in dot notation */

  if (inet_addr(host) == -1) 
    /* It is not in dot notation, it must be a name */
    return gethostbyname(host);

  /* Dot notation address */
  memset((char *)&hostaddress, 0, sizeof(struct sockaddr_in));
  hostaddress.sin_family = AF_INET;
  hostaddress.sin_addr.s_addr = inet_addr(host);
  return gethostbyaddr((char *) &hostaddress.sin_addr, sizeof(struct in_addr), 
                       AF_INET);
}


/* This function connects to the X server running on host on which the 
   X multiplexer is also running */
void 
xmConnectToHostXServer()
{
  char host_name[MAXHOSTNAMELENGTH];
  struct hostent *host_info;

  host_xserver = (XServer *)malloc(sizeof(XServer));
  assert(host_xserver != NULL);

  gethostname(host_name, sizeof(host_name));
  if ((host_info = xmGetHostInfo(host_name)) == NULL) 
    xmErrorQuitSYS("Cannot get information on X server on xm's host");
    
  if (!xmConnectToServer(host_xserver, XPORTS_BASE+xserver_port, 
                         host_info)) 
    xmErrorQuit("Cannot connect to X server on xm's host");
  
  host_xserver->xserver_name = (char *)malloc(strlen(host_name) + 1);
  assert(host_xserver->xserver_name != NULL);
  strcpy(host_xserver->xserver_name, host_name);
  host_xserver->port = XPORTS_BASE+xserver_port;
}
  
/* This function goes to sleep with milliseconds precision.  num_msec holds the 
   number of milli-seconds to sleep */
int 
xmSleep(int num_msec)
{
  struct timeval tv;

  if (num_msec < 0)
    return -1;

  /* Number of full seconds in tv_sec */
  tv.tv_sec = num_msec/1000;
  /* Number of microseconds to wait */
  tv.tv_usec = (num_msec%1000)*1000;

  /* Return after waiting. */
  return select(0, NULL, NULL, NULL, &tv);
}

