package rbs.sim;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.CloneNotSupportedException;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Sphere extends Object3D implements Cloneable{

	public void computeMassMomentOfInertia(){
		//Ixx = Ioxx + md^2
		//Iyy = Ioyy + md^2
		//Izz = Iozz + md^2
		//Ioxx = Ioyy = Iozz = (2mr^2)/5
		float Io = 2.0f * this.getMass() * 
			(float)Math.pow(this.getRadius(), 2.0f);
		Io = Io / 5.0f;

		float dx = (float)Math.pow(this.getCenterOfMass().y, 2.0f) + 
			(float)Math.pow(this.getCenterOfMass().z, 2.0f);
		float Ixx = Io + (this.getMass() * dx);
		this.setMassMomentOfInertiaPitch(Ixx);

		float dy = (float)Math.pow(this.getCenterOfMass().x, 2.0f) +
			(float)Math.pow(this.getCenterOfMass().z, 2.0f);
		float Iyy = Io + (this.getMass() * dy);
		this.setMassMomentOfInertiaYaw(Iyy);

		float dz = (float)Math.pow(this.getCenterOfMass().x, 2.0f) +
			(float)Math.pow(this.getCenterOfMass().y, 2.0f);
		float Izz = Io + (this.getMass() * dz);
		this.setMassMomentOfInertiaRoll(Izz);

		this.getLogger().fine("Mass Moment of Inertia: " + 
			this.getMassMomentOfInertia());
	}

	//we need to get at the undecorated sphere
	public float getRadius(){
		return ((rbs.render.Sphere)this.getCoreModel()).getRadius();
	}

	public void setRadius(float radius){
		((rbs.render.Sphere)this.getCoreModel()).setRadius(radius);
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}
}
