package rbs.sim;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.CloneNotSupportedException;

import javax.vecmath.Vector3f;
import javax.vecmath.Matrix3f;

public class Plane extends Object3D implements Cloneable{
	private Vector3f normal;
	private Vector3f width;
	private Vector3f height;
	//used for local calculations
	private float localPitch;
	private float localRoll;
	private float localYaw;

	public Plane(){
		normal = new Vector3f(0.0f, 1.0f, 0.0f);
		width = new Vector3f(1.0f, 0.0f, 0.0f);
		height = new Vector3f(0.0f, 0.0f, 1.0f);
	}

	public void computeMassMomentOfInertia(){
		this.setMassMomentOfInertiaPitch(0.0f);
		this.setMassMomentOfInertiaYaw(0.0f);
		this.setMassMomentOfInertiaRoll(0.0f);
	}

	public float getWidth(){
		return ((rbs.render.Plane)this.getCoreModel()).getWidth();
	}

	public float getHeight(){
		return ((rbs.render.Plane)this.getCoreModel()).getHeight();
	}

	public Vector3f getNormal(){
		return this.normal;
	}

	public Vector3f getWidthVector(){
		return this.width;
	}

	public Vector3f getHeightVector(){
		return this.height;
	}

	public Vector3f transformVector(Vector3f vec){
		Vector3f ret = new Vector3f(vec);
		Matrix3f rotMatrix = new Matrix3f();
		rotMatrix.rotZ((float)Math.toRadians(this.localRoll));
		rotMatrix.transform(ret);
		rotMatrix.rotY((float)Math.toRadians(this.localYaw));
		rotMatrix.transform(ret);
		rotMatrix.rotX((float)Math.toRadians(this.localPitch));
		rotMatrix.transform(ret);
		return ret;
	}

	private void transformAllVectors(Matrix3f matrix){
		matrix.transform(normal);
		matrix.transform(width);
		matrix.transform(height);
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
		this.localPitch = 90.0f + this.getModel().getPitch();
		this.localRoll = this.getModel().getRoll();
		this.localYaw = this.getModel().getYaw();

		Matrix3f rotMatrix = new Matrix3f();
		rotMatrix.rotZ((float)Math.toRadians(localRoll));
		this.transformAllVectors(rotMatrix);
		rotMatrix.rotY((float)Math.toRadians(localYaw));
		this.transformAllVectors(rotMatrix);
		rotMatrix.rotX((float)Math.toRadians(localPitch));
		this.transformAllVectors(rotMatrix);
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}
}
