package rbs.sim;

import java.lang.CloneNotSupportedException;
import javax.vecmath.Vector3f;
import javax.vecmath.Point3f;
import java.lang.Float;

public class OneStepForce extends Force implements Cloneable{

	public OneStepForce(Vector3f force, Point3f origin, 
			boolean acceleration){
		super(force, origin, Float.MAX_VALUE, acceleration);
	}

	public OneStepForce(Vector3f direction, float magnitude, Point3f origin,
			boolean acceleration){
		super(direction, magnitude, origin, Float.MAX_VALUE, acceleration);
	}

	public boolean apply(float timeDelta, Object3D obj){
		this.setDuration(timeDelta);
		super.apply(timeDelta, obj);
		return true;
	}

	public Object Clone() throws CloneNotSupportedException{
		return super.clone();
	}
}
