package rbs.sim;

import java.lang.CloneNotSupportedException;
import javax.vecmath.Vector3f;
import javax.vecmath.Point3f;
import java.lang.Float;

public class NonImpulseForce extends Force implements Cloneable{

	public NonImpulseForce(Vector3f force, Point3f origin, 
			boolean acceleration){
		super(force, origin, Float.MAX_VALUE, acceleration);
	}

	public NonImpulseForce(Vector3f direction, float magnitude, Point3f origin,
			boolean acceleration){
		super(direction, magnitude, origin, Float.MAX_VALUE, acceleration);
	}

	public NonImpulseForce(Vector3f transAcceleration,Vector3f rotAcceleration){
		super(transAcceleration, rotAcceleration);
	}

	//Non-Impulse force class overwrite so timeDelta always 1 
	//   and always returns true
	public boolean apply(float timeDelta, Object3D obj){
		super.apply(1.0f, obj);
		return true;
	}

	public Object Clone() throws CloneNotSupportedException{
		return super.clone();
	}
}
