package rbs.sim;

import java.util.Hashtable;
import java.io.BufferedReader;
import java.io.IOException;

public class Material{
	private String name;

	private Hashtable<String, Float> staticCoefficiant;
	private Hashtable<String, Float> kineticCoefficiant;

	public Material(String name){
		this.name = name;
		staticCoefficiant = new Hashtable<String, Float>();
		kineticCoefficiant = new Hashtable<String, Float>();
	}

	public String getName(){
		return this.name;
	}

	public Float getStaticCoefficiant(String name){
		return staticCoefficiant.get(name);
	}

	public Float getKineticCoefficiant(String name){
		return kineticCoefficiant.get(name);
	}

	public void loadFromFile(BufferedReader input, int numMaterials) 
			throws IOException{
		//static entries
		for(int entry = 0; entry < numMaterials; entry++){
			//read line split on space add to static table
			String[] nameValuePair = input.readLine().split("\\s+", 2);
			staticCoefficiant.put(nameValuePair[0], 
				Float.parseFloat(nameValuePair[1]));
		}
		//kinetic entries
		for(int entry = 0; entry < numMaterials; entry++){
			String[] nameValuePair = input.readLine().split("\\s+", 2);
			kineticCoefficiant.put(nameValuePair[0], 
				Float.parseFloat(nameValuePair[1]));
		}
	}
}
