package rbs.sim;

import javax.vecmath.Vector3f;

public abstract class EventSim extends SimulationThread{
	
	public EventSim(String fileName, float endTime, boolean pauseOnCollision,
			Vector3f gravity, boolean isGravityForce){
		super(fileName, pauseOnCollision, gravity, isGravityForce);
		super.setEndTime(endTime);
		//need to add event at end time
	}

	protected synchronized void advanceTime(){
		//only forward time to the next event
	}
	protected synchronized void resumeTime(){
	}
	protected synchronized void rollbackTime(){
	}
}
