package rbs.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.File;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class TextureDecorator extends RenderableDecorator 
		implements Cloneable, Serializable{

	private transient Texture texture;

	private String textureFileName;

	public TextureDecorator(Renderable renderable){
		super(renderable);
		texture = null;
	}

	public void setFileName(String filename){
		this.textureFileName = filename;
	}

	public void loadTextureFromFile(){
		File file = new File(textureFileName);
		try{
			this.texture = TextureIO.newTexture(file, false);
		} catch(IOException e){
			System.out.println("Couldn't load texture " + textureFileName);
		}
	}

	//this will need some work
	public Object clone() throws CloneNotSupportedException{
		TextureDecorator td = (TextureDecorator)super.clone();
		td.setFileName(this.textureFileName);
		return (Object)td;
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
		this.setFileName(input.readLine());
	}

	public void renderOpenGL(GL gl, GLU glu, GLUquadric gluQuad){
		if(texture == null){
			this.loadTextureFromFile();
		}

		this.texture.enable();
		this.texture.bind();
		super.getCoreRenderable().renderOpenGL(gl, glu, gluQuad);
		this.texture.disable();
	}
}
