package rbs.render;

import rbs.reel.StillFrame;
import javax.vecmath.Point3f;

//renderer interface
public abstract class Renderer{
	private RenderState state;

	public void setState(RenderState state){
		this.state = state;
	}

	public RenderState getState(){
		return this.state;
	}

	abstract void initializeAPI(int x, int y, int width, int height);
	abstract void openWindow(String name);
	abstract void render(StillFrame frame);
	abstract void setFrustum(float frontLeft, float frontRight, 
		float near, float far);
	abstract void setCamera(Point3f location, Point3f lookAt);
	abstract void closeWindow();
	abstract void destroyWindow();
}
