package rbs.render;

import java.io.Serializable;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.CloneNotSupportedException;
import javax.vecmath.Point3f;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public abstract class Renderable implements Cloneable, Serializable{
	public static final float ROLL_X = 0.0f;
	public static final float ROLL_Y = 0.0f;
	public static final float ROLL_Z = 1.0f;

	public static final float PITCH_X = 1.0f;
	public static final float PITCH_Y = 0.0f;
	public static final float PITCH_Z = 0.0f;

	public static final float YAW_X = 0.0f;
	public static final float YAW_Y = 1.0f;
	public static final float YAW_Z = 0.0f;

	private Point3f location;
	private Point3f orientation;

	public Renderable(){
		location = new Point3f(0.0f, 0.0f, 0.0f);
		orientation = new Point3f(0.0f, 0.0f, 0.0f);
	}

	public boolean isDecorated(){
		return false;
	}

	public Point3f getOrientation(){
		return this.orientation;
	}

	public float getPitch(){
		return this.orientation.x;
	}

	public float getYaw(){
		return this.orientation.y;
	}

	public float getRoll(){
		return this.orientation.z;
	}

	public void setOrientation(Point3f orient){
		this.orientation = orient;
	}

	public void setOrientation(float pitch, float yaw, float roll){
		this.setPitch(pitch);
		this.setYaw(yaw);
		this.setRoll(roll);
	}

	public void setPitch(float pitch){
		this.orientation.x = pitch;
	}

	public void setYaw(float yaw){
		this.orientation.y = yaw;
	}

	public void setRoll(float roll){
		this.orientation.z = roll;
	}

	public Point3f getLocation(){
		return this.location;
	}

	public float getX(){
		return this.location.x;
	}

	public float getY(){
		return this.location.y;
	}

	public float getZ(){
		return this.location.z;
	}

	public void setLocation(Point3f loc){
		this.location = loc;
	}

	public void setLocation(float x, float y, float z){
		this.setX(x);
		this.setY(y);
		this.setZ(z);
	}

	public void setX(float x){
		this.location.x = x;
	}

	public void setY(float y){
		this.location.y = y;
	}

	public void setZ(float z){
		this.location.z = z;
	}

	public Object clone() throws CloneNotSupportedException{
		Renderable copy = (Renderable) super.clone();
		copy.setLocation((Point3f)this.getLocation().clone());
		copy.setOrientation((Point3f)this.getOrientation().clone());
		return (Object)copy;
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		this.setX(Float.parseFloat(input.readLine()));
		this.setY(Float.parseFloat(input.readLine()));
		this.setZ(Float.parseFloat(input.readLine()));
		this.setPitch(Float.parseFloat(input.readLine()));
		this.setYaw(Float.parseFloat(input.readLine()));
		this.setRoll(Float.parseFloat(input.readLine()));
	}

	abstract void renderOpenGL(GL gl, GLU glu, GLUquadric gluQuad);
}
