package rbs.render;

import rbs.SimulationState;
import rbs.reel.StillFrame;
import rbs.reel.BufferedFrameReel;

public class KeyFrameRenderer extends RendererThread{
	private float currentTime; //in milliseconds

	public KeyFrameRenderer(String name){
		super(name);
		this.currentTime = 0.0f;
	}

	public void run(){
		StillFrame frame = null;
		long startRender;
		long endRender;
		long renderTime;
		float goalTime;

		//first check simulation state object to see if we should shutdown
		while(!SimulationState.getInstance().isFinished()){
			//check states to see if need to rewind, ff, etc
			if(this.getCurrentReel() != null && 
					this.getCurrentReel().isBuffered()){
				BufferedFrameReel bfr =(BufferedFrameReel)this.getCurrentReel();
				if(SimulationState.getInstance().isFf()){
					SimulationState.getInstance().setFf(false);
					bfr.seekForward(
						SimulationState.getInstance().getJumpTime());
					currentTime = bfr.getCurrentFrame().getEndTime() * 1000;
				}
				else if(SimulationState.getInstance().isRew()){
					SimulationState.getInstance().setRew(false);
					bfr.seekBackward(
						SimulationState.getInstance().getJumpTime());
					currentTime = bfr.getCurrentFrame().getEndTime() * 1000;
				}
				else if(SimulationState.getInstance().isBegin()){
					SimulationState.getInstance().setBegin(false);
					bfr.seekBegin();
					currentTime = 0.0f;
				}
				else if(SimulationState.getInstance().isEnd()){
					SimulationState.getInstance().setEnd(false);
					bfr.seekEnd();
					currentTime = bfr.getCurrentFrame().getEndTime();
				}
			}

			if(!SimulationState.getInstance().isPaused()){

				if(this.getCurrentReel() == null){
					logger.severe("Renderer does not have a reel set.");
					SimulationState.getInstance().setFinished(true);
				}
				
				frame = this.getCurrentReel().popFrame();
				if(frame == null)
					continue;
				
				//render the frame and figure out how long it took
				startRender = System.currentTimeMillis();
				this.renderWindows(frame);
				endRender = System.currentTimeMillis();

				renderTime = endRender - startRender;
	
				//have to convert frame time to ms
				goalTime = frame.getEndTime() * 1000;

				//sleep if necessary
				if(this.currentTime + renderTime <= goalTime){
					try{
						Thread.sleep((long)(goalTime - 
							(this.currentTime + renderTime)));
					} catch(InterruptedException e){}
					this.currentTime = goalTime;
				}
				else{
					logger.info("Renderer is behind by " + 
						(this.currentTime + renderTime - goalTime) + "ms");
					this.currentTime += renderTime;
				}

				//check to make see if its the last frame or a pause was
				//requested
				if(frame.isLast() || frame.isPaused())
					SimulationState.getInstance().setPaused(true);
				
				logger.info("Current Renderer Time: " + this.currentTime +
					"ms, rendering took " + renderTime + "ms");
				//update our variables
				frame = null;
			}
			else{
				try{
					Thread.sleep(100);
				} catch(InterruptedException e){
					break;
				}
			}
		}
		//destroy all of the windows
		logger.info("Renderer Shut Down");
		this.shutdownRenderers();
	}
}
