package rbs.render;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class ColorDecorator extends RenderableDecorator 
		implements Cloneable, Serializable{
	private float red;
	private float green;
	private float blue;

	public ColorDecorator(Renderable renderable){
		super(renderable);
		red = 1.0f;
		green = 1.0f;
		blue = 1.0f;
	}

	public float getRed(){
		return this.red;
	}
	
	public float getGreen(){
		return this.green;
	}

	public float getBlue(){
		return this.blue;
	}

	public void setRed(float red){
		this.red = red;
	}

	public void setGreen(float green){
		this.green = green;
	}

	public void setBlue(float blue){
		this.blue = blue;
	}

	public void setRGB(float red, float green, float blue){
		this.red = red;
		this.green = green;
		this.blue = blue;
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
		this.setRed(Float.parseFloat(input.readLine()));
		this.setGreen(Float.parseFloat(input.readLine()));
		this.setBlue(Float.parseFloat(input.readLine()));
	}

	public void renderOpenGL(GL gl, GLU glu, GLUquadric gluQuad){
		gl.glColor3f(this.red, this.green, this.blue);
		super.getCoreRenderable().renderOpenGL(gl, glu, gluQuad);
	}
}
