package rbs.render;

import java.io.BufferedReader;
import java.io.Serializable;
import java.io.IOException;
import java.lang.CloneNotSupportedException;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import javax.vecmath.Point2f;

public class CheckerPlane extends Plane implements Cloneable, Serializable{
	private float sectionWidth;
	private float sectionHeight;
	private int horizontalDiv;
	private int verticalDiv;
	
	public CheckerPlane(){
		this.setHorizontalDivisions(5);
		this.setVerticalDivisions(5);
	}

	public int getHorizontalDivisions(){
		return this.horizontalDiv;
	}

	public void setHorizontalDivisions(int horDiv){
		this.sectionWidth = this.getWidth() / horDiv;
		this.horizontalDiv = horDiv;
	}

	public int getVerticalDivisions(){
		return this.verticalDiv;
	}

	public void setVerticalDivisions(int vertDiv){
		this.sectionHeight = this.getHeight() / vertDiv;
		this.verticalDiv = vertDiv;
	}

	public float getSectionWidth(){
		return this.sectionWidth;
	}

	public float getSectionHeight(){
		return this.sectionHeight;
	}

	public void loadFromFile(BufferedReader input) throws IOException{
		super.loadFromFile(input);
		this.setHorizontalDivisions(Integer.parseInt(input.readLine()));
		this.setVerticalDivisions(Integer.parseInt(input.readLine()));
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}

	private float[] modifyColor(float[] color, float percentage){
		float[] newColor = new float[color.length];
		for(int index = 0; index < color.length; index++){
			newColor[index] = color[index] * percentage;
		}
		return newColor;
	}

	public void renderOpenGL(GL gl, GLU glu, GLUquadric gluQuad){
		boolean light = false;
		float[] lightColor = null;
		float[] currentColor = new float[3];
		Point2f panelTopLeft = new Point2f();
		Point2f panelBottomRight = new Point2f();

		gl.glTranslatef(this.getX(), this.getY(), this.getZ());
		gl.glRotatef(this.getRoll(), ROLL_X, ROLL_Y, ROLL_Z);
		gl.glRotatef(this.getPitch(), PITCH_X, PITCH_Y, PITCH_Z);
		gl.glRotatef(this.getYaw(), YAW_X, YAW_Y, YAW_Z);
		gl.glGetFloatv(gl.GL_CURRENT_COLOR, currentColor, 0);

		Point2f topLeft = new Point2f(-this.getWidth() / 2.0f, 
			this.getHeight() / 2.0f);

		for(int row = 0; row < this.verticalDiv; row++){
			if(row % 2 == 0){
				light = true;
				if(lightColor == null){
					lightColor = modifyColor(currentColor, 0.50f);
				}
			}
			else{
				light = false;
			}

			gl.glBegin(gl.GL_QUADS);
			for(int column = 0; column < this.horizontalDiv; column++){
				if(light){
					gl.glColor3fv(lightColor, 0);
					light = false;
				}
				else{
					gl.glColor3fv(currentColor, 0);
					light = true;
				}
				panelTopLeft.x = topLeft.x + column * this.sectionWidth;
				panelTopLeft.y = topLeft.y - row * this.sectionHeight;
				panelBottomRight.x = panelTopLeft.x + this.sectionWidth;
				panelBottomRight.y = panelTopLeft.y - this.sectionHeight;
				this.renderQuad(gl, panelTopLeft, panelBottomRight);
			}
			gl.glEnd();
		}
	}
}
