package rbs.reel;

import java.util.ArrayDeque;
import rbs.render.Renderable;
import java.io.Serializable;

public class StillFrame implements Serializable{
	private ArrayDeque<Renderable> models;
	private float endTime;
	private boolean last;
	private boolean pause;

	public StillFrame(){
		models = new ArrayDeque<Renderable>();
		endTime = 0.0f;
		last = false;
		pause = false;
	}

	public StillFrame(int numObjects){
		models = new ArrayDeque<Renderable>(numObjects);
		endTime = 0.0f;
		last = false;
		pause = false;
	}

	public void setPause(boolean pause){
		this.pause = pause;
	}

	public boolean isPaused(){
		return this.pause;
	}

	public void setEndTime(float time){
		this.endTime = time;
	}

	public void setLast(boolean last){
		this.last = last;
	}

	public boolean isLast(){
		return this.last;
	}

	public float getEndTime(){
		return this.endTime;
	}

	public void addModel(Renderable obj){
		models.add(obj);
	}

	public int numModels(){
		return models.size();
	}

	public Renderable nextModel(){
		Renderable model = models.poll();
		//put it back on the queue
		models.add(model);
		return model;
	}
}
