package rbs.reel;

public class FrameReelFactory{
	private final static String STREAM_TYPE = "stream";
	private final static String BUFFERED_TYPE = "buffered";

	public static FrameReel newFrameReel(String type){
		FrameReel reel = null;
		if(type.equals(STREAM_TYPE)){
			reel = new StreamFrameReel();
		}
		else if(type.equals(BUFFERED_TYPE)){
			reel = new BufferedFrameReel();
		}
		return reel;
	}
}
