/*
 * Copyright (c) 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "LICENSE"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

package java.qsql;

import java.sql.Numeric;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Hashtable;

/**
 * <P>A ResultSet provides access to a table of data generated by
 * executing a Statement. The table rows are retrieved in
 * sequence. Within a row its column values can be accessed in any
 * order.
 * 
 * <P>A ResultSet maintains a cursor pointing to its current row of
 * data.  Initially the cursor is positioned before the first row.
 * The 'next' method moves the cursor to the next row.
 *
 * <P>The getXXX methods retrieve column values for the current
 * row.  You can retrieve values either using the index number of the
 * column, or by using the name of the column.  In general using the 
 * column index will be more efficient.  Columns are numbered from 1.
 *
 * <P>For maximum portability, ResultSet columns within each row should be
 * read in left-to-right order and each column should be read only once.
 *
 * <P>For the getXXX methods, the JDBC driver attempts to convert the
 * underlying data to the specified Java type and returns a suitable
 * Java value.  See the JDBC specification for allowable mappings
 * from SQL types to Java types with the ResultSet.getXXX methods.
 *
 * <P>Column names used as input to getXXX methods are case insensitive.
 * When performing a getXXX using a column name if several columns have
 * the same name then the value of the first matching column will be
 * returned.
 *
 * <P>A ResultSet is automatically closed by the Statement that
 * generated it when that Statement is closed, re-executed, or is used
 * to retrieve the next result from a sequence of multiple results.
 * 
 * <P>The number, types and properties of a ResultSet's columns are
 * provided by the ResulSetMetaData object returned by the getMetaData
 * method.
 *
 * @see Statement#executeQuery 
 * @see Statement#getResultSet 
 * @see ResultSetMetaData 
 */

public class QDDBResultSet implements java.sql.ResultSet {
    static int MAX_ROWS = 100;
    int NumRows;
    String Result = new String();
    QDDBaccess.QDDBBridge qddbBridge;
    /*Constructor*/
    public QDDBResultSet(QDDBaccess.QDDBBridge bridge){
	int i;
	
	//System.out.println("Constructor odf QDDBResultSet\n");

	//System.out.println("Initialising result set");
    	qddbBridge = bridge; 
	NumRows = qddbBridge.RowList.getNumRows();
	System.out.println("Number of rows = " + NumRows);
	System.out.println("\n");
    }
    public void FillRows(){
	int i, CurrentRow = 1;
	/*for (i = 1; i <= qddbBridge.getNumOfAttributes(); i++){
		if (qddbBridge.Database.Schema.Attribute[i].IsLeaf()){
			Rows[CurrentRow++] = qddbBridge.Database.Schema.
						Attribute[i].getFullName();
		}
	}
	NumRows = CurrentRow - 1;
        //System.out.println("The following are the rows");
	for(i = 1; i <= NumRows ; i++)
		//System.out.println("Row " + i + " = " + Rows[i]);*/
    }
		
    /**
     * A ResultSet is initially positioned before its first row; the
     * first call to next makes the first row the current row; the
     * second call makes the second row the current row, etc. 
     *
     * <P>If an input stream from the previous row is open it is
     * implicitly closed. The ResultSet's warning chain is cleared
     * when a new row is read.
     *
     * @return true if the new current row is valid; false if there
     * are no more rows 
     */
    public boolean next() throws SQLException{
	System.out.println(qddbBridge.getLastRowCopied());
	System.out.println("NumRows" + NumRows);
	return (qddbBridge.getLastRowCopied() < NumRows);
    }

    /**
     * In some cases, it is desirable to immediately release a
     * ResultSet's database and JDBC resources instead of waiting for
     * this to happen when it is automatically closed; the close
     * method provides this immediate release.
     *
     * <P><B>Note:</B> A ResultSet is automatically closed by the
     * Statement that generated it when that Statement is closed,
     * re-executed, or is used to retrieve the next result from a
     * sequence of multiple results. A ResultSet is also automatically
     * closed when it is garbage collected.  
     */
    public void close() throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * A column may have the value of SQL NULL; wasNull reports whether
     * the last column read had this special value.
     * Note that you must first call getXXX on a column to try to read
     * its value and then call wasNull() to find if the value was
     * the SQL NULL.
     *
     * @return true if last column read was SQL NULL
     */
    public boolean wasNull() throws SQLException{
      throw new SQLException("not implemented");
    }
    
    //======================================================================
    // Methods for accessing results by column index
    //======================================================================

    /**
     * Get the value of a column in the current row as a Java String.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is null
     */
    public String getString(int columnIndex) throws SQLException{

	/* Not using the columnIndex passed may be a little confusing
	   here. But we have no choice to keep track of the column
	   numbers. WE cannot increment the column number in the applet
	   because qddbBridge is not in the interface declaration */

	if (columnIndex == 0) {
		qddbBridge.InitialiseLastColumnCopied();
	}
	else
		qddbBridge.IncrementLastColumnCopied();
	columnIndex = qddbBridge.getLastColumnCopied();	
	//System.out.println("colnum = " + colnum);
	return (qddbBridge.getInstance(columnIndex));
	//System.out.println("columnIndex = " +columnIndex);
	//return (qddbBridge.RowList.getRow(columnIndex));
    }

    /**
     * Get the value of a column in the current row as a Java boolean.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is false
     */
    public boolean getBoolean(int columnIndex) throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * Get the value of a column in the current row as a Java byte.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public byte getByte(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java short.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public short getShort(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java int.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public int getInt(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");    
    }

    /**
     * Get the value of a column in the current row as a Java long.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public long getLong(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java float.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public float getFloat(int columnIndex) throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * Get the value of a column in the current row as a Java double.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public double getDouble(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Numeric object.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @param scale the number of digits to the right of the decimal
     * @return the column value; if the value is SQL NULL the result is null
     */
    public Numeric getNumeric(int columnIndex, int scale) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java byte array.
     * The bytes represent the raw values returned by the driver.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is null
     */
    public byte[] getBytes(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Date object.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is null
     */
    public java.sql.Date getDate(int columnIndex) throws SQLException{
     throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Time object.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is null
     */
    public java.sql.Time getTime(int columnIndex) throws SQLException{
      return Time.valueOf("4.05");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Timestamp object.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return the column value; if the value is SQL NULL the result is null
     */
    public java.sql.Timestamp getTimestamp(int columnIndex) throws SQLException{
      throw new SQLException ("not implemented");
    }

    /**
     * A column value can be retrieved as a stream of ASCII characters 
     * and then read in chunks from the stream.  This method is particularly
     * suitable for retrieving large LONGVARCHAR values.  The JDBC driver will
     * do any necessary conversion from the database format into ASCII.
     *
     * <P><B>Note:</B> All the data in the returned stream must
     * be read prior to getting the value of any other column. The
     * next call to a get method implicitly closes the stream.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return a Java input stream that delivers the database column value
     * as a stream of one byte ASCII characters.  If the value is SQL NULL
     * then the result is null.
     */
    public java.io.InputStream getAsciiStream(int columnIndex) throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * A column value can be retrieved as a stream of Unicode characters 
     * and then read in chunks from the stream.  This method is particularly
     * suitable for retrieving large LONGVARCHAR values.  The JDBC driver will
     * do any necessary conversion from the database format into Unicode.
     *
     * <P><B>Note:</B> All the data in the returned stream must
     * be read prior to getting the value of any other column. The
     * next call to a get method implicitly closes the stream.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return a Java input stream that delivers the database column value
     * as a stream of two byte Unicode characters.  If the value is SQL NULL
     * then the result is null.
     */
    public java.io.InputStream getUnicodeStream(int columnIndex) throws SQLException{
      throw new SQLException("not implemented");     
    }

    /**
     * A column value can be retrieved as a stream of uninterpreted bytes 
     * and then read in chunks from the stream.  This method is particularly
     * suitable for retrieving large LONGVARBINARY values.
     *
     * <P><B>Note:</B> All the data in the returned stream must
     * be read prior to getting the value of any other column. The
     * next call to a get method implicitly closes the stream.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return a Java input stream that delivers the database column value
     * as a stream of uninterpreted bytes.  If the value is SQL NULL
     * then the result is null.
     */
    public java.io.InputStream getBinaryStream(int columnIndex)
        throws SQLException{
      throw new SQLException("not implemented");
    }
    public java.math.BigDecimal getBigDecimal(java.lang.String x, int y) throws SQLException{
      throw new SQLException("not implemented");
    }
    public java.math.BigDecimal getBigDecimal(int x, int y) throws SQLException{
      throw new SQLException("not implemented");
    }


    //======================================================================
    // Methods for accessing results by column name
    //======================================================================

    /**
     * Get the value of a column in the current row as a Java String.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is null
     */
    public String getString(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java boolean.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is false
     */
    public boolean getBoolean(String columnName) throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * Get the value of a column in the current row as a Java byte.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public byte getByte(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java short.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public short getShort(String columnName) throws SQLException{
     throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java int.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public int getInt(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java long.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public long getLong(String columnName) throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * Get the value of a column in the current row as a Java float.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public float getFloat(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java double.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is 0
     */
    public double getDouble(String columnName) throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * Get the value of a column in the current row as a java.sql.Numeric object.
     *
     * @param columnName is the SQL name of the column
     * @param scale the number of digits to the right of the decimal
     * @return the column value; if the value is SQL NULL the result is null
     */
    public Numeric getNumeric(String columnName, int scale) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a Java byte array.
     * The bytes represent the raw values returned by the driver.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is null
     */
    public byte[] getBytes(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Date object.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is null
     */
    public java.sql.Date getDate(String columnName) throws SQLException{
      throw new SQLException ("not implemented");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Time object.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is null
     */
    public java.sql.Time getTime(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the value of a column in the current row as a java.sql.Timestamp object.
     *
     * @param columnName is the SQL name of the column
     * @return the column value; if the value is SQL NULL the result is null
     */
    public java.sql.Timestamp getTimestamp(String columnName) throws SQLException{
      throw new SQLException ("not implemented"); 
    }

    /**
     * A column value can be retrieved as a stream of ASCII characters 
     * and then read in chunks from the stream.  This method is particularly
     * suitable for retrieving large LONGVARCHAR values.  The JDBC driver will
     * do any necessary conversion from the database format into ASCII.
     *
     * <P><B>Note:</B> All the data in the returned stream must
     * be read prior to getting the value of any other column. The
     * next call to a get method implicitly closes the stream.
     *
     * @param columnName is the SQL name of the column
     * @return a Java input stream that delivers the database column value
     * as a stream of one byte ASCII characters.  If the value is SQL NULL
     * then the result is null.
     */
    public java.io.InputStream getAsciiStream(String columnName) throws SQLException{
      throw new SQLException("Not implemented");
    }

    /**
     * A column value can be retrieved as a stream of Unicode characters 
     * and then read in chunks from the stream.  This method is particularly
     * suitable for retrieving large LONGVARCHAR values.  The JDBC driver will
     * do any necessary conversion from the database format into Unicode.
     *
     * <P><B>Note:</B> All the data in the returned stream must
     * be read prior to getting the value of any other column. The
     * next call to a get method implicitly closes the stream.
     *
     * @param columnName is the SQL name of the column
     * @return a Java input stream that delivers the database column value
     * as a stream of two byte Unicode characters.  If the value is SQL NULL
     * then the result is null.
     */
    public java.io.InputStream getUnicodeStream(String columnName) throws SQLException{
      throw new SQLException("Not implemented");
    }

    /**
     * A column value can be retrieved as a stream of uninterpreted bytes 
     * and then read in chunks from the stream.  This method is particularly
     * suitable for retrieving large LONGVARBINARY values.
     *
     * <P><B>Note:</B> All the data in the returned stream must
     * be read prior to getting the value of any other column. The
     * next call to a get method implicitly closes the stream.
     *
     * @param columnName is the SQL name of the column
     * @return a Java input stream that delivers the database column value
     * as a stream of uninterpreted bytes.  If the value is SQL NULL
     * then the result is null.
     */
    public java.io.InputStream getBinaryStream(String columnName)
        throws SQLException{
      throw new SQLException("not implemented");
    }


    //=====================================================================
    // Advanced features:
    //=====================================================================

    /**
     * <p>The first warning reported by calls on this ResultSet is
     * returned. Subsequent ResultSet warnings will be chained to this
     * SQLWarning.
     *
     * <P>The warning chain is automatically cleared each time a new
     * row is read.
     *
     * <P><B>Note:</B> This warning chain only covers warnings caused
     * by ResultSet methods.  Any warning caused by statement methods
     * (such as reading OUT parameters) will be chained on the
     * Statement object. 
     *
     * @return the first SQLWarning or null 
     */
    public SQLWarning getWarnings() throws SQLException{
      return null;
    }

    /**
     * After this call getWarnings returns null until a new warning is
     * reported for this ResultSet.  
     */
    public void clearWarnings() throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * Get the name of the SQL cursor used by this ResultSet.
     *
     * <P>In SQL, a result table is retrieved through a cursor that is
     * named. The current row of a result can be updated or deleted
     * using a positioned update/delete statement that references the
     * cursor name. 
     * 
     * <P>JDBC supports this SQL feature by providing the name of the
     * SQL cursor used by a ResultSet. The current row of a ResultSet
     * is also the current row of this SQL cursor.
     *
     * <P><B>Note:</B> If positioned update is not supported a
     * SQLException is thrown
     *
     * @return the ResultSet's SQL cursor name
     */
    public String getCursorName() throws SQLException{
      throw new SQLException("not implemented"); 
    }

    /**
     * The number, types and properties of a ResultSet's columns
     * are provided by the getMetaData method.
     *
     * @return the description of a ResultSet's columns
     */
    public ResultSetMetaData getMetaData() throws SQLException{
      throw new SQLException("not implemented");
    }

    /**
     * <p>Get the value of a column as a Java object.
     *
     * <p>This method will return the value of the given column as a Java 
     * object.  The type of the Java object will be default Java Object type 
     * corresponding to the column's SQL type, following the mapping
     * specified in the JDBC spec.
     *
     * <p>This method may also be used to read datatabase specific abstract
     * data types.
     *
     * @param columnIndex the first column is 1, the second is 2, ...
     * @return A java.lang.Object holding the column value.
     */
    public Object getObject(int columnIndex) throws SQLException{
	/*LastRowCopied = columnIndex;
	return (Rows[columnIndex]);
	Result = qddbBridge.getResult();
	return Result;*/
      throw new SQLException("not implemented");
    }

    /**
     * <p>Get the value of a parameter as a Java object.
     *
     * <p>This method will return the value of the given column as a Java 
     * object.  The type of the Java object will be default Java Object type 
     * corresponding to the column's SQL type, following the mapping
     * specified in the JDBC spec.
     *
     * <p>This method may also be used to read datatabase specific abstract
     * data types.
     *
     * @param columnName is the SQL name of the column
     * @return A java.lang.Object holding the column value.
     */
    public Object getObject(String columnName) throws SQLException{
      throw new SQLException("not implemented");
    }

    //----------------------------------------------------------------

    /**
     * Map a Resultset column name to a ResultSet column index.
     *
     * @param columnName the name of the column
     * @return the column index
     */

    public int findColumn(String columnName) throws SQLException{
      throw new SQLException("not implemented"); 
    }

}
