#include <string.h> 
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <jni.h>
#include <fcntl.h>
#include <javaString.h>
#include <StubPreamble.h>
#include "Qddb.h"
#include "Qddb_Sql.h"              
#include "QDDBaccess_QDDBBridge.h"

#define MAX_UID_LENGTH 18
#define MAX_PWD_LENGTH 20
#define MAXCOLS 100
#define MAX_DBNAME_LENGTH 60
#define MAX_QUERY_LENGTH 100

char dbn[MAX_DBNAME_LENGTH];
char Relation[MAX_PWD_LENGTH], *rel;
Schema *schema;

void stradd(char *, char *);

JNIEXPORT jboolean JNICALL Java_QDDBaccess_QDDBBridge_openConnection
(JNIEnv *env, jobject obj, jstring login, jstring passwd, jstring dbname){ 

    long openRetVal;
  
    const char *uid = (*env)->GetStringUTFChars(env, login, 0);
    const char *pwd = (*env)->GetStringUTFChars(env, passwd, 0);
    const char *dbn = (*env)->GetStringUTFChars(env, dbname, 0);

    //printf(" In Open connection \n");

    Qddb_Init();
    rel = Qddb_FindRelation(dbn);
    if (rel == NULL)
      return 0;
    strcpy(Relation, rel);
    (*env)->ReleaseStringUTFChars(env, login, uid);
    (*env)->ReleaseStringUTFChars(env, passwd, pwd);
    (*env)->ReleaseStringUTFChars(env, dbname, dbn);
    return 1;
}

JNIEXPORT jint JNICALL Java_QDDBaccess_QDDBBridge_InitSchema
(JNIEnv *env, jobject obj){
	
	schema = Qddb_InitSchema(Relation);
	if (schema == NULL)
		return 0;
	return 1;
}

JNIEXPORT jint JNICALL Java_QDDBaccess_QDDBBridge_getResultSet
(JNIEnv *env, jobject obj, jstring Query){ 

	char query1[50], query2[50], *colname, *rowentry;
	int err, numrows, numcolumns, rownum, colnum, i, j, len;
	q_cols *colnmes;
	q_data *row;
	jstring column, tuple;
	jint    NumRows, NumColumns;
	KeyList *keyList, *tempList;
	Result *result;
	char *emptyString = "";
	Entry ThisEntry = NULL;
	q_data *colvals;
	char *columnName;

	const char *query = (*env)->GetStringUTFChars(env, Query, 0);
	jclass cls = (*env)->GetObjectClass(env, obj);
	jmethodID mid1 = (*env)->GetMethodID(env, cls, "SetNumRows", "(I)V");
	jmethodID mid2 = (*env)->GetMethodID(env, cls, "SetNumColumns", "(I)V");
	jmethodID mid3 = (*env)->GetMethodID(env, cls, "CopyRow", 
						"(IILjava/lang/String;)V");
	jmethodID mid4 = (*env)->GetMethodID(env, cls, "CopyColumn", 
						"(ILjava/lang/String;)V");
	if (schema != NULL)
	{
		result = (Result*)SQLQuery(schema, query, &err);
		printf("In QDDBBridgeImp.c after getting result\n");
		if (err == -1)
			return -1;
		SQLListTable(result);
		SQLListColumns(result);
		if (result->colslist != NULL)
		{ 
			NumColumns = result->numcolumns;
			(*env)->CallVoidMethod(env, obj, mid2, NumColumns); 
			printf("Setting Columns\n");
			colnmes = result->colslist;
			i = 0;
			do 
			{
				printf("column = %s\n", colnmes->cols.name);
				columnName = (char *)malloc(strlen(colnmes->cols.name) + 1);
				//strcpy(columnName, colnmes->cols.name);
				column = (*env)->NewStringUTF(env,
					 colnmes->cols.name); 
				(*env)->CallVoidMethod(env, obj,
						mid4, i, column);
				i++;
				colnmes = colnmes->next;
        			//(*env)->ReleaseStringUTFChars(env, column, 
					//columnName);
				//free(columnName);
			} while (colnmes != NULL);
			printf("Done with all columns\n");
		}
		if (result->datalist != NULL)
		{
			//printf(" Setting numrows\n");
			//printf("Num rows = %d\n", result->numrows);
			NumRows = result->numrows;
			(*env)->CallVoidMethod(env, obj, mid1, NumRows); 
			colvals = result->datalist;
			i = 0;
			//printf("Getting in to do loop\n");
			do {
				if (colvals->data != NULL) {
					//printf("In do loop\n");
					//printf("NumColumns = %d\n", result->numcolumns);
				        for( j =0; j < result->numcolumns; j++) 
					{
						//printf("Data no Null\n");
						if (colvals->data[j] != NULL)
						{
						//printf("%s : ",colvals->data[j]);
						   tuple = (*env)->NewStringUTF
							(env,colvals->data[j]); 
						}
						else
						{
						   tuple = (*env)->NewStringUTF
							(env,emptyString); 
						}
						
						/*tuple = (char *)malloc
						(strlen(colvals->data[i]) + 1);
						strcpy(tuple, colvals->data[i]);*/
						//printf("rownum = %d : colnum = %d\n", i, j);
					        (*env)->CallVoidMethod(env, obj,					                mid3, i,j, tuple); 
					    //free(tuple);
					}
				}
				colvals = colvals->next;
				i++;
			} while (colvals != NULL);
			//printf("All entries done\n");
		}
        (*env)->ReleaseStringUTFChars(env, Query, query);
	//printf(" REturning from getResult\n");
	return 0;
	}
	//printf("Schrma is null\n");
}

JNIEXPORT jint JNICALL Java_QDDBaccess_QDDBBridge_OpenDBFile
(JNIEnv *env, jobject obj){
	return (OpenDatabase(Relation,0));
}

JNIEXPORT void JNICALL Java_QDDBaccess_QDDBBridge_CloseDBFile
(JNIEnv *env, jobject obj, jint DBFile){
	close(DBFile);
}
