/*this has the bridge code for QDDB*/
package QDDBaccess;

import QDDBaccess.QDDBColumnList;
import QDDBaccess.QDDBDataList;

public class QDDBBridge{

    public QDDBaccess.QDDBColumnList ColList;
    public QDDBaccess.QDDBDataList RowList;
    public boolean ParseErr;
    String QueryResult; 
    int DBFile, LastRowCopied, LastColumnCopied;
                                            
    static{
        try{
            System.loadLibrary("QddbBridge");
        }
        catch(UnsatisfiedLinkError e){
            System.err.println("can't find library");
            System.exit(-1);
        }
    }

    private boolean openSuccess;
    /**This is the constructor for the Bridge object. It just calls a method
     * which in turn calls the C code to open the appropriate database.
     */
    public QDDBBridge(String login, String passwd, String dbname){
	ColList = new QDDBaccess.QDDBColumnList();
	RowList = new QDDBaccess.QDDBDataList();	
	LastRowCopied = 0;
	LastColumnCopied = 0;
        openSuccess = openConnection(login, passwd, dbname);
    }
    /*public String getResult(){
	String Query;
	Query = "dummy";
        ExecuteQuery(Query);
	ColList.printColumn(0);
	RowList.printRow(0);
	return Query;
    }*/

    public void ExecuteQuery(String Query){
	int bool, retval = 0;

	bool = InitSchema();
        if (bool != 0) 
	    retval = getResultSet(Query);
	//System.out.println("retval = " + retval);
	if (retval == -1)
	    ParseErr = true;
	else
	    ParseErr = false;
	System.out.println("In ExecuteQuery LastRowCopied = "+LastRowCopied); 
	//System.out.println("ParseErr = " + ParseErr);
	
   }
   public void SetNumColumns(int num){
	//System.out.println("Setting column number in QDDBBridge");
        ColList.SetNumColumns(num);
        RowList.SetNumColumns(num);
       //ColList =  new QDDBaccess.ColumnList(num);
	
   }
   public void SetNumRows(int num){
	RowList.SetNumRows(num);
	//System.out.println("Setting row number in QDDBBridge to  " + num);
   }
   public void CopyColumn(int colnum, String Name){
	//System.out.println("In QDDBBridge");
	//System.out.println("The column num is " + colnum);
	//System.out.println("The column name is being set to " +Name);
        ColList.SetColumn(colnum, Name);
   }
   public void CopyRow(int rownum, int colnum, String Entry){
	//System.out.println("In QDDBBridge");
	//System.out.println("The row num is " +rownum);
	//System.out.println("The row name is being set to " +Entry);
        RowList.SetRow(rownum, colnum, Entry);
   }
   public String getInstance(int colnum){
	String retval, data;
	int    NumColumns;

	//System.out.println("In getDataEntry colnum = \n" + colnum);
	NumColumns = ColList.getNumColumns();
	if (colnum >= NumColumns) {
		LastRowCopied++; //Time to fetch next row
		return null;
	}
	while (((data=RowList.Row[LastRowCopied].getDataEntry(colnum)).length() == 0) &&
		(colnum < NumColumns)) {
		//System.out.println("In while loop\n");
		colnum++;
	}
	if (colnum >= NumColumns){
		LastRowCopied++; //Time to fetch next row
		return null;
	}
	retval = ColList.Column[colnum].getName() + " = " + data;
	LastColumnCopied = colnum;
	return retval;
   }	
   public void IncrementLastRowCopied(){
	System.out.println("In IncrementLastRowCopied = "+ LastRowCopied);
	LastRowCopied++;
   }
   public void IncrementLastColumnCopied(){
	//System.out.println("LastColumnCopied = "+ LastColumnCopied);
	LastColumnCopied++;
   }
   public void InitialiseLastColumnCopied(){
	LastColumnCopied = 0;
   }
   public int getLastRowCopied(){
	System.out.println("LastRowCopied = "+ LastRowCopied);
	return LastRowCopied;
   }
   public int getLastColumnCopied(){
	return LastColumnCopied;
   }
   public native int getResultSet(String query);
   public native int OpenDBFile();
   public native void CloseDBFile(int DBFile);
   public native int InitSchema();
    /*Native method to open connection to a qddb database*/
   public native boolean openConnection(String login, String passwd, 
                                         String dbname);

   public boolean getopenSuccess(){
        return openSuccess;
    }
}
