import java.awt.*;
import java.applet.Applet;
import java.net.URL;
import java.util.*;

import java.qsql.QDDBConnection;
import java.qsql.QDDBDriver;
import java.qsql.QDDBStatement;
import java.qsql.QDDBResultSet;
import java.sql.*;
import java.sql.SQLException;
import QDDBaccess.QDDBBridge;

public class jdbcApplet extends Applet implements Runnable{
  Button ConnectBtn = new Button("Connect to database");
  //Button DisconnectBtn = new Button("Disconnect");
  Thread SyncThread;

  Connection con;
  Statement statement;
  ResultSet resultset;
  String DBName = "";
  String url = "";
  String Query = "";
  String Output = new String();
  boolean NoResults, ResultsPrinted = false;
  static int colnum;
  int RowIndex = 1;

  TextField DBNameField = new TextField(40);
  TextArea MsgField = new TextArea(2,100);
  TextArea ResultField = new TextArea(20,100);
  TextField QueryField = new TextField(40);

  public void init(){
    MsgField.setEditable(false);
    ResultField.setEditable(false);
    DBNameField.setEditable(true);
    QueryField.setEditable(true);
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints gridCon = new GridBagConstraints();
    setLayout(gridbag);
    setFont(new Font("Helvetica", Font.PLAIN, 12));
    gridCon.weightx = 1.0;
    gridCon.weighty = 0.0;

    gridCon.anchor = GridBagConstraints.CENTER;
    gridCon.fill = GridBagConstraints.NONE;
    gridCon.gridwidth = GridBagConstraints.REMAINDER;

    add(new Label("Database Name "));
    gridbag.setConstraints(DBNameField, gridCon);
    add(DBNameField);
 
    gridbag.setConstraints(ConnectBtn, gridCon);
    add(ConnectBtn);

    add(new Label("Query"));
    gridbag.setConstraints(QueryField,gridCon);
    add(QueryField);

    /*gridbag.setConstraints(DisconnectBtn, gridCon);
    add(DisconnectBtn);*/

    add (new Label("Message Screen"));
    gridCon.weighty = 1.0;
    gridbag.setConstraints(MsgField,gridCon);
    MsgField.setForeground(Color.black);
    //MsgField.setBackground(Color.black);
    add(MsgField);

    Label result_label = new Label("Result");
    result_label.setFont(new Font("Helvetica", Font.PLAIN, 16));
    result_label.setForeground(Color.black);
    gridbag.setConstraints(result_label, gridCon);
    add(result_label);     

    gridCon.weighty = 1.0;
    gridbag.setConstraints(ResultField, gridCon);
    ResultField.setForeground(Color.black);
    //ResultField.setBackground(Color.black);
    add(ResultField);
    show();
  }
  public void start() {
    if (SyncThread == null) {
       SyncThread = new Thread(this);
    }
  }
  public void run() {
    Thread myThread = Thread.currentThread();
    myThread.suspend();
  }
  public void stop(){
    SyncThread = null;
  }
  public boolean handleEvent(Event e){
    int dummy = 0;
    if (e.target == DBNameField){
      char c = (char)e.key;
      if (c == '\n'){
	DBName = DBNameField.getText();
        //System.out.print("DB name is " + DBName);
	return true;
      }
      else
        return false;
    }  
    /*if (e.target == DisconnectBtn){
       Thread thread = Thread.currentThread();
       thread.stop();
       this.hide();
       this.destroy();
       return true;
    }*/
    if (e.target == QueryField){
      char c = (char)e.key;
      if (ResultsPrinted == false) {
        if (c == '\n'){
	  ResultField.setText(Select(QueryField.getText()));
          ResultsPrinted = true;
	  return true;
        }
        return false;
      }
    }  
    if (e.target == ConnectBtn){
      DBName = DBNameField.getText();
      try{
        new java.qsql.QDDBDriver();	
      /*Since the driver manager extracts the db name from the url,concatenate
        the url and DBName to get the url? --uk */
        url = "jdbc:qddblocal";
	con = DriverManager.getConnection("jdbc:qddblocal",DBName,"");
        if ( (con == null) || (con.isClosed() == true) )
          MsgField.setText("Database does not exist");
        else
          MsgField.setText("Connected to database");
      }
      catch (SQLException ex){
	ex.printStackTrace();
	MsgField.setText(ex.getMessage());
      }
      return true;
    }
    return false;
 }
 public String Select(String Query) {
   String Output = "";
   String result = "";
   int colnum;

   try{
      if ( (con == null) || (con.isClosed() == true) ){
          Output = "No Connection";
	  return Output;
      }
      else{
        statement = con.createStatement();
        try {
	  resultset = statement.executeQuery(Query);
 	  NoResults = true;
	  System.out.println(NoResults);
          while (resultset.next() != false)
          {
		System.out.println("In while loop");
                NoResults = false;
	        System.out.println(NoResults);
                colnum = 0;
                while( (result = resultset.getString(colnum)) != null) {
			System.out.println(Output);
                        Output = Output + result + "\n";
                        colnum++;
			result = "";
                /* Though QDDBResultSet does not use this colnum, QDDBResultSet
                   has to know that the colnum is not zero or in other words
                   this column is not the first column to be fetched in this
                   row */
                }
                Output = Output + "\n";
           }
           if (NoResults)
                Output = "No results";
        }
	catch (NullPointerException ex)
        {
           Output = "Query Failed";
        }
      }
    }
    catch (SQLException ex){
        ex.printStackTrace();
    }
    return Output ;
  }
}
