%{\
/* qddb/Lib/LibQsql/SqlParse.y -- just a stub right now.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"

/* redefine the parser and lexical analyser to be
 * the proper names
 */

#define yyparse	SqlParse
#define yylex   SqlLex

static Schema *schema;
static char *SqlBuf;
static int AttrNumber;
static char *schemaname;
static Result *result;
static KeyList *keyList;
static int SqlCode;
static SqlState[5];
extern void Qddb_ResetSqlLex();
//extern char* strsep _ANSI_ARGS_((char **pp, char *delim));
char* GetSchemaName();

extern SqlReturn InsertTable (	Schema *,
								Constant[],
								Identifier[],
								ClistNode[],
								OpStack[],
								OpStackList[],
								TabExp[],
								unsigned int,
								unsigned int,
								unsigned int);

extern SqlReturn InsertTuple (	Schema *,
								Constant[],
								Identifier[],
								ClistNode[],
								OpStack[],
								OpStackList[],
								TabExp[],	
								unsigned int,
								unsigned int);

extern void * SelectRows (Schema *,
								Constant[],
								Identifier[],
								ClistNode[],
								OpStack[],
								OpStackList[],
								TabExp[],
								int);

int yylex();
int yywrap();
int yyerror _ANSI_ARGS_((char *));

/* Global stack for parser to get rid of malloc and free overhead. 
 */
Constant	Constants[CONSTANTSIZE];
unsigned int	ConstantsTop = 0;

Identifier	Identifiers[IDENTIFIERSIZE];
unsigned int	IdentifiersTop = 0;

ClistNode	Clists[CLISTSSIZE];
unsigned int	ClistsTop = 0;

OpStack		Ops[OPSSIZE];
unsigned int 	OpsTop = 0;

OpStackList	OpStackLists[OPSTACKLISTSIZE];
unsigned int	OpStackListsTop = 0;

TabExp		TabExps[TABEXPSIZE];
unsigned int	TabExpsTop = 0;


void Qddb_SqlParse_Set(db)
   Schema *db;
{
   schema = db;
   schemaname = GetSchemaName();
}

void* Qddb_SqlParse_Get(code, state)
   int		code;
   char		state[];
{
   int i;
   code = SqlCode;
   //printf("In SqlParse_Get\n");
   for (i=0;i<5;i++)
   		state[i] = SqlState[i];
   for (i=0;i<IdentifiersTop;i++) {
       if (Identifiers[IdentifiersTop].ColumnName != NULL)
			Free(Identifiers[IdentifiersTop].ColumnName);
       if (Identifiers[IdentifiersTop].TableName != NULL)
			Free(Identifiers[IdentifiersTop].TableName);
	}
   for (i=0;i<ConstantsTop;i++) {
       if (Constants[ConstantsTop].Type == STRINGCONS)
       		if (Constants[ConstantsTop].Val.String != NULL)
				Free(Constants[ConstantsTop].Val.String);
	}					   
        //printf("Returning from SqlParse_Get\n");
   //return (keyList);
   return (result);
}



%}

%pure_parser
%expect 8

%token SELECT DISTINCT FROM WHERE 
%token IDENTIFIER
%token DOT COMMA 
%token LPAREN RPAREN
%token STRING REAL INTEGER
%token OR AND
%token IN
%token CREATE TABLE
%token INSERT INTO TUPLE VALUES
%token DELETE UPDATE 
%token EXISTS NOT
%token ASTERISK
%token VIEW
%token NULLVALUE UNIQUE
%token SCHEMA GRANT ON TO PUBLIC WITH CHECK OPTION
%token CLOSE COMMIT WORK FETCH CURRENT OF OPEN SET
%token ROLLBACK
%token UNION GROUP BY HAVING 
%token BETWEEN IS LIKE AS
%token DIV PLUS MINUS
%token INDICATOR AUTHORIZATION
%token PRIVILEGES ESCAPE
%token STRINGTYPE INTEGERTYPE REALTYPE UNSIGNEDTYPE
%token AVGFUNC MAXFUNC MINFUNC SUMFUNC COUNTFUNC
%token EQ NE GT 
%token GE LE LT
%token ANY ALL SOME

/* non-terminals */
%type <unsign>	IdentifierReference
%type <unsign>	IdentifierReferenceCommaList
%type <unsign>	Table
%type <unsign>	TableReference
%type <unsign>	TableReferenceCommaList
%type <unsign>  Literal
%type <unsign>  Atom
%type <unsign>	InsertAtom
%type <unsign>	InsertAtomCommaList
%type <unsign>	AtomCommaList

%type <unsign>	Primary
%type <unsign>  ScalarExpression
%type <unsign>	ScalarExpressionCommaList
%type <unsign>  Factor
%type <unsign>  Term
%type <unsign>  QueryTerm
%type <unsign>  QuerySpecification
%type <unsign>  SelectStatement
%type <unsign>	Selection
%type <unsign>  TableExpression
%type <unsign>  Predicate
%type <unsign>	ComparisonPredicate
%type <unsign>	BetweenPredicate
%type <unsign>	LikePredicate
%type <unsign>  BooleanFactor
%type <unsign>  BooleanTerm
%type <unsign>  BooleanPrimary
%type <unsign>  FromClause
%type <unsign>  SearchCondition
%type <unsign>  WhereClause
%type <unsign>  Subquery
%type <unsign>	Target
%type <unsign>	TargetCommaList
%type <unsign>	ParameterReference

%type <Operation> Comparison

/* terminals */
%type <string>  IDENTIFIER
%type <string>  STRING
%type <real>	REAL
%type <integer> INTEGER

%type <integer>	EQ
%type <integer>	NE
%type <integer>	GT
%type <integer>	LT
%type <integer>	GE
%type <integer>	LE

%left OR
%left AND

%nonassoc EQ NE GT GE LT LE 
%nonassoc ANY ALL SOME
%nonassoc IN

%union {
    char		*string;
    int			integer;
    double		real;
    unsigned int unsign;
    Operation	Operation;
	ClistNode	clist;
};

%start SqlStart

%%

SqlStart:
    SqlStatement | 
    SqlStart SqlStatement;

SqlStatement:
    Schema {
    } | 
    ManipulativeStatement {
    } |
    QueryExpression {
    };

Schema:
    CREATE SCHEMA AUTHORIZATION IDENTIFIER {
	/* CREATE SCHEMA AUTHORIZATION User */
    } |
    CREATE SCHEMA AUTHORIZATION IDENTIFIER SchemaElementList {
	/* CREATE SCHEMA AUTHORIZATION User SchemaElementList */
    };

SchemaElementList:
    SchemaElement {
    } |
    SchemaElementList SchemaElement {
    };

SchemaElement:
    BaseTableDefinition {
    } |
    ViewDefinition {
    } |
    PrivilegeDefinition {
    };

BaseTableDefinition:
    CREATE TABLE IdentifierReference LPAREN BaseTableElementCommaList RPAREN {
	/* CREATE TABLE BaseTable LPAREN BaseTableElementCommaList RPAREN */
    };

BaseTableElementCommaList:
    BaseTableElement {
    } |
    BaseTableElementCommaList COMMA BaseTableElement {
    };


BaseTableElement:
    ColumnDefinition {
    } |
    UniqueConstraintDefinition {
    };

ColumnDefinition:
    IDENTIFIER DataType {
    } |
    IDENTIFIER DataType NOT NULLVALUE {
    } |
    IDENTIFIER DataType NOT NULLVALUE UNIQUE {
    };

DataType:
    STRINGTYPE {
    } | 
    INTEGERTYPE {
    } |
    REALTYPE {
    } |
    UNSIGNEDTYPE {
    };

UniqueConstraintDefinition:
    UNIQUE LPAREN IdentifierReferenceCommaList RPAREN {
	/* UNIQUE LPAREN ColumnCommaList RPAREN */
    };

ViewDefinition:
    CREATE VIEW IdentifierReference AS QuerySpecification {
    } |
    CREATE VIEW IdentifierReference LPAREN IdentifierReferenceCommaList
    RPAREN AS QuerySpecification {
    } |
    CREATE VIEW IdentifierReference AS QuerySpecification WITH CHECK OPTION {
    } |
    CREATE VIEW IdentifierReference LPAREN IdentifierReferenceCommaList
    RPAREN AS QuerySpecification WITH CHECK OPTION {
    };


PrivilegeDefinition:
    GRANT Privileges ON Table TO GranteeCommaList {
    } |
    GRANT Privileges ON Table TO GranteeCommaList WITH GRANT OPTION {
    };

Privileges:
    ALL {
    } |
    ALL PRIVILEGES {
    } |
    OperationCommaList {
    };

OperationCommaList:
    Operation {
    } |
    OperationCommaList COMMA Operation {
    };

Operation:
    SELECT {
    } |
    INSERT {
    } |
    DELETE {
    } |
    UPDATE {
    } |
    LPAREN IdentifierReferenceCommaList RPAREN {
	/* LPAREN ColumnCommaList RPAREN */
    };

GranteeCommaList:
    PUBLIC {
    } |
    IDENTIFIER {
    };

ManipulativeStatement:
    CloseStatement {
    } |
    CommitStatement {
    } |
    DeleteStatementPositioned {
    } |
    DeleteStatementSearched {
    } |
    FetchStatement {
    } |
    InsertStatement {
    } |
    InsertTupleStatement {
    } |
    OpenStatement {
    } |
    RollBackStatement {
    } |
    SelectStatement {
    } |
    UpdateStatementPositioned {
    } |
    UpdateStatementSearched {
    };

CloseStatement:
    CLOSE IDENTIFIER {
    };

CommitStatement:
    COMMIT WORK {
    };

DeleteStatementPositioned:
    DELETE FROM Table WHERE CURRENT OF IDENTIFIER {
	/* OF Cursor */
    };

DeleteStatementSearched:
    DELETE FROM Table {
    } |
    DELETE FROM Table WhereClause {
    };

FetchStatement:
    FETCH IDENTIFIER INTO TargetCommaList {
	/* FETCH Cursor */
    };

InsertStatement:
    INSERT INTO Table VALUES LPAREN InsertAtomCommaList RPAREN { 
	InsertTable(schema, Constants, Identifiers, Clists, Ops,
				OpStackLists, TabExps, $3, NIL, $6);
    } |
    INSERT INTO Table QuerySpecification {
    } |
    INSERT INTO Table LPAREN IdentifierReferenceCommaList RPAREN 
    VALUES LPAREN InsertAtomCommaList RPAREN {
	InsertTable(schema, Constants, Identifiers, Clists, Ops,
				OpStackLists, TabExps, $3, $5, $9);
    } |
    INSERT INTO Table LPAREN IdentifierReferenceCommaList RPAREN 
    QuerySpecification {
    };

InsertTupleStatement:
    INSERT TUPLE LPAREN IdentifierReferenceCommaList RPAREN
    VALUES LPAREN InsertAtomCommaList RPAREN { 
	InsertTuple(schema, Constants, Identifiers, Clists, Ops,
				OpStackLists, TabExps, $4, $8);
	};

InsertAtomCommaList:
    InsertAtom {
	Clists[ClistsTop].Index = $1;
	Clists[ClistsTop].Next = NIL;
	$$ = ClistsTop++;
    } |
    InsertAtomCommaList COMMA InsertAtom {
	Clists[ClistsTop - 1].Next = ClistsTop;
	Clists[ClistsTop].Index = $3;
	Clists[ClistsTop].Next = NIL;
	ClistsTop++;
    };

InsertAtom:
    Atom {
        $$ = $1
    } |
    NULLVALUE {
    };

OpenStatement:
    OPEN IDENTIFIER {
	/* OPEN Cursor */
    };

RollBackStatement:
    ROLLBACK WORK {
    };

SelectStatement:
    SELECT Selection INTO TargetCommaList TableExpression {
    } |
    SELECT ALL Selection INTO TargetCommaList TableExpression {
    } |
    SELECT DISTINCT Selection INTO TargetCommaList TableExpression {
    };

TargetCommaList:
    Target {
	$$ = $1;
    } |
    TargetCommaList Target {
    };

Target:
    ParameterReference {
	$$ = $1;
    };

ParameterReference:
    IdentifierReference {
    } |
    IdentifierReference IdentifierReference {
    } |
    IdentifierReference INDICATOR IdentifierReference {
    };

UpdateStatementPositioned:
    UPDATE Table SET AssignmentCommaList WHERE CURRENT OF IDENTIFIER {
    };

UpdateStatementSearched:
    UPDATE Table SET AssignmentCommaList {
    } |
    UPDATE Table SET AssignmentCommaList WhereClause {
    };

AssignmentCommaList:
    Assignment {
    } |
    AssignmentCommaList COMMA Assignment {
    };

Assignment:
    /* IDENTIFIER == Column */
    IDENTIFIER EQ ScalarExpression {
    } |
    IDENTIFIER EQ NULLVALUE {
    };

/* BEGIN QUERY */
QueryExpression:
    QueryTerm {
    } |
    QueryExpression UNION QueryTerm {
    } |
    QueryExpression UNION ALL QueryTerm {
    };

QueryTerm:
    QuerySpecification {
    } |
    LPAREN QueryExpression RPAREN {
    };

QuerySpecification:
    SELECT Selection TableExpression {
	TabExps[TabExpsTop].Select = $2;
	/*keyList = (KeyList *)SelectRows(schema, Constants, Identifiers,
				Clists, Ops, OpStackLists, TabExps, 0);*/
	result = (Result *)SelectRows(schema, Constants, Identifiers,
				Clists, Ops, OpStackLists, TabExps, 0);
	TabExpsTop++;
    } |
    SELECT ALL Selection TableExpression {
	TabExps[TabExpsTop].Select = $3;
	/*keyList = (KeyList *)SelectRows(schema, Constants, Identifiers,
				Clists, Ops, OpStackLists, TabExps, 0);*/
	result = (Result *)SelectRows(schema, Constants, Identifiers,
				Clists, Ops, OpStackLists, TabExps, 0);
	TabExpsTop++;
    } |
    SELECT DISTINCT Selection TableExpression {
	TabExps[TabExpsTop].Select = $3;
	/*keyList = (KeyList *)SelectRows(schema, Constants, Identifiers,
				Clists, Ops, OpStackLists, TabExps, 0);*/
	result = (Result *)SelectRows(schema, Constants, Identifiers,
				Clists, Ops, OpStackLists, TabExps, 1);
	TabExpsTop++;
    };

Selection:
    ScalarExpressionCommaList {
	$$ = $1;
    } |
    ASTERISK {
	$$ = NIL;
    };

TableExpression:
    FromClause {
	TabExps[TabExpsTop].From = $1;
	TabExps[TabExpsTop].Where = NIL;
	$$ = TabExpsTop;
    } |
    FromClause WhereClause {
	TabExps[TabExpsTop].From = $1;
	TabExps[TabExpsTop].Where = $2;
	$$ = TabExpsTop;
    } |
    FromClause GroupByClause {
    } |
    FromClause WhereClause GroupByClause {
    } |
    FromClause HavingClause {
    } |
    FromClause WhereClause HavingClause {
    } |
    FromClause GroupByClause HavingClause {
    } |
    FromClause WhereClause GroupByClause HavingClause {
    };

FromClause:
    FROM TableReferenceCommaList {
	$$ = $2;
    };

TableReferenceCommaList:
    TableReference {
	Clists[ClistsTop].Index = $1;
	Clists[ClistsTop].Next = NIL;
	$$ = ClistsTop++;
    } |
    TableReferenceCommaList COMMA TableReference {
	Clists[ClistsTop - 1].Next = ClistsTop;
	Clists[ClistsTop].Index = $3;
	Clists[ClistsTop].Next = NIL;
	ClistsTop++;
    };

TableReference:
    Table {
    /****IdentifierReference {****/
	$$ = $1;
    } |
    Table IDENTIFIER {
    /**** IdentifierReference IDENTIFIER { ****/
    };

WhereClause:
    WHERE SearchCondition {
	$$ = $2;
    };

GroupByClause:
    GROUP BY IdentifierReferenceCommaList {
    };

HavingClause:
    HAVING SearchCondition {
    };

SearchCondition:
    BooleanTerm {
	$$ = $1;
    } |
    SearchCondition OR BooleanTerm {
	Ops[OpStackLists[$1].Top].Op = UNIONOP;
	OpStackLists[OpStackListsTop].Bottom = OpStackLists[$1].Bottom;
	OpStackLists[OpStackListsTop].Top = OpStackLists[$3].Top;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    };

BooleanTerm:
    BooleanFactor {
	$$ = $1;

    } |
    BooleanTerm AND BooleanFactor {
	Ops[OpStackLists[$1].Top].Op = INTERSECTIONOP;
	OpStackLists[OpStackListsTop].Bottom = OpStackLists[$1].Bottom;
	OpStackLists[OpStackListsTop].Top = OpStackLists[$3].Top;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    };

BooleanFactor:
    BooleanPrimary {
	$$ = $1;
    } |
    NOT BooleanPrimary {
	Ops[OpStackLists[$2].Top].Op = SUBTRACT;
	$$ = $2;
    };

BooleanPrimary:
    Predicate {
	$$ = $1;
    } |
    LPAREN SearchCondition RPAREN {
	$$ = $2;
    };

Predicate:
    ComparisonPredicate {
	$$ = $1;
    } |
    BetweenPredicate {
	$$ = $1;
    } |
    LikePredicate {
	$$ = $1;
    } |
    TestForNull {
    } |
    InPredicate {
    } | 
    AllOrAnyPredicate {
    } |
    ExistenceTest {
    };

ComparisonPredicate:
    ScalarExpression Comparison ScalarExpression {
	OpStackLists[OpStackListsTop].Top = OpStackLists[$3].Top;
	Ops[OpStackLists[$1].Top].Op = $2;
	OpStackLists[OpStackListsTop].Bottom = OpStackLists[$1].Bottom;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    } |
    ScalarExpression Comparison Subquery {
    };

Comparison:
    EQ {
	$$ = EQUAL;
    } |
    NE {
	$$ = NOTEQUAL;
    } |
    LT {
	$$ = LESSTHAN
    } |
    GT {
	$$ = GREATERTHAN
    } |
    LE {
	$$ = LESSEQUAL
    } |
    GE {
	$$ = GREATEREQUAL
    };

BetweenPredicate:
    ScalarExpression NOT BETWEEN ScalarExpression AND ScalarExpression {
	int e1bot,e1top, e2bot, e2top, e3bot, e3top;
	int i,j,k,ne1bot,ne1top, ne3bot, ne3top;
	e1bot = OpStackLists[$1].Bottom;
	e1top = OpStackLists[$1].Top;
	e2bot = OpStackLists[$4].Bottom;
	e2top = OpStackLists[$4].Top;
	e3bot = OpStackLists[$6].Bottom;
	e3top = OpStackLists[$6].Top;
	j = e1top - e1bot + 1;
	for (i = e3top;i >= e3bot; i--) 
		Ops[i + j] = Ops[i];
	OpsTop = OpsTop + j;
	ne3top = e3top + j;
	ne3bot = e3bot + j;
	for (i = e1bot,k=e3bot;i <= e1top; i++,k++) 
		Ops[k] = Ops[i];
	ne1bot = e3bot;
	ne1top = ne1bot + e1top - e1bot;

	OpStackLists[OpStackListsTop - 1].Top = e2top;
	Ops[OpStackLists[$1].Top].Op = LESSTHAN;
	OpStackLists[OpStackListsTop - 1].Bottom = e1bot;

	Ops[OpStackLists[$4].Top].Op = UNION;

	OpStackLists[OpStackListsTop].Top = ne1top;
	OpStackLists[OpStackListsTop++].Bottom = ne1bot;
	Ops[ne1top].Op = GREATERTHAN;

	OpStackLists[OpStackListsTop].Top = ne3top;
	OpStackLists[OpStackListsTop++].Bottom = ne3bot;

	OpStackLists[OpStackListsTop].Top = ne3top;
	OpStackLists[OpStackListsTop++].Bottom = ne1bot;

	OpStackLists[OpStackListsTop].Top = ne3top;
	OpStackLists[OpStackListsTop++].Bottom = e1bot;

	OpStackLists[OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    } |
    ScalarExpression BETWEEN ScalarExpression AND ScalarExpression {
	int e1bot,e1top, e2bot, e2top, e3bot, e3top;
	int i,j,k,ne1bot,ne1top, ne3bot, ne3top;
	e1bot = OpStackLists[$1].Bottom;
	e1top = OpStackLists[$1].Top;
	e2bot = OpStackLists[$3].Bottom;
	e2top = OpStackLists[$3].Top;
	e3bot = OpStackLists[$5].Bottom;
	e3top = OpStackLists[$5].Top;
	j = e1top - e1bot + 1;
	for (i = e3top;i >= e3bot; i--) 
		Ops[i + j] = Ops[i];
	OpsTop = OpsTop + j;
	ne3top = e3top + j;
	ne3bot = e3bot + j;
	for (i = e1bot,k=e3bot;i <= e1top; i++,k++) 
		Ops[k] = Ops[i];
	ne1bot = e3bot;
	ne1top = ne1bot + e1top - e1bot;

	OpStackLists[OpStackListsTop - 1].Top = e2top;
	Ops[OpStackLists[$1].Top].Op = GREATEREQUAL;
	OpStackLists[OpStackListsTop - 1].Bottom = e1bot;

	Ops[OpStackLists[$3].Top].Op = INTERSECTIONOP;

	OpStackLists[OpStackListsTop].Top = ne1top;
	OpStackLists[OpStackListsTop++].Bottom = ne1bot;
	Ops[ne1top].Op = LESSEQUAL;

	OpStackLists[OpStackListsTop].Top = ne3top;
	OpStackLists[OpStackListsTop++].Bottom = ne3bot;

	OpStackLists[OpStackListsTop].Top = ne3top;
	OpStackLists[OpStackListsTop++].Bottom = ne1bot;

	OpStackLists[OpStackListsTop].Top = ne3top;
	OpStackLists[OpStackListsTop++].Bottom = e1bot;

	OpStackLists[OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    };

LikePredicate:
    IdentifierReference LIKE Atom {
	int i,j,k,bufsiz;
	char *temp;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpStackLists[OpStackListsTop++].Bottom = OpsTop;
	Ops[OpsTop].Op = LIK;
	Ops[OpsTop].Val.Type = OPIDENT;
	Ops[OpsTop++].Val.Index = $1;
	Ops[OpsTop].Op = NONE;
	Ops[OpsTop].Val.Type = OPCONSTANT;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpStackLists[OpStackListsTop++].Bottom = OpsTop;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpStackLists[OpStackListsTop].Bottom = OpsTop - 1;
	bufsiz = BUFSIZ;
    temp = (char *) Malloc (bufsiz);
	for (i=0,j=0;
		i<=strlen(Constants[Ops[OpsTop].Val.Index].Val.String);
		i++,j++) {
		if (j == bufsiz - 10)
	       temp = Realloc(temp, (size_t)(bufsiz += BUFSIZ));
		if (Constants[Ops[OpsTop].Val.Index].Val.String[i] == '%') {
			temp[j++] = '[';
			temp[j++] = '^';
			temp[j++] = '"';
			temp[j++] = '%';
			temp[j++] = '_';
			temp[j++] = ']';
			temp[j] = '*';
		}
		else {
			if (Constants[Ops[OpsTop].Val.Index].Val.String[i] == '_') {
				temp[j++] = '[';
				temp[j++] = '^';
				temp[j++] = '"';
				temp[j++] = '%';
				temp[j++] = '_';
				temp[j] = ']';
			}
			else {
				temp[j] = Constants[Ops[OpsTop].Val.Index].Val.String[i];
			}
		}
	}
	temp[j] = '\0';
	strcpy(Constants[Ops[OpsTop].Val.Index].Val.String,temp);
	OpsTop++;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    } |
    IdentifierReference NOT LIKE Atom {
	int i,j,k,bufsiz;
	char *temp;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpStackLists[OpStackListsTop++].Bottom = OpsTop;
	Ops[OpsTop].Op = LIK;
	Ops[OpsTop].Val.Type = OPIDENT;
	Ops[OpsTop++].Val.Index = $1;
	Ops[OpsTop].Op = NONE;
	Ops[OpsTop].Val.Type = OPCONSTANT;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpStackLists[OpStackListsTop++].Bottom = OpsTop;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpStackLists[OpStackListsTop].Bottom = OpsTop - 1;
	bufsiz = BUFSIZ;
    temp = (char *) Malloc (bufsiz);
	temp[0] = '^';
	temp[1] = '[';
	for (i=0,j=2;
		i<=strlen(Constants[Ops[OpsTop].Val.Index].Val.String);
		i++,j++) {
		if (j == bufsiz - 10)
	       temp = Realloc(temp, (size_t)(bufsiz += BUFSIZ));
		if (Constants[Ops[OpsTop].Val.Index].Val.String[i] == '%') {
			temp[j++] = '[';
			temp[j++] = '^';
			temp[j++] = '"';
			temp[j++] = '%';
			temp[j++] = '_';
			temp[j++] = ']';
			temp[j] = '*';
		}
		else {
			if (Constants[Ops[OpsTop].Val.Index].Val.String[i] == '_') {
				temp[j++] = '[';
				temp[j++] = '^';
				temp[j++] = '"';
				temp[j++] = '%';
				temp[j++] = '_';
				temp[j] = ']';
			}
			else {
				temp[j] = Constants[Ops[OpsTop].Val.Index].Val.String[i];
			}
		}
	}
	temp[j++] = ']';
	temp[j] = '\0';
	strcpy(Constants[Ops[OpsTop].Val.Index].Val.String,temp);
	OpsTop++;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = OpStackListsTop - 1;
    } |
    IdentifierReference LIKE Atom ESCAPE Atom {
    } |
    IdentifierReference NOT LIKE Atom ESCAPE Atom {
    } |
    IdentifierReference LIKE IdentifierReference {
    } |
    IdentifierReference NOT LIKE IdentifierReference {
    } |
    IdentifierReference LIKE IdentifierReference ESCAPE IdentifierReference {
    } |
    IdentifierReference NOT LIKE IdentifierReference ESCAPE IdentifierReference {
    };

TestForNull:
    IdentifierReference IS NULLVALUE {
    } |
    IdentifierReference IS NOT NULLVALUE {
    };

InPredicate:
    ScalarExpression IN Subquery {
    } |
    ScalarExpression NOT IN Subquery {
    } |
    ScalarExpression IN AtomCommaList {
    } |
    ScalarExpression NOT IN AtomCommaList {
    } |
    ScalarExpression IN IdentifierReferenceCommaList {
    } |
    ScalarExpression NOT IN IdentifierReferenceCommaList {
    };

AllOrAnyPredicate:
    ScalarExpression Comparison ALL Subquery {
    } |
    ScalarExpression Comparison ANY Subquery {
    } |
    ScalarExpression Comparison SOME Subquery {
    };

ExistenceTest:
    EXISTS Subquery {
    };

Subquery:
    LPAREN SELECT Selection TableExpression RPAREN {
    } |
    LPAREN SELECT ALL Selection TableExpression RPAREN {
    } |
    LPAREN SELECT DISTINCT Selection TableExpression RPAREN {
    };

ScalarExpression:
    ScalarExpression PLUS Term {
	Ops[OpsTop - 1].Op = PLUS;
	Ops[OpsTop - 1].Val.Type = OPSTACK;  
	OpStackLists[$1].Top = OpsTop - 1;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = $1;
    } |
    ScalarExpression MINUS Term {
	Ops[OpsTop - 1].Op = PLUS;
	Ops[OpsTop - 1].Val.Type = OPSTACK;  
	OpStackLists[$1].Top = OpsTop - 1;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = $1;
	} |
    Term {
	OpStackLists[$1].Top = OpsTop - 1;
	OpStackLists[++OpStackListsTop].Bottom = OpsTop;
	$$ = $1;
    };

ScalarExpressionCommaList:
    ScalarExpression {
	Clists[ClistsTop].Index = $1;
	Clists[ClistsTop].Next = NIL;
	$$ = ClistsTop++;
    } |
    ScalarExpressionCommaList ScalarExpression {
	Clists[ClistsTop - 1].Next = ClistsTop;
	Clists[ClistsTop].Index = $2;
	Clists[ClistsTop].Next = NIL;
	ClistsTop++;
	$$ = $1;   
	/* ************************** */
    };

Term:
    Term ASTERISK Factor {
	Ops[OpsTop - 1].Op = MULTIPLY;
	$$ = $1;
    } |
    Term DIV Factor {
	Ops[OpsTop - 1].Op = DIVIDE;
	$$ = $1;
    } |
    Factor {
	$$ = $1;
    };

Factor:
    PLUS Primary {
	$$ = $2;
    } |
    MINUS Primary {
/*
	Constants[ConstantsTop].Type = INTEGERCONS;
	Constants[ConstantsTop].Val.Integer = -1;
	Ops[OpsTop].Val.Type = OPCONSTANT;  
	Ops[OpsTop].Op = NONE;
	Ops[OpsTop].Val.Index = ConstantsTop++;
	Ops[OpsTop - 1].Op = MULTIPLY;
	OpStackLists[OpStackListsTop].Top = OpsTop++;
	$$ = OpStackListsTop;
*/
    } |
    Primary {
	$$ = $1;
    };

Primary:
    /* Returns an index into OpStackList */
    Atom {
	Ops[OpsTop].Op = NONE;
	Ops[OpsTop].Val.Type = OPCONSTANT;  
	Ops[OpsTop].Val.Index = $1;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpsTop++;
	$$ = OpStackListsTop;
    } |
    IdentifierReference {
	Ops[OpsTop].Op = NONE;
	Ops[OpsTop].Val.Type = OPIDENT;
	Ops[OpsTop].Val.Index = $1;
	OpStackLists[OpStackListsTop].Top = OpsTop;
	OpsTop++;
	$$ = OpStackListsTop;
    } |
    FunctionReference {
    } |
    LPAREN ScalarExpression RPAREN {
	$$ = $2;
    };

AtomCommaList:
    Atom {
	Clists[ClistsTop].Index = $1;
	Clists[ClistsTop].Next = NIL;
	$$ = ClistsTop++;
    } |
    AtomCommaList COMMA Atom {
	Clists[ClistsTop - 1].Next = ClistsTop;
	Clists[ClistsTop].Index = $3;
	Clists[ClistsTop].Next = NIL;
	$$ = $1
	/* *************************  */
    };
Atom:
    Literal {
	$$ = $1;
    };

FunctionReference:
    COUNTFUNC LPAREN ASTERISK RPAREN {
    } |
    DistinctFunctionReference {
    } |
    AllFunctionReference {
    };

DistinctFunctionReference:
    AVGFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    MAXFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    MINFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
  	SUMFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    } |
    COUNTFUNC LPAREN DISTINCT IdentifierReference RPAREN {
    };

AllFunctionReference:
    AVGFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    MAXFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    MINFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
    SUMFUNC LPAREN ALL ScalarExpression RPAREN {
    } |
  ScalarExpression RPAREN {
    };

Table:
    IdentifierReference {
	Identifiers[$1].TableName = Identifiers[$1].ColumnName;
	Identifiers[$1].ColumnName = NULL;
	$$ = $1;
    };

IdentifierReference:
    IDENTIFIER {
	if (strcmp(schemaname, $1) == 0)
		AttrNumber = 0;
	else
		AttrNumber = Qddb_ConvertAttributeNameToNumber(schema,$1);

	if (AttrNumber < 0) {
		qddb_errmsg = Malloc(BUFSIZ);
		qddb_errno = QDDB_ERRNO_PARSE_ERROR;
		sprintf(qddb_errmsg, "Attribute named '%s' is either misplaced \
or it is not an attribute name in Schema", $1);
		YYERROR;
	}
	Identifiers[IdentifiersTop].Column = AttrNumber;
	Identifiers[IdentifiersTop].TableName = NULL;
    Identifiers[IdentifiersTop].ColumnName = (char *)Malloc (strlen($1) + 1);
	strcpy(Identifiers[IdentifiersTop].ColumnName,$1);
	Identifiers[IdentifiersTop].ColumnName[strlen($1) + 1] = '\0';
	$$ = IdentifiersTop++;
    };

IdentifierReferenceCommaList:
    IdentifierReference {
	Clists[ClistsTop].Index = $1;
	Clists[ClistsTop].Next = NIL;
	$$ = ClistsTop++;
    } |
    IdentifierReferenceCommaList COMMA IdentifierReference {
	Clists[ClistsTop - 1].Next = ClistsTop;
	Clists[ClistsTop].Index = $3;
	Clists[ClistsTop].Next = NIL;
	ClistsTop++;
	$$ = $1;
	/* ********************* */
    };
Literal:
    STRING {
	Constants[ConstantsTop].Type = STRINGCONS;
    Constants[ConstantsTop].Val.String = (char *) Malloc (strlen($1) + 1);
	strcpy(Constants[ConstantsTop].Val.String,$1);
	Constants[ConstantsTop].Val.String[strlen($1)] = '\0';
	$$ = ConstantsTop++;
    } |
    INTEGER {
	Constants[ConstantsTop].Type = INTEGERCONS;
	Constants[ConstantsTop].Val.Integer = $1;
	$$ = ConstantsTop++;
    } |
    REAL {
	Constants[ConstantsTop].Type = REALCONS;
	Constants[ConstantsTop].Val.Real = $1;
	$$ = ConstantsTop++;
    };

%%
static	char		Strings[STRINGSIZE];
static  unsigned int	StringsTop = 0;

char *AllocString(HowManyBytes)
    unsigned int	HowManyBytes;
{
    char		*str;

    if ((StringsTop + HowManyBytes) >= STRINGSIZE)
	PANIC("Constant STRINGSIZE too small: increase in Headers/Sql.h\n");
    str = Strings + StringsTop;
    StringsTop += HowManyBytes + 1;
    return str;
}

void Qddb_ResetSqlParser()
{
	int i;
//	result = NULL;
	SqlCode = 0;
	for (i=0;i<5;i++)
		SqlState[i] = '0';
	SqlBuf= "";
	IdentifiersTop = 0;
	ConstantsTop = 0;
	OpsTop = 0;
	ClistsTop = 0;
	TabExpsTop = 0;
	OpStackListsTop = 0;
	//printf("InQDDB_ResetSqlParse\n");
	Qddb_ResetSqlLex();
}

char* GetSchemaName() {
	char *temp1;
	char *temp2 = NULL, *schemaname = NULL ;

	temp1 = (char *)Malloc(strlen(schema->RelationName) + 1);
	strcpy (temp1,schema->RelationName);

	temp2 = strsep(&temp1, "/");
	while (temp2 != NULL) {
		schemaname = temp2;
		temp2 = strsep(&temp1, "/");
	}
	return(schemaname);
	Free(temp1);
}
