import java.util.*;
public class Stack {
	public ArrayList list;
	
	/*
	 * Precondition: none
	 * Postcondition: i make a stack
	 */
	public Stack(){
		list = new ArrayList();
		
	}//end constructer
	
	/*
	 * Precondition: a size for the stack, a
	 * Postcondition: i make a stack with size a
	 */
	public Stack(int a){
		list = new ArrayList(a);
		
	}//end constructer
	
	/*
	 * Precondition: a ArrayList for the stack, a
	 * Postcondition: i make a stack with size a
	 */
	public Stack(ArrayList a){
		list = a;
		
	}//end constructer
	
	/*
	 * Precondition: a ArrayList for the stack, a
	 * Postcondition: i make a stack with size a
	 */
	public Stack(Stack a){
		list = a.list;
		
	}//end constructer
	
	/*
	 * Precondition: none
	 * Postcondition: i return the size 
	 */
	public int getSize(){
		return list.size();
	}//end getSize
	
	/*
	 * Precondition: none
	 * Postcondition: i return if its empty (true) or not empty (false)
	 */
	public boolean isEmpty(){
		return (list.size()>0);
	}//end isEmpty
	
	/*
	 * Precondition: a object to push, a
	 * Postcondition: i put a into the stack at place 0 
	 */
	public void push(Object a){
		list.add(a);
		
	}//end push
	
	/*
	 * Precondition: none
	 * Postcondition: i remove and return the top dimensionFloat 
	 */
	public Object pop(){
		
		//throw exception
		if(list.size()<=0)
			throw new ArrayIndexOutOfBoundsException();
		
		Object temp = (list.remove(list.size()-1));//store the poped item
		
		return temp;
	}//end pop
	
	/*
	 * Precondition: none
	 * Postcondition: i return the top member without deleting it
	 */
	public Object peekTop(){
		return ((list.get(list.size()-1)));
	}//end peekTop
	
	/*
	 * Precondition: none
	 * Postcondition: i return the top member without deleting it
	 */
	public String lookAt(int index){
		if(index<list.size()){
			return (list.get(index).toString());
		}
		else{
			System.out.println("nothing there");
			return null;
		}
	}//end lookAt
	
	/*
	 * Precondition: give me a sting of instruction: (".5 times first times 
	 * 	second times second")
	 * Postcondition: place the seperate words into a stack: [.5,times,first...]
	 */
	public static Stack toStack(String instructions){
		StringTokenizer str = new StringTokenizer(instructions, " ");
		//Stack items = new Stack();
		
		ArrayList things= new ArrayList();
		ArrayList thingsReversed= new ArrayList();
		
		int numb = str.countTokens();
		
		for(int i = numb; i>0; i--){
			//items.push(str.nextToken());
			things.add(str.nextToken());
		}
		
		int size = things.size();
		while(size>0){
			thingsReversed.add(things.get(size-1));
			things.remove(size-1);
			size--;
		}
		return (new Stack(thingsReversed));
		//return items;
		/*
		ArrayList things= new ArrayList();
		int next = instructions.indexOf(" ");
		boolean finished = false;//exit varable
		
		//placing the first thing into instructions
		things.add(instructions.substring(0, next));
		
		while(finished == false){
			//changing instructions
			instructions = instructions.substring(next+1, instructions.length());
			next = instructions.indexOf(" ");//altering the next varable
			if(next == -1){//if on the last word
				finished = true;//exit the loop
				next = instructions.length();
			}
			things.add(instructions.substring(0, next));
		}
		ArrayList rever = new ArrayList();
		for(int index = 0; index< things.size(); index++){
			rever.add(things.get(things.size() - 1 - index));
		}
		
		Stack thingsReversed = new Stack(rever);
		return (new Stack(things));
		//return thingsReversed;
		 
		 */
	}//end toStack
	
	/*
	 * Precondition: give me a index in a stack 
	 * Postcondition: return true if it is an operator, false if it is not
	 */
	public static boolean isElementOperator(Object obj){
		String there = (obj.toString());
		
		if(there.equalsIgnoreCase("times"))
			return true;
		else if (there.equalsIgnoreCase("divide"))
			return true;
		else if (there.equalsIgnoreCase("squared"))
			return true;
		else if (there.equalsIgnoreCase("squareRoot"))
			return true;
		else if (there.equalsIgnoreCase("plus"))
			return true;
		
		return false;
		
	}//end isElementOperator
	
	/*
	 * Precondition: give me a index in a stack 
	 * Postcondition: return true if it is an index, false if it is not
	 */
	public static boolean isElementIndex(Object obj){
		String there = (obj.toString());
		if(there.charAt(0)=='$')
			return true;
		else 
			return false;
		
	}//end isElementIndex
	
	/*
	 * Precondition: give me a index in a stack 
	 * Postcondition: return true if it is a Number, false if it is not
	 */
	public static boolean isElementNumber(Object obj){
		if(Stack.isElementIndex(obj) || Stack.isElementOperator(obj))
			return false;
		else{
			return true;
		}
		
	}//end isElementNumber
	
	/*
	 * Precondition: give me a index in a stack 
	 * Postcondition: if it is an index, then I parseInt it into a int
	 */
	public static int elementIntoInt(Object obj){
		if(!Stack.isElementIndex(obj))
			return 0;
		else{
			String whole = (String)(obj);
			String actual = whole.substring(1, whole.length());
			
			return (Integer.parseInt(actual));
		}
		
	}//end elementIntoInt
	
	/*
	 * Precondition: none 
	 * Postcondition: modify the stack after the first set of operations
	 */
	public Stack modify(){
		if(((this.lookAt(1)).equalsIgnoreCase("squared")) || (this.lookAt(1)).equalsIgnoreCase("squareRoot")){
			this.pop();
			this.pop();
			return this;
		}
		else{
			this.pop();
			this.pop();
			this.pop();
			return this;
		}
	}//end modify
	
	/*
	 * Precondition: none
	 * Postcondition: i return the stack in a string form
	 */
	public String toString(){
		String total = "";
		
		for(int index = 0; index< list.size(); index++){
			total += this.lookAt(index) + "\n";
		}
		//total = total + ".";
		return total;
	}//end toString
}//end Stack

