import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.JOptionPane;
import java.util.*;

public class EquationsGui extends JFrame implements ActionListener{
	
	//GUI Declarations
	private JPanel dataPanel, dataPanelEasy, dataGiven, easyPanel;
	private JButton add, erase, solve, wanted, exit, select_choice;
	private JTextArea given, floatT, solution;
	private final JTextArea equations;
	private JLabel warning, warning2, addFloat, addDis, addTime, addMass, systemLabel, unitsLabel, typeLabel;
	private Choice distance_power, time_power, mass_power, distances, times, masses, dimensions, systems, types, UNITS;
	
	//declerations for add button
	public DimensionFloatGroup list = new DimensionFloatGroup();
	public DimensionFloatGroup listSorted;
	public DimensionGroup actualEquation;
	public Dimension needed;
	public dimensionFloat current;
	public dimensionFloat result;
	boolean wantedGiven = false;
	public Units units = new Units();
	
	//Memory Holders for the Wanted
	String wantedD, wantedT, wantedM;
	
	public EquationsGui(){
		super("Welcome To Equations 1.0.1");
		
		equations EQU = new equations();
		dataPanel = new JPanel();
		dataGiven = new JPanel();
		
				//new ones
		easyPanel = new JPanel();
		dataPanelEasy = new JPanel();
		
		dataPanel.setLayout(new GridLayout(9, 4));
		dataGiven.setLayout(new GridLayout(2, 2));
		
				//new ones
		dataGiven.setLayout(new GridLayout(2, 1));
		dataPanelEasy.setLayout(new GridLayout(2, 3));
		
		//GUI initializations
		warning = new JLabel("POWER");
		warning2 = new JLabel("UNIT");
		addFloat = new JLabel("VALUE");
		addDis = new JLabel("Distance");
		addTime = new JLabel("Time");
		addMass = new JLabel("Mass");
		
			//new ones
		systemLabel = new JLabel("System");
		unitsLabel = new JLabel("Units");
		typeLabel = new JLabel("Type");
		
		floatT = new JTextArea("");
		
		add = new JButton("Add Data");
		add.addActionListener(this);
		wanted = new JButton("Add Wanted");
		wanted.addActionListener(this);
		erase = new JButton("Erase Fields");
		erase.addActionListener(this);
		solve = new JButton("Solve");
		solve.addActionListener(this);
		exit = new JButton("EXIT");
		exit.addActionListener(this);
		select_choice = new JButton("Set");
		select_choice.addActionListener(this);
		
		given = new JTextArea("Given Data: \n");
		equations = new JTextArea("Known Equations: \n" + EQU);
		
		solution = new JTextArea("Solution: \n\n\n\n");
		
		distance_power = new Choice();
		distance_power.addItem("0");
		distance_power.addItem("1");
		distance_power.addItem("-1");
		distance_power.addItem("2");
		distance_power.addItem("-2");
		
		time_power = new Choice();
		time_power.addItem("0");
		time_power.addItem("1");
		time_power.addItem("-1");
		time_power.addItem("2");
		time_power.addItem("-2");
		
		mass_power = new Choice();
		mass_power.addItem("0");
		mass_power.addItem("1");
		mass_power.addItem("-1");
		mass_power.addItem("2");
		mass_power.addItem("-2");
		
		distances = new Choice();
		distances.addItem("METER");
		distances.addItem("KILOMETER");
		distances.addItem("CENTIMETER");
		distances.addItem("FOOT");
		distances.addItem("YARD");
		distances.addItem("MILE");
		distances.addItem("INCH");
		
		times = new Choice();
		times.addItem("SECOND");
		times.addItem("MINUTE");
		times.addItem("HOUR");
		times.addItem("DAY");
		times.addItem("WEEK");
		
		masses = new Choice();
		masses.addItem("GRAM");
		masses.addItem("KILOGRAM");
		masses.addItem("POUND");
		masses.addItem("OUNCE");
		masses.addItem("SLUG");
		
		dimensions = new Choice();
		dimensions.addItem("Acceleration");
		dimensions.addItem("Velocity");
		
		systems = new Choice();
		systems.addItem("NONE");
		systems.addItem("METRIC");
		systems.addItem("BRITISH");
	
		
		//add stuff to dataPanel
		dataPanel.add(new JPanel());
		dataPanel.add(new JPanel());
		dataPanel.add(addFloat);
		dataPanel.add(new JPanel());
		
		dataPanel.add(new JPanel());
		dataPanel.add(new JPanel());
		dataPanel.add(floatT);
		dataPanel.add(new JPanel());
		
		dataPanel.add(new JPanel());
		dataPanel.add(addDis);
		dataPanel.add(addTime);
		dataPanel.add(addMass);
		
		dataPanel.add(warning);		
		dataPanel.add(distance_power);
		dataPanel.add(time_power);
		dataPanel.add(mass_power);
		
		dataPanel.add(warning2);
		dataPanel.add(distances);
		dataPanel.add(times);
		dataPanel.add(masses);
		
		dataPanel.add(new JPanel());
		dataPanel.add(wanted);
		dataPanel.add(new JPanel());
		dataPanel.add(add);
		
		dataPanel.add(new JPanel());
		dataPanel.add(new JPanel());
		dataPanel.add(erase);
		dataPanel.add(new JPanel());
		
		dataPanel.add(dimensions);
		dataPanel.add(new JPanel());
		dataPanel.add(solve);
		dataPanel.add(new JPanel());
		
		dataPanel.add(select_choice);
		dataPanel.add(new JPanel());
		dataPanel.add(exit);
		dataPanel.add(new JPanel());
		
		//add textFields to dataGiven
		//easyPanel.add(dataPanel);
		dataGiven.add(dataPanel);
		dataGiven.add(given);
		dataGiven.add(equations);
		dataGiven.add(solution);
		
		//necessary actions to the main JFrame
		this.add(dataGiven, BorderLayout.NORTH);
		this.setSize(1200,500);
		this.setLocation(50, 50);
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	public void actionPerformed(ActionEvent ex){
		if(ex.getSource()==select_choice){
			if(dimensions.getSelectedItem().equalsIgnoreCase("Acceleration")){
				distance_power.select("1");
				time_power.select("-2");
			}
			if(dimensions.getSelectedItem().equalsIgnoreCase("Velocity")){
				distance_power.select("1");
				time_power.select("-1");
			}
		}
		if(ex.getSource()==add){
			double flt, newFloat;
			int dis, tim, mas;
			int disPower, timPower, massPower;
			dimensionFloat distanceDF, timeDF, massDF, current;
			String distanceU, timeU, massU;
	
			try{
				
				disPower = Integer.parseInt(distance_power.getSelectedItem());//get power
				distanceU = distances.getSelectedItem();//get name of unit
				distanceDF = (dimensionFloat)(Units.units.get(distanceU));//turn name into DF
				distanceDF = distanceDF.toPower(disPower);//take the DF to given power
							
				timPower = Integer.parseInt(time_power.getSelectedItem());//get power
				timeU = times.getSelectedItem();//get name of unit
				timeDF = (dimensionFloat)(Units.units.get(timeU));//turn name into DF
				timeDF = timeDF.toPower(timPower);//take the DF to given power
				
				massPower = Integer.parseInt(mass_power.getSelectedItem());//get power
				massU = masses.getSelectedItem();//get name of unit
				massDF = (dimensionFloat)(Units.units.get(massU));//turn name into DF
				massDF = massDF.toPower(massPower);//take the DF to given power
				
				flt = Double.parseDouble(floatT.getText());
				current = new dimensionFloat(flt);
				
				current = current.multiply(distanceDF);//now in meters
				current = current.multiply(timeDF);//now in seconds
				current = current.multiply(massDF);//now in grams
				
				list.add(current);//adds to the list
				
				//create a flase, presentable current
				dimensionFloat PresentableCurrent = new dimensionFloat(flt, disPower, timPower, massPower);
				PresentableCurrent.distanceName = distanceU;//change its distance name
				PresentableCurrent.timeName = timeU;//change its time name
				PresentableCurrent.massName = massU;//change its mass name
				
				given.setText(given.getText() + PresentableCurrent + "\n");//adds to the text box
			}//end try
			
			catch(NumberFormatException e){
				System.out.println("Distance, Time and Mass must be Integers. " +
						"Floats can be Doubles");
			}
		}//end add
		
		if(ex.getSource()==wanted){
			int dis, tim, mas;
			Dimension PresentableWanted = new Dimension(0,0,0);
			
			if(wantedGiven){
				given.setText(given.getText() + "A dimension for the wanted variable " +
						"already exists" + "\n");
			}
			else{
				try{
					wantedGiven = true;
					dis = Integer.parseInt(distance_power.getSelectedItem());
					tim = Integer.parseInt(time_power.getSelectedItem());
					mas = Integer.parseInt(mass_power.getSelectedItem());
					
					needed = new Dimension(dis, tim, mas);
					list.endResult = needed;
					
					wantedD = distances.getSelectedItem();//get name of unit
					wantedT = times.getSelectedItem();//get name of unit
					wantedM = masses.getSelectedItem();//get name of unit
					
//					//create a flase, presentable current
					PresentableWanted = new Dimension(dis, tim, mas);
					PresentableWanted.distanceName = wantedD;//change its distance name
					PresentableWanted.timeName = wantedT;//change its time name
					PresentableWanted.massName = wantedM;//change its mass name
					
				}
				catch(NumberFormatException e){
					System.out.println("Distance, Time and Mass must be Integers.");
					System.exit(0);
				}
				
				given.setText(given.getText() + "WANTED: " + PresentableWanted + "\n");
			}
		}//end wanted
		
		if(ex.getSource()==erase){
			floatT.setText("");
			
			int s = list.size(); 
			for(int index = s; index>0; index--){
				list.remove(0);
			}
			
			solution.setText("");
			given.setText("");
			
			needed = null;
			wantedGiven = false;
			
			System.out.println("list:" + list);
			System.out.println("needed:" + needed);
						
		}//end erase
		
		if(ex.getSource()==solve){
				
			if(!wantedGiven){
				solution.setText("Need the dimensions of the desired result.");
			}
			else{
				//solving using equations
				equations EQU = new equations();
				int where = list.belongAsEquation(EQU);
					
				if(where == -1){
					solution.setText("Matching equation not found.\n");//
				}
				else{
					
					
					DimensionGroup matchingEquation = EQU.lookAt(where);
					list.information = matchingEquation.information;
					list.EQUinformation = matchingEquation.EQUinformation;//
					
					solution.setText("1. Solving Using Known Equations: \n");	
					solution.setText(solution.getText() + "	Equation is Found\n");
					solution.setText(solution.getText() + "	Equation Information: " + 
							matchingEquation.EQUinformation + "\n");
					solution.setText(solution.getText() + "	Polish Post-Fix: " + 
							matchingEquation.information + "\n");
					
					//System.out.println("before listSorted in GUI.");				
					listSorted = new DimensionFloatGroup(DimensionFloatGroup.sort(list));
					listSorted.endResult = list.endResult;
					listSorted.information = matchingEquation.information;
					listSorted.EQUinformation = matchingEquation.EQUinformation;
					//System.out.println("after listSorted in GUI: " + listSorted);	
					
					result = new dimensionFloat(DimensionFloatGroup
							.solveWithInstructions(listSorted));
					
					//change units of wanted
					dimensionFloat distanceDF, timeDF, massDF;
					double productAll;
					
					distanceDF = (dimensionFloat)(Units.units.get(wantedD));//turn name into DF
					timeDF = (dimensionFloat)(Units.units.get(wantedD));//turn name into DF
					massDF = (dimensionFloat)(Units.units.get(wantedM));//turn name into DF
					
					result.distanceName = wantedD;//change its distance name
					result.timeName = wantedT;//change its time name
					result.massName = wantedM;//change its mass name
					
					productAll = distanceDF.value * timeDF.value * massDF.value;//multiply by all of the constants
					result.value = result.value/productAll;//divide the base by the constants
					
					solution.setText(solution.getText() + "	Equation Derived Solution is " + 
							result + "\n");
					
					
					
				}
				solution.setText(solution.getText()+ "------------------------------------------------------------");
				solution.setText(solution.getText()+ "\n"+ "2. Solving Using Recursion:");
				//solving using recursion
				ArrayList dimensions = list.Dimensions;
				ArrayList dimensions2 = list.Dimensions;
				int size = list.Dimensions.size();
				int dis, tim, mas;
				int treated = 0;
				int[] solutions = new int[size];
				
				Dimension combSoFar = new Dimension(0,0,0);
				Dimension goal = list.endResult;
				dimensionFloat resultRec = new dimensionFloat(1, 0, 0, 0);
				
				for(int i = 0; i< size; i++){solutions[i] = 0;}
				
				list.solveRec(dimensions, combSoFar, goal, 0, solutions);
				
				for(int i = 0; i< solutions.length; i++){
					solution.setText(solution.getText()+ "\n"+ "	Recursion Determined: dimension number " + i + " needs to be taken to " + solutions[i] + " power.");
					dimensionFloat temp = ((dimensionFloat)dimensions2.get(i)).toPower(solutions[i]);
					resultRec = dimensionFloat.multiply(resultRec, temp);
				}
				
				//change units of wanted
				dimensionFloat distanceDF, timeDF, massDF;
				double productAll = 1;
				
				distanceDF = (dimensionFloat)(Units.units.get(wantedD));//turn name into DF
				timeDF = (dimensionFloat)(Units.units.get(wantedD));//turn name into DF
				massDF = (dimensionFloat)(Units.units.get(wantedM));//turn name into DF
				
				productAll = distanceDF.value*timeDF.value*massDF.value;//multiply by all of the constants
				System.out.println("ProductAll = " + productAll);
				resultRec.value = resultRec.value/productAll;//divide base by the constants
				
				resultRec.distanceName = wantedD;//change its distance name
				resultRec.timeName = wantedT;//change its time name
				resultRec.massName = wantedM;//change its mass name
				
				solution.setText(solution.getText() + "\n" + "	Recurssion Derived Solution is " + 
						resultRec + "\n");
			}
				
		}//end solve
	}
	
	public static void main(String[] args) {
		EquationsGui bob = new EquationsGui();

	}

}



