
public class Dimension{
	protected int dimension[] = new int[3];
	public String distanceName = "meters", timeName = "seconds", massName = "grams", dimName = "";
	
	/*
	 * Precondition: all given varibles are of the correct type
	 * Postcondition: I make a Dimension with (distance= distance, time = time, 
	 * mass= mass)
	 */
	public Dimension(int distance, int time, int mass){
		dimension[0] = distance;
		dimension[1] = time;
		dimension[2] = mass;
	}//end Dimension constructer
	
	/*
	 * Precondition: all given varibles are of the correct type
	 * Postcondition: I make a Dimension copy
	 */
	public Dimension(Dimension d){
		dimension[0] = d.dimension[0];
		dimension[1] = d.dimension[1];
		dimension[2] = d.dimension[2];
	}//end Dimension constructer
	
	/*
	 * Precondition: array of ints, array[]
	 * Postcondition: I make a Dimension with same array as the array given
	 */
	public Dimension(int array[]){
		super();//if array.length != dimesnion.length, this is the protection
		for (int index = 0; index<dimension.length; index++)
			dimension[index] = array[index];
	}//end Dimension constructer
	
	/*
	 * Precondition: none
	 * Postcondition: I make a Dimension with (distance= 0, time = 0, mass= 0)      
	 */
	public Dimension(){
		dimension[0] = 0;
		dimension[1] = 0;
		dimension[2] = 0;
	}//end Dimension constructer
	
	/*
	 * Precondition: none.
	 * Postcondition: I return the array.
	 */
	protected int[] getArray(){return dimension;}
	

	/*
	 * Precondition: a variable of type int[], newArray
	 * Postcondition: I set the array to newArray
	 */
	protected void setArray(int[] newArray){dimension = newArray;}
	
	/*
	 * Precondition: a variable of type Dimension, d
	 * Postcondition: I return -1, if the caller[this] is smaller then the parameter
	 * 						    0, if the caller[this] is uqual to the paramenter
	 * 							1, if the caller[this] is greater then the parameter
	 */
	public int compareTo(Dimension d){
		int myDis = this.dimension[0];
		int myTime = this.dimension[1];
		int myMass = this.dimension[2];
		
		int hisDis = d.dimension[0];
		int hisTime = d.dimension[1];
		int hisMass = d.dimension[2];
		
		if(myDis>hisDis){
			return 1;
		}
		else if(myDis == hisDis){
			if(myTime>hisTime){
				return 1;
			}
			else if(myTime == hisTime){
				if(myMass > hisMass){
					return 1;
				}
				else if(myMass == hisMass){
					return 0;
				}
				else
					return -1;
			}
			else
				return -1;
		}
		else
			return -1;
	}//end compareTo
	
	/*
	 * Precondition: 2 Demensions, dim and dim2
	 * Postcondition: return the result from multiplying dim by dim2
	 */
	public static Dimension add(Dimension dim, Dimension dim2){
		int dis1 = dim.dimension[0], dis2 = dim2.dimension[0];
		int time1 = dim.dimension[1], time2 = dim2.dimension[1];
		int mass1 = dim.dimension[2], mass2 = dim2.dimension[2];
				
		//build the result dimensionFloat
		Dimension result = new Dimension(dis1 + dis2, time1 + time2, 
				mass1 + mass2);
		return result;
	}//end add
	
	/*
	 * Precondition: 2 demensionFloats, dim and dim2
	 * Postcondition: return the result from multiplying dim by dim2
	 */
	public Dimension add(Dimension dim){
		return Dimension.add(this, dim);
	}//end add
	
	/*
	 * Precondition: 2 demensionFloats, dimNum and dimDenom
	 * Postcondition: return the result from dividing dimNum by dimDenom
	 */
	public static Dimension subtract(Dimension dimNum, Dimension dimDenom){
		//make a temp so that I cannot mess with the origional
		Dimension temp = new Dimension(dimDenom.getArray()[0], 
				dimDenom.getArray()[1],dimDenom.getArray()[2]);
		//altering that temp so it can be multiplied
		temp.dimension[0]*=-1;
		temp.dimension[1]*=-1;
		temp.dimension[2]*=-1;
		
		return (Dimension.add(dimNum, temp));
	}//end subtract
	
	/*
	 * Precondition: 2 demensionFloats, dimNum and dimDenom
	 * Postcondition: return the result from dividing dimNum by dimDenom
	 */
	public Dimension subtract(Dimension dimDenom){
		return (Dimension.subtract(this, dimDenom));
	}//end subtract
	
	/*
	 * Precondition: 1 Dimension, dim
	 * Postcondition: return true if dimensions are equal, false if they are not
	 */
	public boolean equals(Dimension dim){
		for(int index = 0; index<this.dimension.length; index++)
			if(this.dimension[index] != dim.dimension[index])
				return false;
		return true;
	}//end equals
	
	/*
	 * Precondition: an int, base
	 * Postcondition: take that dimension to the power of that base
	 */
	public Dimension multiply(int base){
		Dimension test = new Dimension(this.dimension);
		for(int index = 0; index <test.dimension.length; index++)
			test.dimension[index] *=base;
		return test;
	}//end multiply
	
	public boolean isEven(){
		for(int index = 0; index<3; index++)	
			if(!(this.dimension[index]%2 == 0))
				return false;
			
		return true;
	}
	
	public Dimension squareRootExp(){
		if(!this.isEven())
			return null;
		else{
			Dimension d = new Dimension(this);
			for(int index = 0; index<3; index++)
				d.dimension[index] = this.dimension[index]/2;
			
			return d;
		}
	}
	/*
	 * Precondition: none
	 * Postcondition: return the string version of Dimension
	 */
	public String toString(){
		if(dimName.equalsIgnoreCase(""))
			return (dimension[0] + " " + distanceName + ", " + dimension[1] + " " + 
				timeName + ", "	+ dimension[2] + " " + massName + ".");
		else
			return (dimName);
	}//end Dimension
}
