#ifndef interface_h
#define interface_h

/*	 This file specifies the details maintained at the user site
	for interacting with the user
*/
#include "pdfs.h"

#define DIR_TYPE	1
#define F_TYPE		2
#define NOT_USED	3
#define NOT_REGISTERED  -4
#define REGISTERED 5

typedef struct details {
	//int fd; // file descriptor
	pdfs_fh	pri_fh; // primary file hande
	pdfs_fh pref_fh; // preferred file handle
	// char pri_srvr[16]; // primary server in dotted quad
	char pref_srvr[16]; // preferred server in dotted quad
	char *f_name; 	  // name of the file
	int prnt_fd; // parent directory file handle
	int f_type; // file type 0 - regular file
		   // 1 - directory
	open_stat omode;
} f_details;

// function prototypes

void process_option( int ); // process the user's option
int is_proper_fd(int , int ); // check the fd's integrity
void initialise_ftable(); // intialise the file table
int get_next_fd(); // get the next available fd

void update_fh(pdfs_fh *old_fh, pdfs_fh *new_fh, char *pref_srvr);
void revert_fh(pdfs_fh *old);

// external functions
extern void create_file();
extern void create_dir();
extern void csd_rename();
extern void delete_file();
extern void delete_dir();
extern int mount(char *, pdfs_fh *, char *);
extern int  unmount(); // umount the file system
extern int lookup(pdfs_fh *, char *, pdfs_fh *, char *);
	// lookup for a file
extern int pdfs_read(pdfs_fh *, char **, u_long, u_long, char *);
extern int pdfs_write(pdfs_fh *, char *, u_long, u_long, char *);
extern int pdfs_readdir(pdfs_fh *, char **, char *);
extern int f_register(pdfs_fh *, u_short , char *, char *);
extern int unregister(pdfs_fh *, u_short , char *, char *);
extern char *print_fh(pdfs_fh *);
extern int check_synchfd(int );

void close_fd( int ); // close an open file descriptor
void print_all_fds(); // print details of all fds
void print_fd_details( int ); // print the details of a specific fd
void read_user(char **, int );
int check_before_readwrite(int, open_stat, open_stat );


#endif
