/* 		Author: Balkrishnan Rukmangathan
		interface.c: User interface for the client side
		in the PDFS file system
*/

#include<stdio.h>
#include<stdlib.h>
#include<stdarg.h>
#include <string.h>

#include "pdfs.h"
#include "interface.h"

f_details f_table[256]; // details about 256 files are maintained here
			// even directory also considered to be a file here
			//fd 0 is the mounted root directory.
int is_mounted=0;

int synch_fd; // synchronisation site fd
int next_fd; // next available fd

int main() {

	/* print the possible options for the user and
	   correspondingly access the server and print the ouptut
	*/

	initialise_ftable();

while (1) {
	int option;
	printf("\t\t1. Mount the File system\n");	
	printf("\t\t2. Lookup a File\n");	
	printf("\t\t3. Read from a File \n");	
	printf("\t\t4. Write to a File \n");	
	printf("\t\t5. List a Directory \n");	
	printf("\t\t6. Delete a File \n");	
	printf("\t\t7. Create a File \n");	
	printf("\t\t8. Rename a File \n");
	printf("\t\t9. Create a Directory \n");
	printf("\t\t10. Remove a Directory \n");
	printf("\t\t11. Print details of a file descriptor \n");
	printf("\t\t12. Print all fd's details \n");
	printf("\t\t13. Close a file descriptor \n");
	printf("\t\t14. Exit the File system\n\n\n");
	printf("Select one of the above options :\t");
	fflush(stdin);
	scanf("%d", &option);
	fflush(stdout);
	if ((option >= 1 ) || ( option <= 14 )) 
		process_option(option);
 	else printf("Illegal option %d \n",option);
	printf("*********************************************************\n");
	fflush(stdin);

}// loop for ever
return 0;	
}

void process_option( int option) {
	// process the requesting according to the 
	// option selected 


	int retval;
	
	// before processing check whether anything from the 
	// synchronisation site

	while (check_synchfd(synch_fd))
		;

	switch( option ) {
	case 1 : {
		char s_addr[16];
		if (is_mounted) {
			printf("File system already mounted \n");
			break; }
		fflush(stdin);
		printf("Enter the synchronisation site ip in dotted quad:");
		scanf("%s",s_addr);
		memset(&f_table[0],0,sizeof(f_details));
		printf("Mounting the File system ...\n");
		retval = mount(s_addr,&f_table[0].pri_fh,f_table[0].pref_srvr);
		printf("Mount returned %d", retval);
		f_table[0].f_type = DIR_TYPE;
		if (retval == 1) printf("Mounted successfully ..\n");
		printf("the storage site is %s\n",f_table[0].pref_srvr);
		is_mounted = 1;
		f_table[0].f_name = (char *)malloc(sizeof(char)*1);
		*f_table[0].f_name = '/';
		break;
	}
	case 2 : {
		int dir_fd;
		printf("\t\t2. Lookup a File\n");
		if (!is_mounted) { printf("First mount the fs\n"); break; }
		printf("Enter the fd of the directory where u want to lookup:");
		fflush(stdin);
		scanf("%d",&dir_fd);
		if ( (dir_fd <= -1 ) && (dir_fd >= 256) ) {
			printf("Wrong directory fd %d \n",dir_fd);
			break; }
		if ( !is_proper_fd(dir_fd, DIR_TYPE)) {
			printf("Improper type of fd \n");
			break; }
		else {
			pdfs_fh new_fh;
			char f_name[PDFS_MAXNAMELEN];
			printf("Enter the name of the file to lookup :");
			fflush(stdin);
			scanf("%s",&f_name);
			memset(&new_fh,0,PDFS_FHSIZE);
			retval = lookup(&(f_table[dir_fd].pri_fh),f_name,&new_fh,f_table[0].pref_srvr);
			printf("Lookup returns %d \n",retval);
			if (retval >= 1) {
				int fd = get_next_fd();
				if ( !fd ) { printf("No more fd's available\n");
					break; }
				memset(&f_table[fd],0,sizeof(f_details));
				memcpy(&f_table[fd].pri_fh,&new_fh,PDFS_FHSIZE);
				// copy file name here;
				f_table[fd].prnt_fd = dir_fd;
				printf("The file typs is %s\n",(retval == 1) ? "DIRECTORY" : "REGULAR FILE");
				f_table[fd].f_type =  retval;
				f_table[fd].f_name = (char *)malloc(sizeof(char)*( strlen(f_name) + strlen(f_table[dir_fd].f_name)+ 1 ) );
				strcpy(f_table[fd].f_name,f_table[dir_fd].f_name);
				strcat(f_table[fd].f_name,f_name);
				if (retval == DIR_TYPE ) 
					strcat(f_table[fd].f_name,"/");
				printf("File name is %s\n",f_table[fd].f_name);
				printf("fd allocated is %d \n",fd);
				f_table[fd].omode = NOT_REGISTERED;
			}
			break;
	} // end of else
	}
	case 3 : {
		int nbytes,pos,fd;
		char *buff;
		retval = 0;
		printf("\t\t3. Read from a File \n");	
		if (!is_mounted) { printf("First mount the fs\n"); break; }
		printf("Enter the fd of the file u want to read ");
		fflush(stdin);
		scanf("%d", &fd);
		if (!check_before_readwrite(fd,F_READ,F_RDWR))
			break;  
		printf("Enter the file position \t");
		fflush(stdin);
		scanf("%d",&pos);
		printf("Enter the number of bytes to read \t");
		fflush(stdin);
		scanf("%d",&nbytes);
		// if pref_srvr is empty use our own primary server.
		// else use the pref_server
		if (!strcmp(f_table[fd].pref_srvr,""))
			retval = pdfs_read(&f_table[fd].pri_fh, &buff, 
					nbytes, pos, f_table[0].pref_srvr);
		else retval = pdfs_read(&f_table[fd].pref_fh, &buff, nbytes,
					pos, f_table[fd].pref_srvr);
		printf("Read %d bytes\n", retval);
		printf("\n \t\t********************************\n");
		if (retval >= 1) {
			char *t_ptr = buff;
			int i=0;
			for (i=0; i< retval; i++)
				printf("%c",*t_ptr++);
		}
		printf("\n \t\t********************************\n");
		if (retval >= 1 ) free(buff); // do the cleanup
		break;
	}
	case 4 : {
		int nbytes,pos,fd;
		char *buff;
		retval = 0;
		printf("\t\t3. Write to a File \n");	
		if (!is_mounted) {printf("First mount the fs\n"); break; }
		printf("Enter the fd of the file u want to write to ");
		fflush(stdin);
		scanf("%d", &fd);
		if (!check_before_readwrite(fd,F_WRITE,F_RDWR))
			break;  
		printf("Enter the file position \t");
		fflush(stdin);
		scanf("%d",&pos);
		printf("Enter the number of bytes to write \t");
		fflush(stdin);
		scanf("%d\n",&nbytes);
		fflush(stdin);
		read_user(&buff,nbytes);
		// if pref_srvr is empty use our own primary server.
		// else use the pref_server
		if (!strcmp(f_table[fd].pref_srvr,""))
			retval = pdfs_write(&f_table[fd].pri_fh, buff, nbytes, pos, f_table[0].pref_srvr);
		else retval = pdfs_write(&f_table[fd].pref_fh, buff, nbytes, pos, f_table[fd].pref_srvr);
		printf("Write returned  %d\n", retval);	
		fflush(stdin);
		break;
	}
	case 5 : {
		int dir_fd;
		printf("\t\t5. List a Directory \n");	
		if (!is_mounted) { printf("First mount the fs\n"); break; }
		printf("Enter the fd of the directory u want to list:");
		fflush(stdin);
		scanf("%d",&dir_fd);
		if ( (dir_fd <= -1 ) && (dir_fd >= 256) ) {
			printf("Wrong directory fd %d \n",dir_fd);
			break; }
		if ( !is_proper_fd(dir_fd, DIR_TYPE)) {
			printf("Improper type of fd \n");
			break; }
		else {
			int i;
			char *buffer,*ptr;
			retval = pdfs_readdir(&f_table[dir_fd].pri_fh, &buffer, f_table[0].pref_srvr);
			if (retval >= 1) { 
			ptr = buffer;
			// printf("%s\n",buffer);
			for(i = 0; i< retval; i++) {
				char f_name[PDFS_MAXNAMELEN];
				sscanf(ptr,"%s *", f_name);
				ptr += strlen(f_name)+2;
				printf(" %s \n", f_name);
			}
			free(buffer);
			} // end of if
		}
		break;
	}
	case 6 : {
		printf("\t\t6. Delete a File \n");	
		if (!is_mounted) printf("First mount the fs\n");
		else delete_file();
		break;
	}
	case 7 : {
		printf("\t\t7. Create a File \n");	
		if (!is_mounted) printf("First mount the fs\n");
		else create_file();
		break;
	}
	case 8 : {
		printf("\t\t8. Rename a File \n");
		if (!is_mounted) printf("First mount the fs\n");
		else csd_rename();
		break;
	}
	case 9 : {
		printf("\t\t9. Create a Directory \n");
		if (!is_mounted) printf("First mount the fs\n");
		else create_dir();
		break;
	}
	case 10 : {
		printf("\t\t10. Remove a Directory \n");
		if (!is_mounted) printf("First mount the fs\n");
		else delete_dir();
		break;
	}
	case 11: {
		int fd;
		fflush(stdin);
		printf("Enter the fd \t");
		scanf("%d",&fd);
		fflush(stdin);
		if ( (fd <= -1 ) && (fd >= 256) ) {
			printf("Wrong fd %d \n",fd);
			break; }
		if (is_proper_fd(fd, NOT_USED)) {
			printf("This fd is not in use \n");
			break; }
		print_fd_details(fd);
		break;
	}
	case 12: {
		print_all_fds();
		break;
	}
	case 13: {
		int fd;
		fflush(stdin);
		printf("Enter the fd \t");
		scanf("%d",&fd);
		fflush(stdin);
		if (fd == 0) {
			printf("You are closing the root file handle\n");
			printf("This is equivalent to unmounting \n");
			unmount(); is_mounted = 0; 
		}
		else close_fd(fd);
		break;
	}
	case 14: {
		// do the cleanup here
		unmount();
		printf("Exiting the system \n");
		exit(0); 
	}	
	default : printf("Improper choice \n");
	}// end of switch
}// end of process option


int is_proper_fd(int fd, int type)
{
	return ( (f_table[fd].f_type == type ) ? 1: 0);
}

void initialise_ftable()
{
	int i;
	for (i=0; i<256; i++) {
		f_table[i].f_type = NOT_USED;
		f_table[i].omode = NOT_REGISTERED;
	}
}

int get_next_fd()
{
	int i;
	for(i=0; i<256; i++)
		if(f_table[i].f_type == NOT_USED ) return i;
	return 0;
}

void print_fd_details(int fd)
{
	printf("Printing the details of fd -- %d\n",fd);
	printf("File name \t--\t%s\n",f_table[fd].f_name);
	printf("File type \t--\t%s\n",(f_table[fd].f_type == 1) ? "DIRECTORY" : "REGULAR FILE");
	printf("Parent fd is \t--\t%d\n",f_table[fd].prnt_fd);
	printf("WARNING: The above field  is just an hint \n");
	printf("Preferred server is \t--\t%s\n",f_table[fd].pref_srvr);
	return;
}

void print_all_fds()
{
	int i;
	for(i=0; i<256; i++)
		if (f_table[i].f_type != NOT_USED )
			print_fd_details(i);
	return;
}

void close_fd(int fd)
{
	if (is_proper_fd(fd,NOT_USED)) {
		// printf("The descriptor is anyway not in use \n");
		return ;
	}
	if ( (f_table[fd].f_type == F_TYPE) && 
		(f_table[fd].omode !=  NOT_REGISTERED) )
		unregister(&f_table[fd].pri_fh,f_table[fd].omode,f_table[0].pref_srvr,f_table[fd].f_name);
	f_table[fd].f_type = NOT_USED;
	free(f_table[fd].f_name);
	// do file unregister here
}


void read_user(char **buff, int cnt)
{
	char *t_ptr;
	*buff = (char *)malloc(sizeof(char)*cnt);
	t_ptr = *buff;
	fflush(stdin); // flush anything before that
	while(cnt--)
		scanf("%c",t_ptr++);
	*t_ptr = '\0';
	fflush(stdin); // flush the remaining buffers he write
	printf("\n Read %s \n",*buff);
	return ;
}

int check_before_readwrite(int fd, open_stat mode1, open_stat mode2)
{
	if ( (fd <= -1 ) && (fd >= 256) ) {
		printf("Wrong file fd %d \n",fd);
		return 0; }
	if ( !is_proper_fd(fd, F_TYPE) ) {
		printf("Improper type of fd \n");
		return 0; }
	if ( (f_table[fd].omode != mode1) && (f_table[fd].omode != mode2) ){
                        // do the registry here and change the status
              int mode;
              open_stat omode;
              int rval;
              printf("This file is not yet registerted \n");
              printf("1 - Read only 2 - Write only 3 - ReadWrite\n");
              fflush(stdin);
              printf("Enter the mode in which u want to register \t");
              scanf("%d",&mode);
              omode = (mode == 1)?F_READ : (mode == 2) ? F_WRITE :(mode == 3) ? F_RDWR : -1;
              if (omode == -1 ) {
		printf("Entered an illegal option \n");
		return 0; }
		f_table[fd].omode = omode;
              rval = f_register(&f_table[fd].pri_fh,omode, f_table[0].pref_srvr,f_table[fd].f_name);
	      if (!rval) {
			printf("Unable to register to the synch site \n");
			return 0;
		}
	}
	return 1;
} // end of check_before_readwrite


void update_fh(pdfs_fh *old, pdfs_fh *new, char *pref_ss)
{	
	int i;
	printf("updating the file handle \n");
	for (i = 0; i < 256; i++) {
		if ( (f_table[i].f_type == NOT_USED ) || 
			( f_table[i].f_type == DIR_TYPE) )
			continue;
		else if ( !memcmp(old, &f_table[i].pri_fh, PDFS_FHSIZE) ) {
		    // this is the data to be updated
		    printf("Updating the file handle from %s to %s\n",
				print_fh(old), print_fh(new));
		    memcpy(&f_table[i].pref_fh, new, PDFS_FHSIZE);
		    strcpy(f_table[i].pref_srvr,pref_ss);
		    printf("The new server is %s \n",f_table[i].pref_srvr);
		break ; }// updation finished
	}
	printf("Updation finished \n");
}

void revert_fh(pdfs_fh *old)
{	
	int i;
	printf("Reverting the file handle \n");
	for (i = 0; i < 256; i++) {
		if ( (f_table[i].f_type == NOT_USED ) || 
			( f_table[i].f_type == DIR_TYPE) )
			continue;
		else if ( !memcmp(old, &f_table[i].pri_fh, PDFS_FHSIZE) ) {
		    // this is the data to be updated
		    printf("Reverting the file handle from %s to NULL \n", 
				print_fh(old));
		    memset(&f_table[i].pref_fh,0, PDFS_FHSIZE);
		    strcpy(f_table[i].pref_srvr,"");
		break ; }// revertion finished
	}
	printf("Reverting finished \n");
}


void clean_up()
{
	int loopvar;
	printf("Cleaning up everything \n");
	for(loopvar=0; (loopvar<256); loopvar++) {
		close_fd(loopvar);
	}
	printf("Closed all the file descriptors \n");
}
