/* Author: Rukmangathan Balakrishnan 
   pdfs_deamon.c
   Deamon for PDFS storage site that handle all the clients request

*/
#include<stdio.h>
#include<unistd.h>
#include<signal.h>
#include<fcntl.h>
#include<stdlib.h>
#include<dirent.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/socket.h>
#include<arpa/inet.h>
#include<netinet/in.h>

#include "pdfs.h"
#include "pdfs_deamon.h"
#include "defns.h"

/* Flags for auth_fh */
#define CHK_READ	0
#define CHK_WRITE	1
#define CHK_NOACCESS	2

char export_root[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN+1];

struct sockaddr_in synchsite;	// synchronisation site;

struct op_result result;	// where result of an operation is
				// stored

static pdfsstat	build_path(struct svc_req *rqstp, char *buf, struct diropargs *da, int flags);
static fhcache *auth_fh(struct svc_req *rqstp, pdfs_fh *fh, pdfsstat *statp, int flags);
/*
 * auth_fh
 * This function authenticates the file handle provided by the client.
 * It also takes care of caching the client and mount point structures
 * in the fh cache entry, even though this may not be a huge benefit.
 */
static fhcache *auth_fh(struct svc_req *rqstp, pdfs_fh *fh, pdfsstat *statp, int flags)
{
	// static int	total = 0, cached = 0;
	fhcache		*fhc;

	/* Try to map FH. If not cached, reconstruct path with root priv */
	if ((fhc = fh_find((svc_fh *)fh, FHFIND_FEXISTS)) == NULL) {
		*statp = PDFSERR_STALE;
		return NULL;
	}
/* COMPLETELY COMMENTING THE AUTHENTICATION 
	// Try to retrieve last client who accessed this fh 
	if (nfsclient == NULL) {
		struct in_addr	caddr;

		caddr = svc_getcaller(rqstp->rq_xprt)->sin_addr;
		if (fhc->last_clnt != NULL &&
		    fhc->last_clnt->clnt_addr.s_addr == caddr.s_addr) {
			nfsclient = fhc->last_clnt;
		} else if ((nfsclient = auth_clnt(rqstp)) == NULL) {
			*statp = PDFSERR_ACCES;
			return NULL;
		}
	}

	if (fhc->last_clnt == nfsclient) {
		nfsmount = fhc->last_mount;  // get cached mount point 
		cached++;
	} else {
		nfsmount = auth_path(nfsclient, rqstp, fhc->path);
		if (nfsmount == NULL) {
			*statp = PDFSERR_ACCES;
			return NULL;
		}
		fhc->last_clnt = nfsclient;
		fhc->last_mount = nfsmount;
	}
	total++;
	if (nfsmount->o.noaccess &&
	    ((flags & CHK_NOACCESS) || strcmp(nfsmount->path, fhc->path))) {
		struct in_addr	addr = svc_getcaller(rqstp->rq_xprt)->sin_addr;
		log_write("PDFS_DEAMON : client %s tried to access %s (noaccess)\n",
				inet_ntoa(addr), fhc->path);
		*statp = PDFSERR_ACCES;
		return NULL;
	}

	if ((flags & CHK_WRITE) && (nfsmount->o.read_only || read_only)) {
		*statp = PDFSERR_ROFS;
		return NULL;
	}

	auth_user(nfsmount, rqstp);
*/
	*statp = PDFS_OK;
	return fhc;
}

/*
 * Build the full path name for a file specified by diropargs.
 */
static inline pdfsstat
build_path(struct svc_req *rqstp, char *buf, struct diropargs *da, int flags)
{
	fhcache	*fhc;
	pdfsstat status;
	char	*path = buf, *sp;

	/* Authenticate directory file handle */
	if ((fhc = auth_fh(rqstp, &(da->dir_fh),&status,flags)) == NULL)
		return status;

	/* Get the directory path and append "/" + dopa->filename */
	sp = fhc->path;

	while (*sp)		/* strcpy(buf, fhc->path); */
		*buf++ = *sp++;
	*buf++ = '/';		/* strcat(buf, "/");  */
	sp = da->name;
	while (*sp) {		/* strcat(pathbuf, argp->where.name); */
		if (*sp == '/')
			return PDFSERR_INVAL;
		*buf++ = *sp++;
	}
	*buf = '\0';

	if (strlen(path) > PDFS_MAXPATHLEN)
		return PDFSERR_NAMETOOLONG;
/* COMMENTING THE AUTHENTICATION 
	if ((nfsmount = auth_path(nfsclient, rqstp, path)) == NULL) {
		return PDFSERR_ACCES;
	}
	auth_user(nfsmount, rqstp);
*/

	return (PDFS_OK);
}

pdfsstat pdfs_null(argp, rqstp)
void *argp;
struct svc_req	*rqstp;
{
	return PDFS_OK;
}

pdfsstat pdfs_getattr(argp, rqstp)
pdfs_fh *argp;
struct svc_req	*rqstp;
{
	fhcache *fhc;
	pdfsstat status;
	fhc = auth_fh(rqstp, argp, &status, CHK_READ);
	if (fhc == NULL)
		return status;
	return fhc_getattr(fhc, &(result.attr));
}

pdfsstat pdfs_setattr(argp, rqstp)
struct setattrargs *argp;
struct svc_req	*rqstp;
{
	pdfsstat status;
	fhcache *fhc;
	char *path;
	struct stat buf;
	fhc = auth_fh(rqstp, &(argp->fh), &status, 
			CHK_WRITE | CHK_NOACCESS);
	if (fhc == NULL)
		return status;
	path = fhc->path;
	errno = 0;
	/* Stat the file first */
	if (lstat(path, &buf) < 0)
		return pdfs_errno();
	status = setattr(path, &argp->attributes, &buf, rqstp, SATTR_ALL);
	if (status != PDFS_OK)
		return status;
	return fhc_getattr(fhc, &(result.attr));
}

pdfsstat pdfs_root(argp, rqstp)
pdfs_fh *argp;
struct svc_req	*rqstp;
{
	pdfsstat  status;
	fhcache *fhc;
	status = fh_create(argp,export_root);
	if (status == (int ) PDFS_OK) 
	 	log_write("Succesfully intialised the root handle\n");
	fhc = auth_fh(rqstp, argp, &status, CHK_READ);
	if (fhc == NULL)
		return status;
	return fhc_getattr(fhc, &(result.attr));
}

/*
 * Look up a file by name.
 */
pdfsstat pdfs_lookup(struct diropargs *argp, struct svc_req *rqstp)
{
	struct diropres	*dp = &result.rslt.dirop_res;
	pdfs_fh		*fh = &argp->dir_fh;
	fhcache		*fhc;
	pdfsstat	status;
	struct stat 	sbuf;
	struct stat	*sbp = &sbuf;
	int		ispublic = 0;
	// authenticate the dir file handle
	if (!(fhc = auth_fh(rqstp, fh, &status, CHK_READ)))
		return status;
	status = fh_compose(argp, &(dp->fh), &sbp, -1, -1, ispublic);
	if (status != PDFS_OK)
		return status;
	fhc = auth_fh(rqstp, &(dp->fh), &status, CHK_READ);
	if (fhc == NULL)
		return status;
	status = fhc_getattr(fhc, &(result.attr));
	if (status == PDFS_OK)
	   log_write("PDFS_DEAMON \tnew_fh = %s\n", fh_pr(&(dp->fh)));
	return (status);
}

pdfsstat pdfs_read(argp, rqstp,rdbuff)
struct readargs *argp;
struct svc_req	*rqstp;
char *rdbuff;
{
	pdfsstat status;
	fhcache *fhc;
	struct readres *res = &result.rslt.read_res;
	int	fd, len = ntohl(argp->howmuch);

	fhc = auth_fh(rqstp, &(argp->fh), &status, CHK_READ | CHK_NOACCESS);
	if (fhc == NULL)
		return status;

	if ((fd = fh_fd(fhc, &status, O_RDONLY)) < 0) {
		return ((int) status);
	}
	errno = 0;
	(void) lseek(fd, (long) ntohl(argp->offset), SEEK_SET);
	if (!errno) {
		if (len  > PDFS_MAXDATA)
			len = PDFS_MAXDATA;
		res->count = read(fd, rdbuff, len);
		// now buffer holds the data
	}
	fd_inactive(fd);
	if (errno)
		return (pdfs_errno());
	return fhc_getattr(fhc, &(result.attr));
}

pdfsstat pdfs_write(argp, rqstp, buffer)
struct writeargs *argp;
struct svc_req	*rqstp;
char *buffer;
{
	pdfsstat status;
	fhcache *fhc;
	int fd;

	fhc = auth_fh(rqstp, &(argp->fh), &status, CHK_WRITE | CHK_NOACCESS);
	if (fhc == NULL)
		return status;

	if ((fd = fh_fd(fhc, &status, O_WRONLY)) < 0) {
		return ((int) status);
	}
	errno = 0;
	(void) lseek(fd, (long) ntohl(argp->offset), SEEK_SET);
	// assuming here that buffer holds the data
	if (errno == 0) {	/* We should never fail. */
	     if (write(fd, buffer,ntohl(argp->howmuch)) != ntohl(argp->howmuch)) 
		log_write("PDFS_DEAMON Write failure, errno is %d.\n", errno);
	}
	fd_inactive(fd);
	if (errno)
		return (pdfs_errno());
	return fhc_getattr(fhc, &(result.attr));
}

/* This used to be O_RDWR, but O_WRONLY is correct */

#define CREATE_OMODE O_WRONLY

pdfsstat pdfs_create(struct svc_req *rqstp, char *dir_name, char *f_name, sattr *attribs)
{
	pdfsstat status;
	char pathbuf[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN +1];
	int tmpfd, flags;
	struct stat sbuf;
	int exists;
	char *sp = pathbuf;
	char *fname = f_name;

	// authenticate the user to create a file in the directory here
	strcpy(sp,export_root); // first copy the local path
	sp += strlen(export_root);

	if (export_root[strlen(export_root)-1] != '/' )
		*sp++ = '/';
		
	strcpy(sp,dir_name);
	sp += strlen(dir_name);

	if (dir_name[strlen(dir_name)-1] != '/' )
		 *sp++ = '/';

	while (*fname) {		/* strcat(pathbuf, argp->where.name); */
		if (*fname == '/')
			return PDFSERR_INVAL;
		*sp++ = *fname++;
	}
	*sp = '\0';

	if (strlen(pathbuf) > PDFS_MAXPATHLEN)
		return PDFSERR_NAMETOOLONG;
	log_write("PDFS_CREATE : Full path is %s \n",pathbuf);

	errno = 0;
	exists = lstat(pathbuf, &sbuf) == 0;
		// exists will be one if the file already exists
		// in such a case we truncate the file
	flags = CREATE_OMODE | O_TRUNC;

	if (!exists) flags |= O_CREAT;

	/* creat() is equivalent to open(..., O_CREAT|O_TRUNC|O_WRONLY) */
	printf("The mode for creation is %d \n",ntohl(attribs->mode));
	tmpfd = path_open(pathbuf, flags, ntohl(attribs->mode));
	if (tmpfd < 0)
		goto FAILURE;
	fstat(tmpfd, &sbuf);
	if (!exists) {
		attribs->gid = -1;
		status = setattr(pathbuf, attribs, &sbuf, rqstp, SATTR_ALL & ~SATTR_SIZE);
	} else {
		status = setattr(pathbuf, attribs, &sbuf, rqstp, SATTR_SIZE);
	}
	if (status == PDFS_OK)
		return status;
FAILURE:
	log_write("PDFS_DEAMON \tcreate failed -- errno returned=%d.\n", errno);
	if (tmpfd != -1)
		close(tmpfd);
	return (errno? pdfs_errno(): status);
}

#undef CREATE_OMODE

pdfsstat pdfs_remove(struct svc_req *rqstp, char *dir_name, char *f_name)
{
	char pathbuf[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN +1];
	char *fname = f_name;
	char *sp = pathbuf;
	struct stat sbuf;
	int exists;

	// authenticate the user to create a file in the directory here
	strcpy(sp,export_root); // first copy the local path
	sp += strlen(export_root);

	if (export_root[strlen(export_root)-1] != '/' )
		*sp++ = '/';
		
	strcpy(sp,dir_name);
	sp += strlen(dir_name);

	if (dir_name[strlen(dir_name)-1] != '/' )
		 *sp++ = '/';

	while (*fname) {		/* strcat(pathbuf, argp->where.name); */
		if (*fname == '/')
			return PDFSERR_INVAL;
		*sp++ = *fname++;
	}
	*sp = '\0';

	if (strlen(pathbuf) > PDFS_MAXPATHLEN)
		return PDFSERR_NAMETOOLONG;

	log_write("PDFS_REMOVE \tfullpath='%s'\n", pathbuf);

	errno = 0;
	exists = lstat(pathbuf, &sbuf) == 0;
	if (!exists) 
		return pdfs_errno();

	/* Remove the file handle from our cache. */
	fh_remove(pathbuf);
	if (unlink(pathbuf) != 0)
		return (pdfs_errno());
	else
		return (PDFS_OK);
}

pdfsstat pdfs_rename(struct svc_req *rqstp,char *path_from, char *path_to)
{
	char pathbuf1[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN +1];
	char pathbuf2[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN +1];
	char *sp1 = pathbuf1;
	char *sp2 = pathbuf2;


	// authenticate the user to access the two files

	strcpy(sp1,export_root); // first copy the local path
	sp1 += strlen(export_root);

	if (export_root[strlen(export_root)-1] != '/' )
		*sp1++ = '/';
		
	strcpy(sp1,path_from);
	sp1 += strlen(path_from);
	*sp1 = '\0';


	strcpy(sp2,export_root); // first copy the local path
	sp2 += strlen(export_root);

	if (export_root[strlen(export_root)-1] != '/' )
		*sp2++ = '/';
		
	strcpy(sp2,path_to);
	sp2 += strlen(path_to);
	*sp2 = '\0';

	log_write("PDFS_RENAME \tpathfrom='%s' pathto='%s'\n", pathbuf1, pathbuf2);
	/* Remove any file handle from our cache. */
	fh_remove(pathbuf1);
	fh_remove(pathbuf2);
	if (rename(pathbuf1, pathbuf2) != 0)
		return (pdfs_errno());
	return (PDFS_OK);
}

pdfsstat pdfs_mkdir(struct svc_req *rqstp, char *dir_name, char *f_name, sattr *attribs )
{
	char pathbuf[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN +1];
	char *sp = pathbuf;
	char *fname = f_name;

	// authenticate the user to create a file in the directory here
	strcpy(sp,export_root); // first copy the local path
	sp += strlen(export_root);

	if (export_root[strlen(export_root)-1] != '/' )
		*sp++ = '/';
		
	strcpy(sp,dir_name);
	sp += strlen(dir_name);

	if (dir_name[strlen(dir_name)-1] != '/' )
		 *sp++ = '/';

	while (*fname) {		/* strcat(pathbuf, argp->where.name); */
		if (*fname == '/')
			return PDFSERR_INVAL;
		*sp++ = *fname++;
	}
	*sp = '\0';

	if (strlen(pathbuf) > PDFS_MAXPATHLEN)
		return PDFSERR_NAMETOOLONG;

	log_write("PDFS_MKDIR \tfullpath='%s'\n", pathbuf);

	if (mkdir(pathbuf, ntohl(attribs->mode)) != 0)
		return (pdfs_errno());
	return PDFS_OK;
}

pdfsstat pdfs_rmdir(struct svc_req *rqstp, char *dir_name, char *f_name)
{
	char pathbuf[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN +1];
	char *sp = pathbuf;
	char *fname = f_name;

	// authenticate the user here for write/delete on the directory and
	// the file

	strcpy(sp,export_root); // first copy the local path
	sp += strlen(export_root);

	if (export_root[strlen(export_root)-1] != '/' )
		*sp++ = '/';
		
	strcpy(sp,dir_name);
	sp += strlen(dir_name);

	if (dir_name[strlen(dir_name)-1] != '/' )
		 *sp++ = '/';

	while (*fname) {		/* strcat(pathbuf, argp->where.name); */
		if (*fname == '/')
			return PDFSERR_INVAL;
		*sp++ = *fname++;
	}
	*sp = '\0';

	if (strlen(pathbuf) > PDFS_MAXPATHLEN)
		return PDFSERR_NAMETOOLONG;

	log_write("PDFS_RMDIR \tfullpath='%s'\n", pathbuf);

	/* Remove that file handle from our cache. */
	fh_remove(pathbuf);
	if (rmdir(pathbuf) != 0)
		return (pdfs_errno());
	return (PDFS_OK);
}

pdfsstat pdfs_readdir(argp, rqstp, buffer, nbytes)
struct readdirargs *argp;
struct svc_req	*rqstp;
char **buffer;
int *nbytes;
{
	struct readdirres *res = &result.rslt.readdir_res;
	struct dirent **namelist;
	struct stat sbuf;
	fhcache *h;
	pdfsstat status;
	char *buf_ptr;
	int i;
	*nbytes = 0;
	h = auth_fh(rqstp, &(argp->dir), &status, CHK_READ);
	if (h == NULL)
		return status;
	if (lstat(h->path, &sbuf) < 0 || !(S_ISDIR(sbuf.st_mode)))
		return (PDFSERR_NOTDIR);
	res->count = scandir(h->path,&namelist,0,alphasort);
 	buf_ptr = *buffer = (char *)malloc(res->count*PDFS_MAXNAMELEN);
	for(i = 0; i < res->count; i++) {
		sprintf(buf_ptr, "%s *",namelist[i]->d_name);
		buf_ptr += strlen(namelist[i]->d_name) + 2;
		*nbytes += strlen(namelist[i]->d_name) + 2;
	}
	return fhc_getattr(h, &(result.attr));
} // end of readdir

/*
 * Only reports free space correctly for the filesystem that the
 * mount point is on.  Actually it will work fine for any file
 * handle (e.g. sub mounts) but the NFS spec calls for root_fh
 * to be used by the client when calling this.
 */
pdfsstat pdfs_statfs(argp, rqstp)
pdfs_fh *argp;
struct svc_req	*rqstp;
{
	pdfsstat status;
	fhcache *fhc;
	char *path;
	// struct fs_usage fs;

	fhc = auth_fh(rqstp, argp, &status, CHK_READ | CHK_NOACCESS);
	if (fhc == NULL)
		return status;
	path = fhc->path;
/*
	if (get_fs_usage(path, NULL, &fs) < 0)
		return (pdfs_errno());
	result.statfsres.status = PDFS_OK;
	result.statfsres.statfsres_u.reply.tsize = 8*1024;
	result.statfsres.statfsres_u.reply.bsize = 512;
	result.statfsres.statfsres_u.reply.blocks = fs.fsu_blocks;
	result.statfsres.statfsres_u.reply.bfree = fs.fsu_bfree;
	result.statfsres.statfsres_u.reply.bavail = fs.fsu_bavail;
*/
	return (PDFS_OK);
}

void terminate(int sig)
{
	
	printf("Terminating the PDFS deamon \n");
	if (sig != SIGTERM) {
			printf("Something terribly wrong \n");
		} 
	// send2CSS();
	printf("Send terminate message to the communicatin site also \n");
	cleanup(); // local data structures
	exit(1);
}

void sig_initialise()
{
	struct sigaction term_sigact;
	term_sigact.sa_handler = terminate;
	sigemptyset(&term_sigact.sa_mask);
	term_sigact.sa_flags = SA_SIGINFO;
	sigaction(SIGTERM,&term_sigact,0);
	// intialised the signal handler
}
void cleanup()
{
	printf("Cleaning up the data structures \n");
}

