/* Author: Rukmangathan Balakrishnan 
   pdfs_deamon.c
   Deamon for PDFS storage site
*/
#include<stdio.h>
#include<unistd.h>
#include<signal.h>
#include<fcntl.h>
#include<stdlib.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/socket.h>
#include<arpa/inet.h>
#include<netinet/in.h>

#include "pdfs.h"
#include "pdfs_deamon.h"
#include "defns.h"
#include "msg_format.h"
#include "cs2ss_msgfmt.h"


#define MAX_FDS	256

// external variables
extern char export_root[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN+1];
extern struct sockaddr_in synchsite;	// synchronisation site;
extern struct op_result result;

//external functions
extern int process_req(char *, int , struct sockaddr_in *, 
			int, int );
extern void log_open();
extern void log_close();
extern void log_write();
extern void sig_initialise();
extern void fh_init();
extern int process_synch(int , cs2ss_msg *);
extern int process_update( int );


// local function declarations
void process_ready(int );
int my_recv(int , char *);

//global variables
int serv_sock;
int synch_sock;
int update_sock;
fd_set ready_fds;
pdfs_fh root_fh;

int main(argc, argv)
int argc;
char *argv[];
{
	struct sockaddr_in serveraddr;
	char s_site[16];
	char fname[20];
	struct stat statbuf;

	memset(&synchsite,0,sizeof(synchsite));
        printf("Setting the logging on \n");
	printf("Enter the log file to be created :");
	scanf("%s",fname);
	printf("Got the filename %s\n",fname);
	log_open(argv[0],fname);
        printf("Setting the root of exported fs \n");
	printf("Enter the root of the file name exported :");
	scanf("%s",export_root);
	if (lstat(export_root,&statbuf) < 0)
		{
			printf("The root doesnt exist \n");
			return 0; }
	printf("got the root fs %s\n",export_root);
	printf("Setting the synchronisation site \n");
	printf("Enter the site address in dotted-quad :");
	scanf("%s",s_site);
	printf("Obtained the synch site addr %s \n",s_site);
	synchsite.sin_addr.s_addr = inet_addr(s_site);
	printf("Obtained the syncsite addr %s\n",inet_ntoa(synchsite.sin_addr));
//	sig_initialise(); // intialise the sighandler
	fh_init();	/* Initialize the FH module.  */
	log_write("Initialised the file handle cache \n");


   if((serv_sock = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP))<0) {
		printf("Server socket cannot be created \n");
		exit(1); }

   if((synch_sock = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP))<0) {
		printf("Synch socket cannot be created \n");
		exit(1); }

   if((update_sock = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP))<0) {
		printf("Update socket cannot be created \n");
		exit(1); }

   memset(&serveraddr,0,sizeof(serveraddr));
   serveraddr.sin_addr.s_addr = htonl(INADDR_ANY);
   serveraddr.sin_port = htons(SS_DEAMON_PORT);
   serveraddr.sin_family = AF_INET;

   if (bind(serv_sock,(struct sockaddr *)&serveraddr,sizeof(serveraddr))) {
		printf("Server socket cannot be binded \n");
		exit(1); }

   listen(serv_sock,5); // listen for clients to send requests.


   memset(&serveraddr,0,sizeof(serveraddr));
   serveraddr.sin_addr.s_addr = htonl(INADDR_ANY);
   serveraddr.sin_port = htons(SS_UPDATE_PORT);
   serveraddr.sin_family = AF_INET;

   if (bind(update_sock,(struct sockaddr *)&serveraddr,sizeof(serveraddr))) {
		printf("Update socket cannot be binded \n");
		exit(1); }
   
   listen(update_sock,5); // listen for updating storage sites requests.


   memset(&serveraddr,0,sizeof(serveraddr));
   serveraddr.sin_addr.s_addr = inet_addr(s_site);
   serveraddr.sin_port = htons(CS_SYNCH_PORT);
   serveraddr.sin_family = AF_INET;

   if (connect(synch_sock,(struct sockaddr *)&serveraddr,
			sizeof(serveraddr)) < 0) {
                printf("unable to contact Synchornistion site \n");
                exit(1); }

   memset(&ready_fds,0,sizeof(ready_fds));
   FD_ZERO(&ready_fds);

   FD_SET(serv_sock,&ready_fds);
   FD_SET(synch_sock,&ready_fds);
   FD_SET(update_sock,&ready_fds);


 while(1) { // run for ever here

	// wait on the two sockets to become ready for input
        // get that socket and based on the socket
        // do the apropriate processing

	int retval=0,i,served;
	fd_set temp_fds;

REPEAT:	memset(&temp_fds,0,sizeof(fd_set));
	FD_ZERO(&temp_fds);
	memcpy(&temp_fds,&ready_fds,sizeof(fd_set));
	retval = select(MAX_FDS,&temp_fds, NULL,NULL,NULL);
	fflush(stdout);
	if (retval == -1) {
		if (errno == EINTR) goto REPEAT;
               log_write("Some problem with select\n");
               perror("Select problem");
               // exit(1); continue ;
	}
	served = 0;
	printf("Going to serve the request \n");
	for (i=0; i < MAX_FDS; i++) {
		if (FD_ISSET(i,&temp_fds)){
                         process_ready(i);
                         served++; }
                if (served == retval) break;
	} // end of for
    } // end of while
   log_close();
return 1;
} // end of main


void process_ready(int sockid)
{
	// process socket that is ready

	if (sockid == synch_sock) {
		// some message from the syynchronisation server 
		cs2ss_msg pkt;
		memset(&pkt,0,sizeof(pkt));
		printf("Received a message from the synch server\n");
		// time being assuming only same sizeof packets
		if (recv(sockid,&pkt,sizeof(pkt),MSG_WAITALL) < sizeof(pkt))
		{
			log_write("Received an wrong size pkt from
			   synchronisation server \n");
			close(sockid); // time being we close the 
			FD_CLR(sockid,&ready_fds);
			// the connection with the synchronisation servera
			exit (1);
			return ; 
		}
		process_synch(sockid,&pkt);	
		return ;
	} // end of processing synch_sock

	if (sockid == update_sock) {
		// update requests from the storage site
		log_write("Update request has arrived \n");
		process_update(update_sock);
		log_write("Finished processing the update request \n");
		return ;
	}

	if (sockid == serv_sock) {
		char buff[MAX_PKT_SIZE];
		int newsockfd,nbytes;
                struct sockaddr_in clntaddr;
                int addrlen = sizeof(clntaddr);

		printf("Received a connect request from a client\n");
                newsockfd = accept(serv_sock,(struct sockaddr *)&clntaddr,
                                &addrlen);
                log_write("Site %s has sent a request \n",
                                inet_ntoa(clntaddr.sin_addr));
		nbytes = my_recv(newsockfd,buff);
        	//printf("No. of bytes received is %d\n",nbytes);
        	process_req(buff, nbytes, &clntaddr, addrlen, newsockfd);
	} // end of processing serv_sock
} // end of process_ready


#define ONE_BYTE 1

int my_recv(int socketid, char *buff) {
   int nbytes = 0;
   char c;
   printf("socket id is %d \n",socketid);
   while (recv(socketid,&c,ONE_BYTE,0)) {
            *(buff+nbytes) = c;
            nbytes++;
   }
   return nbytes;
} // end of my_recv
