/* Modified by Rukmangathan Balakrishnan 
   for PDFS 
*/


/* attr_funcs	This module handles the pdfs attributes.
 *
 * Authors:	Mark A. Shand, May 1988
 *		Donald J. Becker, <becker@super.org>
 *		Rick Sladkey, <jrs@world.std.com>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Olaf Kirch, <okir@monad.swb.de>
 *
 *		Copyright 1988 Mark A. Shand
 *		This software maybe be used for any purpose provided
 *		the above copyright notice is retained.  It is supplied
 *		as is, with no warranty expressed or implied.

 *		Modified By: Rukmangathan Balakrishnan for
 *		PDFS
 *
 */

#include <unistd.h>
#include <utime.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <netinet/in.h>


#include "pdfs_deamon.h"

#define MIN(A,B) (A>B)?B:A
/*
 * Set file attributes based on file handle
 */
pdfsstat fh_setattr(fh, attr, s, rqstp, flags)
pdfs_fh		*fh;
sattr		*attr;
struct stat	*s;
struct svc_req	*rqstp;
int		flags;
{
	char *path;
	pdfsstat status;
	if ((path = fh_path(fh, &status)) == NULL) {
		log_write("ATTR: setattr failed: No such file.\n");
		return (PDFSERR_STALE);
	}
	return setattr(path, attr, s, rqstp, flags);
}

/*
 * Set file attributes given the path. The flags argument
 * determines if we have to stat the file or if the stat buf
 * passed in s contains valid data.
 * As we go along and modify the file attributes, we update the
 * fields of this stat structure.
 */

pdfsstat setattr(path, attr, s, rqstp, flags)
char		*path;
sattr		*attr;
struct stat	*s;
struct svc_req	*rqstp;
int		flags;
{
	struct stat	sbuf;
	if (s == NULL) {
		s = &sbuf;
		flags |= SATTR_STAT;
	}

	if ((flags & SATTR_STAT) && lstat(path, (s = &sbuf)) < 0) {
		log_write("ATTR: setattr: couldn't stat %s! errno=%d\n",
				path, errno);
		return pdfs_errno();
	}
	if (flags & SATTR_SIZE) {
		unsigned int size = ntohl(attr->size);
		if (S_ISREG(s->st_mode) && size != -1) {
			if (truncate(path, size) < 0)
				goto failure;
			s->st_size = size;
		}
	}
	if (flags & SATTR_UTIMES) {
		struct utimbuf s_time;
		s_time.actime = ntohl(attr->atime);
		s_time.modtime = ntohl(attr->mtime);
		if (utime(path,&s_time))
			goto failure;
	}
	if (flags & SATTR_CHMOD) {
		unsigned int mode = ntohl(attr->mode);
		printf("In setattr %d \n",mode);
		if (mode != -1 && mode != 0xFFFF /* ultrix bug */
		 && (mode & 07777) != (s->st_mode & 07777)) {
			if (chmod(path, mode) < 0)
				goto failure;
			s->st_mode = (s->st_mode & ~07777) | (mode & 07777);
		}
	}

	if (flags & SATTR_CHOWN) {
/*
		uid_t		uid = attr->uid;
		gid_t		gid = attr->gid;

		if (uid != (uid_t)-1)
			uid = luid(uid, pdfsmount, rqstp);
		if (gid != (gid_t)-1)
			gid = lgid(gid, pdfsmount, rqstp);

		if ((uid != (uid_t)-1 && uid != s->st_uid)
		 || (gid != (gid_t)-1 && gid != s->st_gid)) {
			if (lchown(path, uid, gid) < 0)
				goto failure;
			if (uid != (uid_t)-1) s->st_uid = uid;
			if (gid != (gid_t)-1) s->st_gid = gid;
		}
*/
	log_write("ATTR: asked to do set owner \n");
	}
	return (PDFS_OK);
failure:
	return pdfs_errno();
}

/*
 * Get file attributes based on file handle
 */
pdfsstat fh_getattr(fh, attr)
pdfs_fh		*fh;
fattr		*attr;
{
	fhcache *fhc;
	if ((fhc = fh_find((svc_fh*)fh, FHFIND_FEXISTS)) == NULL) {
		log_write("ATTR :getattr: failed! No such file.\n");
		return (PDFSERR_STALE);
	}
	return fhc_getattr(fhc, attr);
}

/*
 * Get file attributes given the path.
 */

pdfsstat fhc_getattr(fhc, attr)
fhcache		*fhc;
fattr		*attr;
{
	struct stat sbuf;
	struct stat *s = &sbuf;
	if (lstat(fhc->path, s) != 0) {
		log_write("ATTR: getattr(%s): failed!  errno=%d\n", 
			fhc->path, errno);
		return (pdfs_errno());
	}
	attr->ftype = s->st_mode;
	attr->mode = s->st_mode;
	attr->nlink = s->st_nlink;
	attr->uid = s->st_uid;
	attr->gid = s->st_gid;

	/* Some applications need the exact symlink size */
#if defined(S_ISLNK)
	if (S_ISLNK(s->st_mode))
		attr->size = MIN(s->st_size, PDFS_MAXPATHLEN);
	else
#endif
	attr->size = s->st_size;
	attr->blocksize = s->st_blksize;
	attr->blocks = s->st_blocks;
	attr->atime = s->st_atime;
	attr->mtime = s->st_mtime;
	attr->ctime = s->st_ctime;
	return (PDFS_OK);
}
