/* Author Balakrishnan Rukmangathan 
   pdfs.h contains the definitions required for PDFS
*/

#ifndef PDFS_H
#define PDFS_H

#include <errno.h>

typedef enum pdfs_stat {
   	 PDFS_OK	 =         0,
         PDFSERR_PERM  =    EPERM,
         PDFSERR_NOENT =    ENOENT,
         PDFSERR_IO =       EIO,
         PDFSERR_NXIO =     ENXIO,
         PDFSERR_ACCES =    EACCES,
         PDFSERR_EXIST =    EEXIST,
         PDFSERR_NODEV =    ENODEV,
         PDFSERR_NOTDIR =   ENOTDIR,
         PDFSERR_ISDIR =    EISDIR,
         PDFSERR_INVAL =    EINVAL,
         PDFSERR_FBIG =     EFBIG,
         PDFSERR_NOSPC =    ENOSPC,
         PDFSERR_ROFS =      EROFS,
         PDFSERR_NAMETOOLONG = ENAMETOOLONG,
         PDFSERR_NOTEMPTY =    ENOTEMPTY,
	 PDFSERR_STALE	= ESTALE,
	 PDFSERR_WFLUSH	= EIO
} pdfsstat;

#define PDFS_MAXPATHLEN   1024	// maximum length of the path
#define PDFS_MAXNAMELEN   255   // maximum length of a file name

#define PDFS_FHSIZE       32	// size of the file handle

#define PDFS_MAXDATA	1024	// highest data size 

typedef unsigned long   psi_t;

/*
 * Hashed search path to this file.
 * path is: hash_path[1] ... hash_path[hash_path[0]]
 *
 * hash_path[hash_path[0]+1] ... hash_path[HP_LEN-1] == 0
 */
#define HP_LEN          (PDFS_FHSIZE - sizeof(psi_t))

struct pdfs_fh {
        psi_t           psi;
        unsigned char   hash_path[HP_LEN];
};

typedef struct pdfs_fh pdfs_fh;

#define ROOT_UID	0 // super user id

typedef enum open_stat {
        F_READ = 0,     /* file read */
        F_WRITE,        /* file write */
        F_RDWR
} open_stat;


#endif
