

// Header file for packet format and its manipulation.

#ifndef MSG_FORMAT_H
#define MSG_FORMAT_H

#include <sys/types.h>
#include <sys/stat.h>
#include "defns.h"

#define MAX_FILENAME_LEN  120

#define MAX_DATA_LEN    512

/* structure for the attributes of the file */

typedef struct attribs {
	uid_t f_ownerid; 	// id of the user
	gid_t f_grpid;		// group id of the user 
	mode_t f_mode; 		// mode of the file
	time_t f_acc_time; 	// last access time 
	time_t f_mod_time; 	// last modified time 
	} ATTRIBS;

/* structure for the file handle */

typedef struct f_hanlde {
		char filename[MAX_FILENAME_LEN]; // file name, max is 20.
		// char filename[]; // file name, max is 20.
		u_long file_id; // unique id of the file, Has meaning only
				// in the storage site and sync site
		u_long file_offset; // offset within the file
		ATTRIBS attr; // attributes of the file
	} FILE_HANDLE;

typedef struct header {
		u_short msg_id;	 // to associate reply with request
		u_short msg_len; // holds message len and version..
		u_short op_code; // operation code 
		FILE_HANDLE fh;
}HEADER;

#define MAX_PKT_SIZE	sizeof(HEADER)+512

// function prototypes

HEADER *frame_packet(u_short, u_short, FILE_HANDLE *, u_short);
FILE_HANDLE *frame_filehandle(char *, ATTRIBS *, u_long, u_long);
ATTRIBS *frame_attribs(uid_t, gid_t, mode_t, time_t, time_t);
void print_header(HEADER *);
#endif
