

// Header file for packet format and its manipulation.

#ifndef MSG_FORMAT_H
#define MSG_FORMAT_H

#include <sys/types.h>
#include <sys/stat.h>
#include "defns.h"
#include "args.h"

#define MAX_FILENAME_LEN  120

#define MAX_DATA_LEN    1024

/* structure for the header */

typedef struct header {
		u_short msg_id;	 // to associate reply with request
		u_short msg_len; // holds message len and version..
		u_short op_code; // operation code 
		struct svc_req req_info; // information about the 
					// requesting user
		generic_op_args  op_args; //generic operation args
}HEADER;

#define MAX_PKT_SIZE	sizeof(HEADER)+MAX_DATA_LEN

// some abbreviations for easy understanding.

#define args_create	op_args.cr_args
#define args_readdir	op_args.readdir_args
#define args_dirop	op_args.dirop_args
#define args_read	op_args.read_args
#define args_write	op_args.write_args
#define args_rename	op_args.rname_args
#define args_getattr	op_args.getattr_args
// #define rslt		op_args.result

// function prototypes

HEADER *frame_packet(u_short, u_short, generic_op_args *, u_short);
fattr *frame_fattr(uid_t, gid_t, mode_t, time_t, time_t, time_t, 
		u_short, u_int, u_int, u_int, u_int );

void print_header(HEADER *);
void print_fattr(fattr *);
void print_args(HEADER *,int );

void frame_setattrargs(HEADER *, pdfs_fh *, sattr *);

void frame_readdir(HEADER *, pdfs_fh *, u_long);
void frame_readdirres(HEADER *,u_long, u_long );

void frame_diropargs(HEADER *, pdfs_fh *, char *);
void frame_diropres(HEADER *,pdfs_fh *);

void frame_read(HEADER *, pdfs_fh *, u_long , u_long );
void frame_readres(HEADER *, u_long );

void frame_write(HEADER *, pdfs_fh *, u_long , u_long );
void frame_rename(HEADER *, pdfs_fh *,char *, pdfs_fh *, char *);

void frame_result(HEADER * ,pdfsstat , fattr *);

void frame_createargs(HEADER *, pdfs_fh *, char *, sattr *);
void frame_createres(HEADER *, pdfs_fh *);

#endif
