/*
	Author: Balakrishnan Rukmangathan
	cs_ss_msg_fmt.h : message format for messages exchanged
	between the synchronisation site and the storage site
*/

#ifndef CS2SS_MSGFMT_H
#define CS2SS_MSGFMT_H

#include "pdfs.h"
#include "args.h"
#include "common.h"

typedef struct updateargs {
	// args needed for file update
	char 		pref_srvr[16];	 // pref server address.
	char 		fname[PDFS_MAXPATHLEN+PDFS_MAXNAMELEN+1];
} upargs;

typedef struct mntreply {
	pdfs_fh 	root_fh; 	// root file handle
	u_short 	load;		// load in the file system
} mntreply;
	
typedef struct cs_ss_msg{
	u_short 	msg_code; // message code of the packet
	u_short 	cookie;   // cookie to associate request & reply
	struct svc_req user_info;
	union {
		mntreply mnt_reply;
		upargs	up_args;
	 	crargs cr_args;
		renargs ren_args;
		pdfsstat 	status;
	}  args;
} cs2ss_msg;

#endif
