/* Author: Balakrishnan Rukmangathan
   ss_funcs.c : functions used by synchronisation site
		to communicate with the storage site
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/time.h>


#include "defns.h"
#include "pdfs.h"
#include "sites_list.h"
#include "registry.h"
#include "cs2ss_msgfmt.h"
#include "cs2us_msgfmt.h"

#define MAX_FDS 	256
#define TIMEOUT		5

static u_short cookie =  1;

extern s_list *head;
extern void log_write(char *, ...);
extern char *print_fh(pdfs_fh *);

int select_site(pdfs_fh *root_fh)
{
        // poll the registered storage sites and select a
        // storage site to serve this client

	// return the socket corresponding to the storage site
	// or -1 if error

	s_list *temp = head;
	fd_set poll_fds;
	fd_set temp_fds;
	cs2ss_msg pkt;
	int no_ready = 0;
	int served = 0;
	struct timeval timeout;
	u_short metric = 65534;
	int selected_sock;
	int i;
	int sent_cnt=0;

	memset(&pkt,0,sizeof(pkt));
	
	// check out the life time of this field
	pkt.msg_code = htons(MSG_CS2SS_POLL);
	pkt.cookie = htons(cookie);
	
	FD_ZERO(&poll_fds);

	// send poll reaquest to all the registered storage sites	
	while(temp != NULL) {
		if (send(temp->sockfd,&pkt,sizeof(pkt),0) < sizeof(pkt))
			{ printf("Site -%s- is not listening \n",
					temp->ss_addr); 
			// fault tolerant issue
			temp = temp->next;
			continue ;
		}
		sent_cnt++;
		FD_SET(temp->sockfd,&poll_fds);
		temp = temp->next;
	}

	// timeout.tv_sec = TIMEOUT;
	timeout.tv_sec = TIMEOUT;
	timeout.tv_usec = 0;
	
	// now poll_fds has the set of sockets to which a poll message
	// has been sent

	// get reply from everyone to whom it was sent..
	while (no_ready < sent_cnt ) {
		FD_ZERO(&temp_fds);
		memcpy(&temp_fds, &poll_fds, sizeof(temp_fds));
		no_ready = select(MAX_FDS, &temp_fds, NULL, NULL,&timeout);
	}

	printf("Received from %d sites \n",no_ready);
	memcpy(&poll_fds,&temp_fds,sizeof(temp_fds));
	
	
	if (no_ready < 0) {
		log_write("Some select problem while polling \n");
		perror("Poll select proble \n");
		return -1;
	}
	if (no_ready == 0) {
		log_write("Timeout occured all ss are busy\n");
		return -1;
	}
	served = 0;
	
        printf("Going to select a storage site \n");

	// select a storage site with least metric

	selected_sock = 0;
        for (i=3; i < MAX_FDS; i++) {
             if (FD_ISSET(i,&poll_fds)){
		   cs2ss_msg pkt;
		   memset(&pkt,0,sizeof(pkt));
                   if (recv(i,&pkt,sizeof(pkt),MSG_WAITALL) < sizeof(pkt)) {
			printf("Received an illegal message \n"); 
			// fault tolerant issue
			continue ;
		   }
		   if ( (ntohs(pkt.args.mnt_reply.load) < metric) && 
			(ntohs(pkt.cookie) == cookie) ) {
				metric = ntohs(pkt.args.mnt_reply.load);
				memset(root_fh,0,PDFS_FHSIZE);
				memcpy(root_fh,&(pkt.args.mnt_reply.root_fh),
					PDFS_FHSIZE);
				log_write("One root fh is %s\n",
				    print_fh(&(pkt.args.mnt_reply.root_fh)));
				log_write("After copying One root fh is %s\n",
					print_fh(root_fh));
				selected_sock = i; 
		   } // end of load/cookie
		   // else of cookie/load
                   served++; 
		} // it should match 
             if (served == no_ready ) break;
        } // finished reading from all
	cookie++;
	if (selected_sock == 0) return -1;
	log_write("The selected root fh is %s\n",print_fh(root_fh));
	return selected_sock;
} // end of polling

pdfsstat send_to_all(cs2ss_msg *pkt) 
{
	// send to all the registered storage sites and 
	// get the reply
	
	s_list *temp = head;
	fd_set poll_fds;
	fd_set temp_fds;
	int no_ready = 0;
	int served = 0;
	struct timeval timeout;
	int i,ok_count =0, err_count = 0;
	int error = -1;
	int sent_cnt=0;
	pkt->cookie = htons(cookie);
	
	FD_ZERO(&poll_fds);

	// send message to all the registered storage sites	
	while(temp != NULL) {
		if(send(temp->sockfd,pkt,sizeof(cs2ss_msg),0)<sizeof(cs2ss_msg))
		{ 
			printf("Site -%s- is not listening \n", temp->ss_addr);
			// fault tolerant issue. 
			// timestamp the site to be down the list and 
			temp = temp->next;
			continue ;
		}
		sent_cnt++;
		FD_SET(temp->sockfd,&poll_fds);
		temp = temp->next;
	}

	printf("Sent to %d sites \n",sent_cnt);

	// timeout.tv_sec = TIMEOUT;
	timeout.tv_sec = TIMEOUT;
	timeout.tv_usec = 0;
	
	/*  now poll_fds has the set of sockets to which a message
	 has been sent. for the time being we consider all the storage
	 sites will receive and reply back. fault tolerance is not
	 considered. and also assume that the timeout value is 
	 sufficient enough for the storage sites to reply back
	*/		
	// get reply from everyone to whom it was sent..
	while (no_ready < sent_cnt ) {
		FD_ZERO(&temp_fds);
		memcpy(&temp_fds, &poll_fds, sizeof(temp_fds));
		no_ready = select(MAX_FDS, &temp_fds, NULL, NULL,&timeout);
	}

	printf("Received from %d sites \n",no_ready);
	memcpy(&poll_fds,&temp_fds,sizeof(temp_fds));
	
	if (no_ready < 0) {
		log_write("Some select problem while polling \n");
		perror("Poll select proble \n");
		return -1;
	}
	if (no_ready == 0) {
		log_write("Timeout occured all ss are busy\n");
		return -1;
	}

	printf("Number of ready socket is %d \n",no_ready);
	served = 0;
	
        for (i=3; i < MAX_FDS; i++) {
             if (FD_ISSET(i,&poll_fds)){
		   cs2ss_msg tpkt;
		   memset(&tpkt,0,sizeof(tpkt));
                   if (recv(i,&tpkt,sizeof(tpkt),MSG_WAITALL) < 
				sizeof(tpkt)) {
			 printf("A storage site has sent a illegal size 
				of message \n");
			// fault tolerant issue
			continue ;
		    }
		   if (ntohs(tpkt.cookie) == cookie) 
		      if (ntohs(tpkt.args.status) == PDFS_OK)  
				ok_count++ ;
		      else err_count ++;
		   else printf("Cookies doesnot match %d %d \n",ntohs(tpkt.cookie),cookie);
                   served++; 
		   error = ntohs(tpkt.args.status);
	     }
             if (served == no_ready ) break;
        }
	/* currently since not considering the fault tolerant issues
	   either all say OK or all say error
	*/
	cookie++;
	printf("Ok count is %d \n", ok_count);
	printf("err count is %d \n",err_count);
	if (ok_count) return PDFS_OK;
	else return error; 
} // end of send_to_all
 
void csd_create(cs2us_msg us_pkt, int sock_id)
{
	cs2ss_msg ss_pkt;
	pdfsstat status;
	memset(&ss_pkt, 0, sizeof(ss_pkt));
	printf("csd: Sending a create file request \n");
	ss_pkt.msg_code = htons(MSG_CS2SS_CREATE);
	memcpy(&ss_pkt.user_info,&us_pkt.user_info, sizeof(ss_pkt.user_info));
	strcpy(ss_pkt.args.cr_args.dir_name,us_pkt.args.cr_args.dir_name);
	strcpy(ss_pkt.args.cr_args.f_name,us_pkt.args.cr_args.f_name);
	memcpy(&ss_pkt.args.cr_args.f_attribs,&us_pkt.args.cr_args.f_attribs,
				sizeof(sattr));
	printf("The attributes are %d",ntohl(ss_pkt.args.cr_args.f_attribs.mode));
	// copy the attributes here
	status = send_to_all(&ss_pkt);
	if (status == PDFS_OK) printf("csd: create file successfull \n");
	us_pkt.args.status = htons(status);
	us_pkt.msg_code= htons(MSG_CS2US_CREATE);
	if (send(sock_id, &us_pkt, sizeof(us_pkt), 0) < sizeof(us_pkt)) 
		printf("csd: create file cannot reply back\n"); 
	return ;
}


void csd_createdir(cs2us_msg us_pkt, int sock_id)
{
	cs2ss_msg ss_pkt;
	pdfsstat status;
	memset(&ss_pkt, 0, sizeof(ss_pkt));
	printf("csd: Sending a create dir request \n");
	ss_pkt.msg_code = htons(MSG_CS2SS_CREATEDIR);
	memcpy(&ss_pkt.user_info,&us_pkt.user_info, sizeof(ss_pkt.user_info));
	strcpy(ss_pkt.args.cr_args.dir_name,us_pkt.args.cr_args.dir_name);
	strcpy(ss_pkt.args.cr_args.f_name,us_pkt.args.cr_args.f_name);
	memcpy(&ss_pkt.args.cr_args.f_attribs,&us_pkt.args.cr_args.f_attribs,
				sizeof(sattr));
	status = send_to_all(&ss_pkt);
	if (status == PDFS_OK) printf("csd: create directory successfull \n");
	us_pkt.args.status = htons(status);
	us_pkt.msg_code= htons(MSG_CS2US_CREATEDIR);
	if (send(sock_id, &us_pkt, sizeof(us_pkt), 0) < sizeof(us_pkt)) 
		printf("csd: create directory cannot reply back\n"); 
	return ;
}

void csd_delete(cs2us_msg us_pkt, int sock_id)
{
	cs2ss_msg ss_pkt;
	pdfsstat status;
	memset(&ss_pkt, 0, sizeof(ss_pkt));
	printf("csd: Sending a delete file request \n");
	ss_pkt.msg_code = htons(MSG_CS2SS_DELETE);
	memcpy(&ss_pkt.user_info,&us_pkt.user_info, sizeof(ss_pkt.user_info));
	strcpy(ss_pkt.args.cr_args.dir_name,us_pkt.args.cr_args.dir_name);
	strcpy(ss_pkt.args.cr_args.f_name,us_pkt.args.cr_args.f_name);
	memcpy(&ss_pkt.args.cr_args.f_attribs,&us_pkt.args.cr_args.f_attribs,
				sizeof(sattr));
	status = send_to_all(&ss_pkt);
	if (status == PDFS_OK) printf("csd: delete file successfull \n");
	us_pkt.args.status = htons(status);
	us_pkt.msg_code= htons(MSG_CS2US_DELETE);
	if (send(sock_id, &us_pkt, sizeof(us_pkt), 0) < sizeof(us_pkt)) 
		printf("csd: delete file cannot reply back\n"); 
	return ;
}


void csd_deletedir(cs2us_msg us_pkt, int sock_id)
{
	cs2ss_msg ss_pkt;
	pdfsstat status;
	memset(&ss_pkt, 0, sizeof(ss_pkt));
	printf("csd: Sending a delete dir request \n");
	ss_pkt.msg_code = htons(MSG_CS2SS_DELETEDIR);
	memcpy(&ss_pkt.user_info,&us_pkt.user_info, sizeof(ss_pkt.user_info));
	strcpy(ss_pkt.args.cr_args.dir_name,us_pkt.args.cr_args.dir_name);
	strcpy(ss_pkt.args.cr_args.f_name,us_pkt.args.cr_args.f_name);
	memcpy(&ss_pkt.args.cr_args.f_attribs,&us_pkt.args.cr_args.f_attribs,
				sizeof(sattr));
	status = send_to_all(&ss_pkt);
	if (status == PDFS_OK) printf("csd: delete directory successfull \n");
	us_pkt.args.status = htons(status);
	us_pkt.msg_code= htons(MSG_CS2US_DELETEDIR);
	if (send(sock_id, &us_pkt, sizeof(us_pkt), 0) < sizeof(us_pkt))
		printf("csd: delete directory cannot reply back\n"); 
	return ;
}


void csd_rename(cs2us_msg us_pkt, int sock_id)
{
	cs2ss_msg ss_pkt;
	pdfsstat status;
	memset(&ss_pkt, 0, sizeof(ss_pkt));
	printf("csd: Sending a rename request \n");
	ss_pkt.msg_code = htons(MSG_CS2SS_RENAMEDIR);
	memcpy(&ss_pkt.user_info,&us_pkt.user_info, sizeof(ss_pkt.user_info));
	strcpy(ss_pkt.args.ren_args.from,us_pkt.args.ren_args.from);
	strcpy(ss_pkt.args.ren_args.to,us_pkt.args.ren_args.to);
	status = send_to_all(&ss_pkt);
	if (status == PDFS_OK) printf("csd: rename successfull \n");
	us_pkt.args.status = htons(status);
	us_pkt.msg_code= htons(MSG_CS2US_RENAME);
	if (send(sock_id, &us_pkt, sizeof(us_pkt), 0) < sizeof(us_pkt)) 
		printf("csd: rename cannot reply back\n"); 
	return ;
}

void send_update_to_all(reg_entry *regentry)
{
	// send update message to all the storage sites	
	// except 'exceptfd'. because he is the primary server

	s_list *temp = head;
	cs2ss_msg pkt;

	memset(&pkt,0,sizeof(pkt));
	
	// check out the life time of this field
	pkt.msg_code = htons(MSG_CS2SS_UPDATE);
	pkt.cookie = htons(cookie);
	cookie++;
	strcpy(pkt.args.up_args.pref_srvr,regentry->primary_server);
	strcpy(pkt.args.up_args.fname,regentry->fname);
	
	// send update request to all the registered storage sites	
	while(temp != NULL) {
		if (strcmp(temp->ss_addr, regentry->primary_server) ) 
		   if (send(temp->sockfd,&pkt,sizeof(pkt),0) < sizeof(pkt))
			{ 
			   printf("Site -%s- not listening \n", temp->ss_addr); 
			// fault tolerant issue
			}
		temp = temp->next;
	}
	return ;
}
