/* Author: Balakrishnan Rukmangathan
   sites_list.c : maintain the list of storage sites and the
		  socket to communicate with them.
*/

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>


#include "sites_list.h"

extern void log_write(char *, ...);

s_list *head = NULL;

void add_to_list(char *ss_addr, int sockfd)
{
	// add the storage site and the socket to the list

	s_list *temp = (s_list *)malloc(sizeof(s_list));
	strcpy(temp->ss_addr,ss_addr);
	temp->sockfd = sockfd;
	temp->next = head;
	head = temp;
	log_write("Added %s to the list of sites \n",temp->ss_addr);
}// end of add_list


void delete_frm_list(int sockfd)
{
	// this storage site is not responding delete it from the list
	
	s_list *curnt=head;
	s_list *prev=NULL;

	while(curnt && (curnt->sockfd != sockfd))
			curnt = curnt->next;

	if (curnt == NULL) {
		log_write("Internal site_list inconsistency \n");
		return ;
	}
	if (prev == NULL) {
		// need to remove the head of the list
		head = curnt->next;
		close(curnt->sockfd);
		free(curnt);
		return ; 
	}

	prev->next = curnt->next;
	close(curnt->sockfd);
	free(curnt);
	return ;
} // end of deletefrmlist


int get_sockfd(char *ss_addr)
{
	// get the socket corresponding to ss_addr
	s_list *temp = head;

	while(temp && strcmp(temp->ss_addr,ss_addr))
			temp = temp->next;
	
	if (temp)
		return temp->sockfd;
	else return 0;
}// end of get_sockfd

