/*	Author:  Rukmangathan Balakrishnan 
	registry.h : Registry data structure maintained by the
		     synchronisation site.
*/

#ifndef REGISTRY_H
#define REGISTRY_H

#include <sys/socket.h>
#include "pdfs.h"
#include "cs2us_msgfmt.h"

/* Modes for file open 
typedef enum open_stat {
	F_READ = 0,	// file read 
	F_WRITE,	// file write 
	F_RDWR
} open_stat;
*/

#define MAX_TREE_LEVEL 	27 
// The filehandle is 32 bytes long out of which 27 bytes are the 
// the hashed path of each component in the file name.


/* The registry is maintained as an array of linked list where the index 
   specifies the level of the file in the file hirearchy. This linked list
   consists of the files that are at the same level in the file heirarchy.
   The list of clients who are currently accesing a file and their access
   mode and filehandle are maintained as a list per file basis.
*/

typedef struct cl_details {
	pdfs_fh 	fh;		// filehandle for the file
	open_stat 	omode;		// access mode
	char 		clnt_addr[16];	// client address in dotted-quad 
	int 		sockfd;		// socket for this mount
	char 		srvr_addr[16];	// storage server address in dot-quad
	struct cl_details *next;	// next client
} cl_details;

typedef struct reg_entry {
	char 	*fname;			// name of the file
	int 	writer_count;		// number of clients in read/write mode
	int	reader_count;		// number of clients in read mode
	char 	primary_server[16];	// primary copy's site address in
					// dotted=quad
	pdfs_fh	primary_fh;		// primary copy's pdfs file handle
	cl_details	*clients;	// list of clients 
	struct reg_entry *	next;	// next file in the same level
} reg_entry;

/* function prototypes. */

void registry_init();
void send_callback(reg_entry *);
void send_reuseaddr(reg_entry *);
reg_entry *add_entry(char *, pdfs_fh *, open_stat , char *, char *, int );
reg_entry *find(reg_entry *, char *);
int is_match(cl_details *, pdfs_fh *, open_stat , char *, char *,int );
cl_details *fill_client(pdfs_fh *, open_stat , char *, char *, int );
void delete(char *, pdfs_fh *, open_stat , char *, char *,int );
cs2us_msg *frame_callback(u_short, reg_entry *,cl_details *);
extern void send_update_to_all();

extern void log_write(char *, ...);

#endif

/* End of registry.h. */
