/*
 * getattr	This module handles the NFS attributes.
 *
 * Authors:	Mark A. Shand, May 1988
 *		Donald J. Becker, <becker@super.org>
 *		Rick Sladkey, <jrs@world.std.com>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *		Olaf Kirch, <okir@monad.swb.de>
 *
 *		Copyright 1988 Mark A. Shand
 *		This software maybe be used for any purpose provided
 *		the above copyright notice is retained.  It is supplied
 *		as is, with no warranty expressed or implied.
 */

/* 		modified for nfsv3 : 2/4/99 
 *		Harish Gopal
 */

/* #include "nfs_prot.h" */
#include "nfs.h"
#include "fh.h"
#include "nfsd.h"
/* #include "system.h" */
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>

char * fh_path (nfs_fh3 *fh, nfsstat3 *status);

nfsstat3 setattr (char *path, sattr3 *attr, 
		struct stat *s, struct svc_req *rqstp, int flags);
extern nfsstat3 nfs_errno(void);

/*
 * Set file attributes based on file handle
 */

nfsstat3 fh_setattr(fh, attr, s, rqstp, flags)
nfs_fh3		*fh;
sattr3		*attr;
struct stat	*s;
struct svc_req	*rqstp;
int		flags;

{
    char *path;
    nfsstat3 status;
	
     if ((path = fh_path(fh, &status)) == NULL) {

     return (NFS3ERR_STALE);  	
     }
  return (setattr (path, attr, s, rqstp, flags));
}


/*
 * Set file attributes given the path. The flags argument
 * determines if we have to stat the file or if the stat buf
 * passed in s contains valid data.
 * As we go along and modify the file attributes, we update the
 * fields of this stat structure.
 */


nfsstat3 setattr (path, attr, s, rqstp, flags)
char *path;
sattr3 *attr;
struct stat *s;
struct svc_req *rqstp;
int flags ;
{

	
	struct stat sbuf;

	
	// printf("Entered setattr : set the attributes\n");	
	if (s == NULL ) {
	   	s = &sbuf;
		flags |= SATTR_STAT;
	}
 
	if (( flags & SATTR_STAT) && lstat (path, (s = &sbuf)) < 0) {
	printf("setattr: couldn't stat %s! errno=%d\n",
                                path, errno);                           
	return nfs_errno ();
	}

	// printf("after lstat\n");
	if (flags & SATTR_SIZE) {
                unsigned int    size = attr->size.size;

		// printf("size is %d\n", size);	
                if (S_ISREG(s->st_mode) && attr->size.set_it != FALSE) {
			// printf("before truncate\n");
                        if (truncate(path, size) < 0)
                                goto failure;
                        s->st_size = size;
         	}
        }                  	

	// printf("after size check\n");	
 	if (flags & SATTR_UTIMES) {
                unsigned int    a_secs = attr->atime.atime.seconds;
                unsigned int    m_secs = attr->mtime.mtime.seconds;

                if ((a_secs != -1 && a_secs != s->st_atime)
                 || (m_secs != -1 && m_secs != s->st_mtime)) {
                        struct timeval tvp[2];
                        tvp[0].tv_sec = attr->atime.atime.seconds;
                        tvp[0].tv_usec = attr->atime.atime.nseconds;
                        tvp[1].tv_sec = attr->mtime.mtime.seconds;
                        tvp[1].tv_usec = attr->mtime.mtime.nseconds;
                        if (utimes(path, tvp) < 0)
                                goto failure;
                        if (attr->mtime.set_it != FALSE)
                                s->st_atime = attr->atime.atime.seconds;
                        if (attr->mtime.set_it  != FALSE)
                                s->st_mtime = attr->mtime.mtime.seconds;
                }
        }                         	

		
	// printf("setattr : mode is %d path is %s\n", attr->mode.mode, path);
	if (flags & SATTR_CHMOD) {
              unsigned int    mode = attr->mode.mode;

	      // printf("setattr : mode is %d path is %s\n", mode, path);
              if (attr->mode.set_it != FALSE && mode != 0xFFFF /* ultrix bug */
                 && (mode & 07777) != (s->st_mode & 07777)) {
                        if (chmod(path, mode) < 0)
                                goto failure;
                        s->st_mode = (s->st_mode & ~07777) | (mode & 07777);
                }
        }                                                   	

	if (flags & SATTR_CHOWN) {
                uid_t           uid = attr->uid.uid;
                gid_t           gid = attr->gid.gid;

                /* if (uid != (uid_t)-1)
                        uid = luid(uid, nfsmount, rqstp);
                if (gid != (gid_t)-1)
                        gid = lgid(gid, nfsmount, rqstp);

                if ((uid != (uid_t)-1 && uid != s->st_uid)
                 || (gid != (gid_t)-1 && gid != s->st_gid)) {
                        if (lchown(path, uid, gid) < 0)
                                goto failure;
                        if (uid != (uid_t)-1) s->st_uid = uid;
                        if (gid != (gid_t)-1) s->st_gid = gid;
                }
		*/
        }             	
		
      return (NFS3_OK);         

failure:
	
	return nfs_errno();

}



