/*
 * getattr	This module handles the NFS attributes.
 *
 * Authors:	Mark A. Shand, May 1988
 *		Donald J. Becker, <becker@super.org>
 *		Rick Sladkey, <jrs@world.std.com>
 *		Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *
 *		Copyright 1988 Mark A. Shand
 *		This software maybe be used for any purpose provided
 *		the above copyright notice is retained.  It is supplied
 *		as is, with no warranty expressed or implied.
 */

/*
 *		Modified for NFS Version 3
 *		Harish Gopal
 */

#include "nfs.h"
#include "fh.h"
#include "mysystem.h" 
#include <sys/stat.h>
#include <unistd.h>

extern psi_t fh_psi(nfs_fh3 *fh);


#define ftype_map(st_mode) (_ftype_map[((st_mode) & S_IFMT) >> 12])
ftype3 _ftype_map[16] =

{
 #ifdef S_IFIFO
        NF3NON, NF3FIFO, NF3CHR, NF3BAD,
#else
        NF3NON, NF3BAD, NF3CHR, NF3BAD,
#endif
        NF3DIR, NF3BAD, NF3BLK, NF3BAD,
        NF3REG, NF3BAD, NF3LNK, NF3BAD,
        NF3SOCK, NF3BAD, NF3BAD, NF3BAD,       
};

extern fhcache *fh_find(svc_fh *h, int mode);
extern int nfs_errno();

nfsstat3 fhc_getattr(fhcache *fhc, fattr3 *attr, struct stat *stat_optimize, struct svc_req *rqstp);


/*
 * Get file attributes based on file handle
 */  
nfsstat3 fhc_wccattr (fhcache *fhc, wcc_attr *wcattr, struct stat *stat_optimise,
					struct svc_req *rqstp);
/*
 * Get wcc attributes based on the file handle.
 */

nfsstat3 fh_wccattr (fhcache *fhc, wcc_attr *wcattr,
		     struct stat *stat_optimise, struct svc_req *rqstp)
{
  struct stat *s;
  struct stat sbuf;

   if (stat_optimise != NULL)
                s = stat_optimise;
        else if (lstat(fhc->path, (s = &sbuf)) != 0) {
                return (nfs_errno());
        }
	// printf("size is %ld\n", s->st_size);
	wcattr->size = s->st_size;
	wcattr->mtime.seconds = s->st_mtime;
	wcattr->mtime.nseconds = 0;
	wcattr->ctime.seconds = s->st_ctime;
	wcattr->ctime.nseconds = 0;
	// printf("ctime is %ld\n", wcattr->ctime.seconds);

	return(NFS3_OK);
}

nfsstat3 fh_wcc_attr(char *fh, wcc_attr *wcattr,
			struct stat *stat_optimise, struct svc_req *rqstp)
{
  fhcache *fhc;
  svc_fh *send_val;

  send_val  = (svc_fh *)malloc(sizeof(svc_fh));
  fhc = (fhcache *)malloc(sizeof(svc_fh));

  /* check if the file handle exists. */

  if((fhc = fh_find((svc_fh *)fh, FHFIND_FEXISTS)) == NULL) {
   return(NFS3ERR_STALE); 
  }  

 // printf("path is %s\n", fhc->path); 
 return(fh_wccattr(fhc, wcattr, stat_optimise, rqstp));

}

nfsstat3 fh_getattr(char *fh, fattr3 *attr, 
                    struct stat *stat_optimise, struct svc_req *rqstp) 
{
  fhcache *fhc;
  svc_fh *send_val;

  send_val  = (svc_fh *)malloc(sizeof(svc_fh));
  fhc = (fhcache *)malloc(sizeof(svc_fh));
 
  // printf("*******inside fh_getattr *****\n");  
  // printf("hash val is %d\n", ((svc_fh *)fh)->hash_path[0]);
   
  // printf("hash val is %d\n", ((svc_fh *)fh)->hash_path[1]);
  // printf("hash val psi is %d\n", ((svc_fh *)fh)->psi);
  if((fhc = fh_find((svc_fh *)fh, FHFIND_FEXISTS)) == NULL) {
   return(NFS3ERR_STALE); 
  }  
 
 // printf("path is %s\n", fhc->path); 
 return(fhc_getattr(fhc, attr, stat_optimise, rqstp));

}

/*
 * Get file attributes given the path.
 */

nfsstat3 fhc_getattr(fhcache *fhc, fattr3 *attr, struct stat *stat_optimize, 
				struct svc_req *rqstp)
{
  /* nfsstat status; */
  struct stat *s;
  struct stat sbuf;
 
   // printf("entered fhc_getattr\n"); 
   /* obtain the attributes */
   if (stat_optimize != NULL)
                s = stat_optimize;
        else if (lstat(fhc->path, (s = &sbuf)) != 0) {
                return (nfs_errno());
        }
     
        attr->type = ftype_map(s->st_mode);
	// printf("type is %d\n", attr->type);
        attr->mode = s->st_mode;
        attr->nlink = s->st_nlink;
	// printf("mode is %d\n", attr->mode);
	attr->uid = getuid(); 
	attr->gid = getgid();	
	attr->size = s->st_size;
	attr->used = 0;
        attr->rdev.specdata1 = 0;
        attr->rdev.specdata2 = 0;
	attr->fsid = 0;
	attr->fileid = fh_psi((nfs_fh3 *) &(fhc->h));
	// printf("fileid is %ld\n", attr->fileid);
	attr->atime.seconds = s->st_atime;
	attr->atime.nseconds = 0;
	attr->mtime.seconds = s->st_mtime;
	attr->mtime.nseconds = 0;
        attr->ctime.seconds = s->st_ctime;
	attr->ctime.nseconds = 0; 
 return(NFS3_OK); /* return success */
}


