/*
 * A set of support routines for /etc/rmtab file managment. These routines
 * are called from mountd.c.
 *
 * Written and Copyright by Dariush Shirazi, <dshirazi@uhl.uiowa.edu>
 *
 */
/*
 * modified to support mount protocol version 3
 */
#include "mount.h"
#include "rmtab.h"
/* #include "system.h" */
#include <sys/socket.h>
#include <netdb.h>
#include <sys/stat.h>
#include <unistd.h>


/* function prototypes */
int  rmtab_file (char);
static int rmtab_insert (char *, char *);
static char * rmtab_gethost (struct svc_req *); 

static mountlist rmtablist = NULL;

/*
 * rmtab_add_client -- if client+path not in the list, add them.
 */

void
rmtab_add_client(dirpath path, struct svc_req *rqstp)
{
        char            *hostname;

        hostname = rmtab_gethost(rqstp);
        if (hostname != NULL) {
                rmtab_file('r');
                if (rmtab_insert(hostname, path))
                        rmtab_file('w');
        }
}         


mountlist *
rmtab_list_client(void)
{
        rmtab_file('r');
	// printf("rmtab_list: after rmtab_file\n");
        return(&rmtablist);
}  


static char *
rmtab_gethost(struct svc_req *rqstp)
{
        struct hostent *hp;
        struct in_addr addr;
        
        addr = svc_getcaller(rqstp->rq_xprt)->sin_addr;
        hp   = gethostbyaddr((char *) &addr, sizeof(addr), AF_INET);
   
        if (hp)
                return((char *) hp->h_name);
        return((char *) NULL);
}


/*
 * rmtab_file -- read/write the mount list from/to rmtab file.
 */

int rmtab_file (char op)
{
	
   register int c, len;
   register char *p;
   char buff[256], *host, *path;
   FILE *fp;
   mountlist cur;
   struct stat newstat;


   /* stat the file and  get file status */
   if (op == 'r') 
   {
	if (stat(_PATH_RMTAB, &newstat)){
       	   printf("rmtab: does not exist\n");	
	}

   	/* open the file for reading */
   	if ((fp = fopen (_PATH_RMTAB, "r")) == NULL) {
		printf("rmtab: failure to open\n");
		return 0;
   	}    
   	while (rmtablist) {  /* free the old list */
  		cur = rmtablist;
		rmtablist = rmtablist->ml_next;
		free (cur->ml_hostname);
		free (cur);
    	}	
        while (! feof(fp)) {
  		p = buff;
		host = buff;
		path = NULL;
		len = c = 0;
		while (!feof(fp) && (c = fgetc(fp)) != '\n' && len < 255) {
	 	   if (c == ':') {
			c = '\0';
			path = p+1;
			}
		   *p++ = (char) c;
		   len++;	
		}	
		*p = '\0';
		while (!feof(fp) && c != '\n')
		   c = fgetc(fp);
		if (path)
		  if (*host && *path){
                        // printf("rmtab_file host is %s\n", host);
                        // printf("rmtab_file path is %s\n", path);
			rmtab_insert (host, path);
		  }
    	} 
        fclose (fp);	
  // printf("Rmtab_file: after rmtab_file\n");
  return 0 ;
  } else if (op == 'w') { /* else write option */
         if ((fp = fopen(_PATH_RMTAB, "w")) == NULL) {
                        return 0;
                }
                for (cur = rmtablist; cur; cur = cur->ml_next)
                        fprintf(fp, "%s:%s\n", cur->ml_hostname,
                                               cur->ml_directory);
                fclose(fp);
        
                if (stat(_PATH_RMTAB, &newstat)) {
                        fclose(fp);
                        return 0;
                }
 }        
 return 0;
}  

static int
rmtab_insert (char *hostname, char *path) 
{

   int  hostlen, p0, p1;
   mountlist  cur, prv;


   // printf("inside rmtab_insert\n");
 
   for (cur = rmtablist, prv = NULL; cur; cur = cur->ml_next) {
                p0 = strcmp(cur->ml_hostname, hostname);
                p1 = strcmp(cur->ml_directory, path);

               // printf("Inside for inserthostname is %s\n", cur->ml_hostname);
               // printf("Inside for insertpath is %s\n", cur->ml_directory);
                if (p0 > 0 || (p0 == 0 && p1 > 0))
                        break;                          /* insert here */
                else if (p0 == 0 && p1 == 0)
                        return(0);                      /* already exists */
                prv = cur;
     }
  
   if ((cur = (mountlist) malloc(sizeof(mountbody))) == NULL) {
                return(0);
    }

	  
    hostlen = strlen(hostname);
    if ((cur->ml_hostname = (char *) malloc(hostlen+strlen(path)+2)) == NULL) {
           free(cur);
           return(0);
    }

    cur->ml_directory = cur->ml_hostname + (hostlen + 1);
    strcpy(cur->ml_hostname, hostname);
    strcpy(cur->ml_directory, path);
    // printf("Inside inserthostname is %s\n", cur->ml_hostname);
    // printf("Inside insertpath is %s\n", cur->ml_directory);

    if (prv){
             // printf("rmtab_insert: prv case\n");
             cur->ml_next = prv->ml_next;
             prv->ml_next = cur;
     } else {
             // printf("rmtab_insert: else case\n");
             cur->ml_next = rmtablist;
             rmtablist    = cur;
    }

   for (cur = rmtablist; cur; cur = cur->ml_next) {
               // printf("hostname is %s\n", cur->ml_hostname);
               // printf("path is %s\n", cur->ml_directory);
   }
   
   // printf("before return ining\n");
   return(1);
}


/*
 * rmtab_del_client -- delete a client + path.
 */
void 
rmtab_del_client (dirpath path, struct svc_req *rqstp)
{
	int  p0, p1, changed;
	char *hostname;
	mountlist cur, prv;


        // printf("before getting the host name\n");
        hostname = rmtab_gethost (rqstp);	
	// printf("hostname is %s\n", hostname);
	// printf("pathus %s\n", path);
	if (hostname == NULL)
                return;

        rmtab_file('r');
        changed = 0;
        
        for (cur = rmtablist, prv = NULL; cur; cur = cur->ml_next) {
                p0 = strcmp(cur->ml_hostname, hostname);
		// printf("Val hostname is %s\n", cur->ml_hostname);
		// printf("Val path is %s\n", cur->ml_directory);
                p1 = strcmp(cur->ml_directory, path);
                if (p0 == 0 && p1 == 0) {
			// printf("ALREADY EXISTS already exists\n");	
                        break;   
		}                 /* already exists */
                prv = cur;
        }
	if (cur) {
                /*
                 * don't free both ml_hostname & ml_directory.
                 * See rmtab_insert for details.
                 */
                free(cur->ml_hostname);
                if (prv)
                        prv->ml_next = cur->ml_next;
                else
                        rmtablist    = cur->ml_next;
                free(cur);
                changed = 1;
		// printf("CHANGED CASE\n");
        }
        if (changed)
                rmtab_file('w');
// printf("END of del_client\n");

}


/*
 * rmtab_mdel_client -- delete a client's entries from the list.
 */

void
rmtab_mdel_client(struct svc_req *rqstp)
{
        int             p0, changed;
        char            *hostname;
        mountlist       cur, prv, tmp;
  
        hostname = rmtab_gethost(rqstp);
	// printf("hostname is %s\n", hostname);
        if (hostname == NULL) 
               return;

        rmtab_file('r');
        changed = 0;
        
        prv     = NULL;
        cur     = rmtablist;
        while (cur) {
                p0 = strcmp(cur->ml_hostname, hostname);
                if (p0 == 0) {
                        /*
                         * don't free both ml_hostname & ml_directory.
                         * See rmtab_insert for details.
                         */
                        tmp = cur;
                        cur = cur->ml_next;
                        if (prv)
                                prv->ml_next = cur;
                        else
                                rmtablist    = cur;
                        free(tmp->ml_hostname);
                        free(tmp);
                         
                        changed = 1;
                } else if (p0 < 0) {
                        prv = cur;
                        cur = cur->ml_next;
                } else
                        break;                          /* not found */
        }
   if (changed)
                rmtab_file('w');
}
        

