/*
 * linux/fs/nfs/nfs2xdr.c
 *
 * XDR functions to encode/decode NFSv3 RPC arguments and results.
 * Note: this is incomplete!
 *
 * Copyright (C) 1996 Olaf Kirch
 */
/* 
 * modified to support NFSv3
 * Harish Kaushik.C.G.
 */

#define NFS_NEED_XDR_TYPES

#include <linux/param.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/nfs3_fs.h>
#include <linux/utsname.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/in.h>
#include <linux/pagemap.h>
#include <linux/proc_fs.h>
#include <linux/sunrpc/clnt.h>
#include <linux/mynfs.h>

#ifdef RPC_DEBUG
# define RPC_FACILITY		RPCDBG_NFS
#endif

#define QUADLEN(len)		(((len) + 3) >> 2)
static int			nfs_stat_to_errno(int stat);

/* Mapping from NFS error code to "errno" error code. */
#define errno_NFSERR_IO		EIO

/*
 * Declare the space requirements for NFS arguments and replies as
 * number of 32bit-words
 */
/*
 *common : to be done for remaining calls.
 */

#define NFS_fhandle_sz			(1+16)
#define NFS_sattr_sz	        	15	
#define NFS_filename_sz			1+(NFS3_MAXNAMLEN>>2)
#define NFS_path_sz			1+(NFS3_MAXNAMLEN>>2)
#define NFS_fattr_sz	        	21	
#define NFS_info_sz	        	4+NFS_fattr_sz	
#define NFS_entry_sz	        	5+(NFS3_MAXNAMLEN>>2)	
#define NFS_setattr3_sz			9
#define NFS_writeverf_sz		1+(NFS3_WRITEVERFSIZE>>2)
#define NFS_dirlist_sz			NFS_entry_sz+1
#define NFS_wcc_attr_sz         	6 
#define NFS_wcc_data_sz                 NFS_wcc_attr_sz+NFS_fattr_sz
#define NFS_wcc_data_fattr_sz           1+NFS_fattr_sz+NFS_wcc_data_sz
#define NFS_wcc_attrstat_sz             1+NFS_wcc_attr_sz+NFS_fattr_sz  
#define NFS_ftype_sz			1


/* 
 * encode arguments.
 */

#define NFS_enc_void_sz		0
#define NFS_diropargs_sz	NFS_fhandle_sz+NFS_filename_sz
#define NFS_sattrargs_sz	NFS_fhandle_sz+NFS_sattr_sz
#define NFS_readargs_sz		NFS_fhandle_sz+3
#define NFS_writeargs_sz	NFS_fhandle_sz+4
#define NFS_createargs_sz	NFS_diropargs_sz+NFS_sattr_sz
#define NFS_renameargs_sz	NFS_diropargs_sz+NFS_diropargs_sz
#define NFS_linkargs_sz		NFS_fhandle_sz+NFS_diropargs_sz
#define NFS_symlinkargs_sz	NFS_diropargs_sz+NFS_path_sz+NFS_sattr_sz
#define NFS_readdirargs_sz	NFS_fhandle_sz+3
#define NFS_rdplusargs_sz	NFS_fhandle_sz+2
#define NFS_mknodargs_sz	NFS_diropargs_sz+NFS_ftype_sz   
#define NFS_accessargs_sz       1+NFS_fhandle_sz+1   
#define NFS_commitargs_sz	NFS_fhandle_sz+3
 
/*
 * return values.
 */

#define NFS_dec_void_sz			0
#define NFS_attrstat_sz			1+NFS_fattr_sz
#define NFS_diropres_sz			1+NFS_fhandle_sz+NFS_fattr_sz+1
#define NFS_readres_sz			1+NFS_fattr_sz+1
#define NFS_stat_sz			1
#define NFS_readdirres_sz		1
#define NFS_statfsres_sz		1+NFS_info_sz
#define NFS_rdplusres_sz		1
#define NFS_readlinkres_sz		1+NFS_path_sz+NFS_fattr_sz
#define NFS_dirop_wcc_datares_sz        1+NFS_fhandle_sz+NFS_fattr_sz+2
#define NFS_accessres_sz                1+NFS_fattr_sz+1 
#define NFS_renameres_sz                1+NFS_wcc_data_sz+NFS_wcc_data_sz
#define NFS_writeres_sz                 1+NFS_fattr_sz  
#define NFS_commitres_sz                1+NFS_writeverf_sz+NFS_wcc_data_sz 
#define NFS_fsinfores_sz                1+NFS_fattr_sz+12   
#define NFS_pathconfres_sz		1+NFS_fattr_sz+6
#define NFS_linkres_sz			1+NFS_fattr+sz+NFS_wcc_data_sz

 /*
  * Common NFS XDR functions as inlines
  */

static inline u32 *
xdr_encode_fhandle(u32 *p, struct nfs_fh3 *fh)
{
        // printk("encode fhandle size is %d\n", fh->size);	
	*p++ = htonl(fh->size);
	memcpy(p, fh->data, fh->size);
	return p + QUADLEN(fh->size);
}


 
/* static inline u32 *
xdr_encode_fhandle(u32 *p, struct nfs_fh3 *fhandle)
{
	// printk("encode fhandle\n");
        *((struct nfs_fh3 *) p) = *fhandle;
        return p + QUADLEN(sizeof(*fhandle));
}                 
*/

static inline u32 *
xdr_encode_ftype (u32 *p, u32 type)
{
        // printk("encftype; is %d\n", type);
        *p++ = htonl(type);
        return p;
}


static inline u32 *
xdr_encode_sattr (u32 *p, struct setattr3 *sattr)
{
 // printk("enter sattr encode\n");
 *p++ = htonl(sattr->mode3.set_it);
 *p++ = htonl(sattr->mode3.mode);

 *p++ = htonl(sattr->uid3.set_it);
 *p++ = htonl(sattr->uid3.uid);

 *p++ = htonl(sattr->gid3.set_it);
 *p++ = htonl(sattr->gid3.gid);
 
 *p++ = htonl(sattr->size3.set_it);
 *p++ = htonl(sattr->size3.size);

 *p++ = htonl(sattr->atime3.set_it);
 *p++ = htonl(sattr->atime3.atime.seconds);
 *p++ = htonl(sattr->atime3.atime.useconds);

 *p++ = htonl(sattr->mtime3.set_it);
 *p++ = htonl(sattr->mtime3.mtime.seconds);
 *p++ = htonl(sattr->mtime3.mtime.useconds);

 return p;
}                                                    

/* static inline u32 *
xdr_encode_setattr (u32 *p, struct setattr3 *sattr)
{

*p++ = htonl(sattr->mode3->set_it);
*p++ = htonl(sattr->mode3->mode);
*p++ = htonl(sattr->uid3->set_it);
*p++ = htonl(sattr->uid3->uid);
*p++ = htonl(sattr->gid3->set_it);
*p++ = htonl(sattr->gid3->gid);
*p++ = htonl(sattr->size3->set_it);
*p++ = htonl(sattr->size3->size);
return p;
} 
*/                 


 
static inline u32 *
xdr_decode_fhandle(u32 *p, struct nfs_fh3 *fh)
{
	if ((fh->size = ntohl(*p++)) <= NFS3_FHSIZE) {
		memcpy(fh->data, p, fh->size);
		return p + QUADLEN(fh->size);
	}
	return NULL;
}


/* 
static inline u32 *
xdr_decode_fhandle(u32 *p, struct nfs_fh3 *fhandle)
{
        *fhandle = *((struct nfs_fh3 *) p);
        return p + QUADLEN(sizeof(*fhandle));
}          
*/

static inline enum ftype3
xdr_decode_ftype(u32 type)
{
	return (type == NF3FIFO)? NF3FIFO : (enum ftype3) type;
}


/* static inline u32 *
xdr_decode_data (u32 *p, struct rdata *rdblk) {

        // printk("entered data block\n");
        rdblk->data_len = ntohl(*p++);
        // printk("len is %d\n", rdblk->data_len);
        if (rdblk->data_len <=  NFS3_READ_DATASIZE) {
                // printk("len is %d\n",rdblk->data_len);
                // printk("data is %s\n", p);
                memcpy (rdblk->data_val, p, rdblk->data_len);
                return p + QUADLEN(rdblk->data_len);
        }
        return NULL;
} 
*/
                           

static inline enum stable_how
xdr_decode_stable_how (u32 type)
{
        return (type == FILE_SYNC)? FILE_SYNC : (enum stable_how) type;
}
                        
static inline u32 *
xdr_decode_mystring (u32 *p, char **string, unsigned int *len,
                        unsigned int maxlen)
{
        if (*len > maxlen)
                return NULL;
        *string = (char *)p;
        // printk("string is   %s\n", *string);
        return p + QUADLEN(*len);
}                                 

static inline u32 *
xdr_decode_string2(u32 *p, char **string, unsigned int *len,
                        unsigned int maxlen)
{
        *len = ntohl(*p++);
        if (*len > maxlen)
                return NULL;
        *string = (char *) p;
        return p + QUADLEN(*len);
}                              

static inline u32 *
xdr_decode_wcc_attr (u32 *p, struct nfs3_wcc_attr *wcc_attr){
        // printk("dec wccattr\n");
        wcc_attr->size =  ntohl(*p++);
	wcc_attr->size << 32;
        wcc_attr->size |= ntohl(*p++);
        // printk("size is %lu\n", wcc_attr->size);
        wcc_attr->mtime.seconds = ntohl(*p++);
        wcc_attr->mtime.useconds = ntohl(*p++);
        wcc_attr->ctime.seconds = ntohl(*p++);
        wcc_attr->ctime.useconds = ntohl(*p++);
        // printk("seconds is %d\n", wcc_attr->ctime.seconds);
        return p;
}                        

static inline u32 *
xdr_decode_fattr(u32 *p, struct fattr3 *fattr)
{
        fattr->type = xdr_decode_ftype(ntohl(*p++));
        // printk("type is %d\n", fattr->type);
        fattr->mode = ntohl(*p++);
        // printk("mode is %d\n", fattr->mode);
        fattr->nlink = ntohl(*p++);
        // printk("nlink is %d\n", fattr->nlink);
        fattr->uid = ntohl(*p++);
        // printk("uid is %d\n", fattr->uid);
        fattr->gid = ntohl(*p++);
        // printk("gid is %d\n", fattr->gid);
        fattr->size =  ntohl(*p++);
	fattr->size << 32;
        fattr->size |= ntohl(*p++);
        // printk("fattr size is %ld\n", fattr->size);
        fattr->used =  ntohl(*p++);
	fattr->used << 32;
 	fattr->used |= ntohl(*p++);
        fattr->rdev.rdev_maj = ntohl(*p++);
        fattr->rdev.rdev_min = ntohl(*p++);
        fattr->fsid = ntohl(*p++);
	fattr->fsid << 32;
        fattr->fsid |= ntohl(*p++);
        fattr->fileid = ntohl(*p++);
	fattr->fileid << 32;
        fattr->fileid |= ntohl(*p++);
	// printk("fileid is is %ld\n", fattr->fileid);
        fattr->atime.seconds = ntohl(*p++);
        // printk("atime seconds is %ld\n", fattr->atime.seconds);
        fattr->atime.useconds = ntohl(*p++);
        // printk("atime n seconds is %ld\n", fattr->atime.useconds);
        fattr->mtime.seconds = ntohl(*p++);
        // printk("mtime seconds is %ld\n", fattr->mtime.seconds);
        fattr->mtime.useconds = ntohl(*p++);
        // printk("mtime n seconds is %ld\n", fattr->mtime.useconds);
        fattr->ctime.seconds = ntohl(*p++);
        // printk("ctime seconds is %ld\n", fattr->ctime.seconds);
        fattr->ctime.useconds = ntohl(*p++);
        // printk("mtime n seconds is %d\n", fattr->ctime.useconds);
        return p;                                       
}

static inline u32 *
xdr_decode_wcc_data (u32 *p, struct nfs3_wcc_data *wcc_data){
        int     fattr_val, wcc_attr_val;

	/* wcc_data->before = 
	(nfs3_wcc_attr *) kmalloc (sizeof(nfs3_wcc_attr), GFP_KERNEL);
	wcc_data->after = (fattr3 *) kmalloc (sizeof(fattr3), GFP_KERNEL);
	*/
	
	
 
        // printk("decode wcc_data\n");
        if((wcc_attr_val = ntohl(*p++)) == 1) {
	// printk("decode: wcc_attr\n");
        p = xdr_decode_wcc_attr (p, wcc_data->before);
        } 
        if ((fattr_val = ntohl(*p++)) == 1) {
        // printk("fattrval is %d\n", fattr_val);
        p = xdr_decode_fattr (p, wcc_data->after);
        }
        return p;
}                          

static int
xdr_error(struct rpc_rqst *req, u32 *p, void *dummy)
{
    return -EIO;
}
                    

/*
 * NFS encode functions
 */
/*
 * Encode void argument
 */
static int
nfs_xdr_enc_void(struct rpc_rqst *req, u32 *p, void *dummy)
{
	req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
	return 0;
}

/*
 * Encode file handle argument
 * GETATTR, READLINK, STATFS
 */
static int
nfs_xdr_fhandle(struct rpc_rqst *req, u32 *p, struct nfs_fh3 *fh)
{
	// printk("encode file handle\n");
	p = xdr_encode_fhandle(p, fh);
	req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
	return 0;
}

/*
 * Encode access.
 */

static int
nfs_xdr_accessargs (struct rpc_rqst *req, u32 *p,
                        struct nfs3_accessargs *args)
{
        p = xdr_encode_fhandle(p, args->object);
        *p++ = htonl (args->access);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
}    




/*
 * Encode directory ops argument
 * LOOKUP
 */
static int
nfs_xdr_diropargs(struct rpc_rqst *req, u32 *p, struct nfs3_diropargs
*args)
{
        // printk("Lookup : entered xdr_lookup\n");
        p = xdr_encode_fhandle(p, args->fh);
        p = xdr_encode_string(p, args->name);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        // printk("exit xdr_lookup\n");
        return 0;
}       

/*
 * Encode Read arguments
 */

static int
nfs_xdr_readargs (struct rpc_rqst *req, u32 *p, struct nfs3_readargs
*args) {

	struct rpc_auth *auth = req->rq_task->tk_auth;
        int             replen, buflen;            

        // printk("ENCODE readargs\n");
        p = xdr_encode_fhandle (p, args->fh);
	// printk("read args is offset is %d\n", args->offset);
        *p++ = htonl (args->offset);
        // *p++ = htonl (args->offset);
        *p++ = htonl (args->count);
        *p++ = htonl (args->count);
        // printk("READ count is %d\n", args->count);
        req->rq_slen = xdr_adjust_iovec (req->rq_svec, p);
	
#if 1
        /* set up reply iovec */
        replen = (RPC_REPHDRSIZE + auth->au_rslack + NFS_readres_sz) << 2;
        buflen = req->rq_rvec[0].iov_len;
        req->rq_rvec[0].iov_len  = replen;
        req->rq_rvec[1].iov_base = args->buffer;
        req->rq_rvec[1].iov_len  = args->count;
        req->rq_rvec[2].iov_base = (u8 *) req->rq_rvec[0].iov_base + replen;
        req->rq_rvec[2].iov_len  = buflen - replen;
        req->rq_rlen = args->count + buflen;
        req->rq_rnr = 3;
#else
        replen = (RPC_REPHDRSIZE + auth->au_rslack + NFS_readres_sz) << 2;
        req->rq_rvec[0].iov_len  = replen;
#endif                 

        return 0;
}        


/*
 * Encode arguments to readdir call
 */   
static int
nfs_xdr_readdirargs(struct rpc_rqst *req, u32 *p, struct nfs3_readdirargs *args)
{      
 	struct rpc_task *task = req->rq_task;
        struct rpc_auth *auth = task->tk_auth;
        __u32            bufsiz = args->bufsiz;
        int              replen, buflen;

        /*
         * Some servers (e.g. HP OS 9.5) seem to expect the buffer size
         * to be in longwords ... check whether to convert the size.
         */
        if (task->tk_client->cl_flags & NFS_CLNTF_BUFSIZE)
                bufsiz = bufsiz >> 2;     
 	
	p = xdr_encode_fhandle(p, args->fh);
        *p++ = htonl(args->cookie);
	*p++ = htonl(args->cookie);
	*p++ = htonl (args->bufsiz);
        /* *p++ = htonl(bufsiz); see above */
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
	// printk("send len is %d\n", req->rq_slen);

        /* set up reply iovec */
        replen = (RPC_REPHDRSIZE + auth->au_rslack + NFS_readdirres_sz) << 2;
        buflen = req->rq_rvec[0].iov_len;
       	// printk("buflen is %d\n", req->rq_rvec[0].iov_len); 
	/* printk("RPC: readdirargs: slack is 4 * (%d + %d + %d) = %d\n",
                RPC_REPHDRSIZE, auth->au_rslack, NFS_readdirres_sz, replen); */

        req->rq_rvec[0].iov_len  = replen;
        req->rq_rvec[1].iov_base = args->buffer;
        req->rq_rvec[1].iov_len  = args->bufsiz;
        /* req->rq_rvec[2].iov_base = (u8 *) req->rq_rvec[0].iov_base + replen;
        req->rq_rvec[2].iov_len  = buflen - replen; */
	// printk("req2 is %d\n", req->rq_rvec[2].iov_len);
        req->rq_rlen = replen + args->bufsiz;
        req->rq_rnr = 2;                     
  	// printk("RPC:    readdirargs set up reply vec:\n");
        /* printk("        rvec[0] = %p/%d\n",
                        req->rq_rvec[0].iov_base + 0x1c,
                        req->rq_rvec[0].iov_len);
        printk("        rvec[1] = %p/%d\n",
                        req->rq_rvec[1].iov_base,
                        req->rq_rvec[1].iov_len); */
        return 0;
}                          

/*
 * READDIRPLUS call.
 */   
static
int nfs_xdr_rdplusargs (struct rpc_rqst *req, u32 *p,
                                struct nfs3_rdplusargs *args ) {

        struct rpc_task *task = req->rq_task;
        struct rpc_auth *auth = task->tk_auth;
        __u32          bufsiz = args->bufsiz;
        int            replen;


        p = xdr_encode_fhandle(p, args->dir);
        *p++ = htonl(args->cookie);
        *p++ = htonl(bufsiz); /* see above */     
 	req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);

        /* set up reply iovec */
        replen =
        (RPC_REPHDRSIZE + auth->au_rslack + NFS_rdplusres_sz) << 2;
        req->rq_rvec[0].iov_len  = replen;
        req->rq_rvec[1].iov_base = args->buffer;
        req->rq_rvec[1].iov_len  = args->bufsiz;
        req->rq_rlen = replen + args->bufsiz;
        req->rq_rnr = 2;

        // printk("RPC:    readdirargs set up reply vec:\n");
        /* printk("        rvec[0] = %p/%d\n",
                        req->rq_rvec[0].iov_base,
                        req->rq_rvec[0].iov_len);
        printk("        rvec[1] = %p/%d\n",
                        req->rq_rvec[1].iov_base,
                        req->rq_rvec[1].iov_len); */
        return 0;
}                                       

/*
 * ENCODE SETATTR arguments
 */
static int
nfs_xdr_sattrargs(struct rpc_rqst *req, u32 *p, struct nfs3_sattrargs
*args)
{
        p = xdr_encode_fhandle(p, args->fh);
        p = xdr_encode_sattr(p, args->sattr);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
}     

/*
 * ENCODE CREATE arguments
 */

static int
nfs_xdr_createargs(struct rpc_rqst *req, u32 *p, struct nfs3_createargs
*args)
{
        p = xdr_encode_fhandle(p, args->fh);
        p = xdr_encode_string(p, args->name);
	// p = xdr_encode_ftype (p, args->cmode);
        p = xdr_encode_sattr(p, args->sattr);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
}       

static int
nfs_xdr_mknodargs (struct rpc_rqst *req, u32 *p, struct nfs3_mknodargs
        *args) {
        p = xdr_encode_fhandle(p, args->fh);
        p = xdr_encode_string(p, args->name);
        p = xdr_encode_ftype (p, args->ftype);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
}     

/*
 *
 * ENCODE SYMLINK arguments
 *
 */
static int
nfs_xdr_symlinkargs(struct rpc_rqst *req, u32 *p,
                             struct nfs3_symlinkargs
*args)
{
        p = xdr_encode_fhandle(p, args->fromfh);
        p = xdr_encode_string(p, args->fromname);
        // printk("path is %s\n", args->topath);
        p = xdr_encode_sattr (p, args->sattr);
        p = xdr_encode_string(p, args->topath);
	req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
}       

/*
 *
 * Encode RENAME arguments
 *
 */
static int
nfs_xdr_renameargs(struct rpc_rqst *req, u32 *p, struct nfs3_renameargs
*args)
{
        p = xdr_encode_fhandle(p, args->fromfh);
        p = xdr_encode_string(p, args->fromname);
        p = xdr_encode_fhandle(p, args->tofh);
        p = xdr_encode_string(p, args->toname);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
}   

/*
 *
 * Encode LINK arguments
 *
 */
static int
nfs_xdr_linkargs(struct rpc_rqst *req, u32 *p,
                        struct nfs3_linkargs *args)
{
        p = xdr_encode_fhandle(p, args->fromfh);
        p = xdr_encode_fhandle(p, args->tofh);
        p = xdr_encode_string(p, args->toname);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return 0;
} 

/*
 * WRITE arguments. Splice the buffer to be written into the iovec.
 */
static int
nfs_xdr_writeargs(struct rpc_rqst *req, u32 *p, struct nfs3_writeargs
*args){

 	u32 count = args->count;    	
        
	p = xdr_encode_fhandle(p, args->fh);
        *p++ = htonl(args->offset);
        *p++ = htonl(args->offset);
        *p++ = htonl(args->count);
	*p++ = htonl(args->count);
        /* *p++ = htonl(args->stable);
        *p++ = htonl(NFS3_FHSIZE);
        memcpy(p, args->data.data_val, NFS3_FHSIZE);
        p =  (p + QUADLEN (NFS3_FHSIZE)); */
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        req->rq_svec[1].iov_base = (void *) args->buffer;
        req->rq_svec[1].iov_len = count;
        req->rq_slen += count;
        req->rq_snr = 2;       

#ifdef NFS_PAD_WRITES
        /*
         * Some old servers require that the message length
         * be a multiple of 4, so we pad it here if needed.
         */
        count = ((count + 3) & ~3) - count;
        if (count) {
#if 0
printk("nfs_writeargs: padding write, len=%d, slen=%d, pad=%d\n",
req->rq_svec[1].iov_len, req->rq_slen, count);
#endif
                req->rq_svec[2].iov_base = (void *) "\0\0\0";
                req->rq_svec[2].iov_len  = count;
                req->rq_slen += count;
                req->rq_snr = 3;
        }
#endif                          
	return 0;
}    

/*
 * ENCODE COMMIT arguments
 */

static int
nfs_xdr_commitargs (struct rpc_rqst *req, u32 *p,
                        struct nfs3_commitargs  *argp) {

        // printk("entered commitargs\n");
        p = xdr_encode_fhandle(p, argp->file);
        *p++ = htonl(argp->offset);
        *p++ = htonl(argp->offset);
        *p++ = htonl(argp->count);
        req->rq_slen = xdr_adjust_iovec(req->rq_svec, p);
        return(0);
}  



/* 
 * Decode results.
 */

/*
 * decode void reply
 */

static int
nfs_xdr_dec_void(struct rpc_rqst *req, u32 *p, void *dummy)
{
        return 0;
}   

/*
 * Decode simple status reply
 */
static int
nfs_xdr_stat(struct rpc_rqst *req, u32 *p, void *dummy)
{
        int     status;

        if ((status = ntohl(*p++)) != 0)
                status = -status;
        return status;
}
     
/*
 * DECODE attrstat reply
 * GETATTR, SETATTR, WRITE
 */
static int
nfs_xdr_attrstat(struct rpc_rqst *req, u32 *p, struct fattr3 *fattr)
{
        int     status;

        // printk("RPC:      attrstat status %lx\n", ntohl(*p));
        if ((status = ntohl(*p++)))
                return (-status);
        xdr_decode_fattr(p, fattr);
        /* printk("RPC:      attrstat OK type %d mode %o  ino %x\n",
                fattr->type, fattr->mode, fattr->fileid);  */
        return 0;
}         

/*
 * DECODE wcc_attrstat reply
 * SETATTR
 */
static int
nfs_xdr_wcc_attrstat (struct rpc_rqst *req, u32 *p,
        struct nfs3_wcc_data *wcc_data) {
        int             status;

        // printk("entered decode setattr\n");

        if ((status = ntohl(*p++))) {
                // printk("dec setattr :status is %d\n", status);
                return (-status);
        }
	// printk("decode wccattrstat status is %d\n", status);
        p = xdr_decode_wcc_data (p, wcc_data);
        return 0;
}       

/*
 * DECODE access reply.
 */

static int
nfs_xdr_accessres (struct rpc_rqst *req, u32 *p,
                        struct nfs3_accessres *res) {
        int status;
        int  fattrval;


        if ((status = ntohl(*p++)))
                return (-status);
        if ((fattrval = ntohl(*p++)) == 1)
                p = xdr_decode_fattr (p, res->fattr);
        res->access = ntohl(*p++);
        return 0;
}       

/*
 * DECODE FSINFO reply
 */

static int
nfs_xdr_fsinfores (struct rpc_rqst *req, u32 *p,
                        struct nfs3_fsinfores *res) {
        int status;
        int fattrval;

        if ((status = ntohl(*p++)))
                        return (-status);
        if ((fattrval = ntohl(*p++)) == 1)
                        p = xdr_decode_fattr (p, res->fattr);
        res->rtmax = ntohl(*p++);
        res->rtpref = ntohl(*p++);
        res->rtmult = ntohl(*p++);
        res->wtmax = ntohl(*p++);
        res->wtpref = ntohl(*p++);
        res->wtmult = ntohl(*p++);
        res->dtpref = ntohl(*p++);
        res->maxfilesize = ntohl(*p++);
        res->maxfilesize = ntohl(*p++);   
  	res->time_delta.seconds = ntohl(*p++);
        res->time_delta.useconds = ntohl(*p++);
        res->properties = ntohl(*p++);
        return 0;
}

/*
 *
 * DECODE wcc_data_fattr
 */

static int
nfs_xdr_wcc_data_fattr (struct rpc_rqst *req, u32 *p,
                           struct nfs3_linkres *res) {
        int     status;
        // int     valid;
        int     val, fattrval;

        if ((status = ntohl(*p++)))
                return (-status);
        if ((fattrval = ntohl(*p++)) == 1)
                p = xdr_decode_fattr (p, res->fattr);
        if ((val = ntohl(*p++)) == 1)
                p = xdr_decode_wcc_data (p, res->wcc_data);
        return 0;
}                        

/*
 * Decode diropres reply
 * LOOKUP
 */
static int
nfs_xdr_diropres(struct rpc_rqst *req, u32 *p,
                        struct nfs3_diropok *res)
{
        int     status;
        int     valid;

	// printk("LOOKUP decode\n");
        if ((status = ntohl(*p++))){
		// printk("status is %d\n", status);
                return (-status);
	}
	// printk("lookup decode : after status\n");
        p = xdr_decode_fhandle(p, res->fh);
        if ((valid = ntohl(*p++)) == 1)
             xdr_decode_fattr(p, res->fattr);
        return 0;
}        

/*
 *      DECODE dirop_wcc_attrres reply
 *      MKDIR, CREATE.
 */
static int
nfs_xdr_dirop_wcc_datares (struct rpc_rqst *req,
                           u32 *p,
                           struct nfs3_createres *res) {
        int     status;
        int     valid, value, handval;

        // printk("enter decode mkdir\n");
        if ((status = ntohl(*p++)))
                return (-status);
        if ((handval = ntohl(*p++)))
        p = xdr_decode_fhandle(p, res->fh);
        if ((valid = ntohl(*p++)) == 1)
        p = xdr_decode_fattr(p, res->fattr);
	
        /* if ((value = ntohl(*p++)) == 1)
        xdr_decode_wcc_data (p, res->wcc_data); */
        return 0;
}                 
       
/*
 * DECODE statfs   resply
 *
 */
static int
nfs_xdr_statfsres(struct rpc_rqst *req, u32 *p,
        struct nfs3_fsstat *res) {
        int     status;
        int     valid;

        if ((status = ntohl(*p++)))
               return (-status);
        if ((valid = ntohl(*p++)) == 1) {
             p = xdr_decode_fattr (p, res->fattr);
        }
        res->tbytes = ntohl(*p++);
        res->fbytes = ntohl(*p++);
        res->tfiles = ntohl(*p++);
        res->ffiles = ntohl(*p++);
        return 0;
}       

/*
 * Decode READ reply
 */

static int
nfs_xdr_readres(struct rpc_rqst *req, u32 *p,
                                struct nfs3_readres *res)
{
       struct iovec *iov = req->rq_rvec;    
       int     status, val, recvd, hdrlen;
       u32	count;

       // printk("RPC:      readres OK status %lx\n", ntohl(*p));
       if ((status = ntohl(*p++)))
               return (-status);
       // if ((val = ntohl(*p++)) == 1)
       p = xdr_decode_fattr(p, res->fattr);
       // printk("after fattr\n");
       count = ntohl(*p++);
       // printk("readres : after count is %d\n", count);
	
	hdrlen = (u8 *) p - (u8 *) iov->iov_base;
        recvd = req->rq_rlen - hdrlen;
        if (p != iov[2].iov_base) {
                /* Unexpected reply header size. Punt.
                 * XXX: Move iovec contents to align data on page
                 * boundary and adjust RPC header size guess */
                printk("NFS: Odd RPC header size in read reply: %d\n", hdrlen);
                return -errno_NFSERR_IO;
        }
	if (count > recvd) {
                printk("NFS: server cheating in read reply: "
                        "count %d > recvd %d\n", count, recvd);
                count = recvd;
        }                                                               
	
	// printk("RPC:      readres OK count %d\n", count);
        if (count < res->count)
                memset((u8 *)(iov[1].iov_base+count), 0, res->count-count);  
	
        /* res->eof = ntohl(*p++);
        // printk("eof is %d\n", res->eof);
        p = xdr_decode_data (p, res->rdblk);
        res->size = ntohl(*p++); */
        
	
	return count;   
} 

/*
 * DECODE READDIRRES
 *
 */

/*
 * Decode the result of a readdir call. We decode the result in place
 * to avoid a malloc of NFS_MAXNAMLEN+1 for each file name.
 * After decoding, the layout in memory looks like this:
 * entry1 entry2 ... entryN <space> stringN ... string2 string1
 * Each entry consists of three __u32 values,
 * the same space as NFS uses.
 * Note that the strings are not null-terminated
 * so that the entire number
 * of entries returned by the server should fit into the buffer.
 */        
static int
nfs_xdr_readdirres(struct rpc_rqst *req, u32 *p,
                        struct nfs3_readdirres *res) {

        struct iovec            *iov = req->rq_rvec;
        int                     status, nr, val;
        char                    *string, *start, *cstr;
        u32                     *end, *entry, stlen;
        u64                     fileid, cookie;
	u32			len;
        fattr3                  *fattr;
        cookieverf3             cverf;
        unsigned int            *lenp;

        fattr = (fattr3 *) kmalloc (sizeof(fattr3), GFP_KERNEL);
        lenp = (unsigned int *) kmalloc
                (sizeof(unsigned int)*NFS3_COOKIEVERFSIZE, GFP_KERNEL);
	cstr = (char *) kmalloc (sizeof(char)*NFS3_COOKIEVERFSIZE, GFP_KERNEL);
 
		
        *lenp = 1;
        if ((status = ntohl(*p++)))
                return (-status);

        // printk("pval is %p\n", (void *)p);
	// printk("iov base val is %p\n", (u8 *)iov->iov_base+iov->iov_len);

        if ((void *) p != ((u8 *) iov->iov_base+iov->iov_len)) {  
         /* Unexpected reply header size. Punt.  */
        printk("NFS: Odd RPC header size in readdirres reply\n");
                return (-5);
        }

        /* Get start and end address of XDR data */
        p   = (u32 *) iov[1].iov_base;
        end = (u32 *) ((u8 *) p + iov[1].iov_len);

        /* Get start and end of dirent buffer */
        entry  = (u32 *) res->buffer;
        start  = (char *) res->buffer;
        string = (char *) res->buffer + res->bufsiz;

        if ((val = ntohl(*p++)) == 1)
         p = xdr_decode_fattr(p, res->fattr);
        /* check for the cookie verifier */
        // stlen = ntohl(*p++);
        // printk("stlen is %d\n", stlen);
        /* 
	memcpy (cstr , p, NFS3_COOKIEVERFSIZE);
        p += QUADLEN (NFS3_COOKIEVERFSIZE);
	*/
        for (nr = 0; *p++; nr++) {    
   		fileid = ntohl(*p++);
		fileid << 32;
                fileid |= ntohl(*p++);
                // printk("fileid is %lu\n", fileid);
                len = ntohl(*p++);
                // printk("len  is %lu\n", len);
                /*
                 * Check whether the server has
                 * exceeded our reply buffer,
                 * and set a flag to convert the size to longwords.
                 */
                 if ((p + QUADLEN(len) + 3) > end) {
                        struct rpc_clnt *clnt = req->rq_task->tk_client;
                        printk(KERN_WARNING
                        "NFS: server %s, readdir reply truncated\n",
                                clnt->cl_server);
                        printk(KERN_WARNING "NFS:
                                nr=%d, slots=%d, len=%d\n",
                                nr, (end - p), len);
                        clnt->cl_flags |= NFS_CLNTF_BUFSIZE;
                        break;
                }
                if (len > NFS3_MAXNAMLEN) {
                        printk("NFS: giant filename  
   					in readdir (len %x)!\n",
                                                len);
                        return (-5);
                }
                string -= len;
                if ((void *) (entry+3) > (void *) string) {
                        /*
                         * This error is impossible as long as the temp
                         * buffer is no larger than the user buffer. The
                         * current packing algorithm
                         * uses the same amount
                         * of space in the user buffer as in
                         * the XDR data,
                         * so it's guaranteed to fit.
                         */
                        printk("NFS: incorrect buffer size in %s!\n",
                                __FUNCTION__);
                break;
                }

                // memmove(string, p, len);
                memcpy (string, p, len);
		// printk("string is %s\n", string);
                // printk("after memcpy\n");           
		p += QUADLEN(len);
                // printk("after quadlen\n");
                cookie = ntohl(*p++);
		cookie << 32;
                cookie |= ntohl(*p++);
                // printk("cookie is %lu\n", cookie);

                /*
                 * To make everything fit, we encode the length, offset,
                 * and eof flag into 32 bits. This works for filenames
                 * up to 32K and PAGE_SIZE up to 64K.
                 */
                status = !p[0] && p[1] ? (1 << 15) : 0;  /* eof flag */
                if (entry > res->buffer + res->bufsiz) {
                printk ("error : size overflow\n");
                }
                *entry++ = fileid;
                *entry++ = cookie; // loses precision.
                *entry++ = ((string - start) << 16) | status |
                                                        (len & 0x7FFF);
                // printk("status is %d\n", status);
        }
        /* printk("nfs_xdr_readdirres: %d entries, ent sp=%d, str sp=%d\n",
        nr, ((char *) entry - start), (start + res->bufsiz - string)); */
        kfree (fattr);                     
 	kfree (lenp);
	kfree (cstr);
        return nr;
}

/*
 *
 * COMMIT res
 *
 */

static int
nfs_xdr_commitres (struct rpc_rqst *req, u32 *p,
                        struct nfs3_commitres *res) {
        int             status;
        int             valid, val_wcc_one;
        unsigned int    *lenp;


        // printk("entered commit res\n");

        lenp = (unsigned int *) kmalloc
                (sizeof(unsigned int)*NFS3_WRITEVERFSIZE
                                                     , GFP_KERNEL);
        *lenp = 1;
        if ((status = ntohl(*p++)))
                return (-status);
        p = xdr_decode_wcc_data (p, res->wcc_data);        
 	p = xdr_decode_mystring (p, &res->verf, lenp,
                                        NFS3_WRITEVERFSIZE);
        kfree (lenp);
        return 0;
}                   

/*
 * DECODE writeres
 */

static int
nfs_xdr_writeres (struct rpc_rqst *req, u32 *p,
                                nfs3_writeres *res) {
        int             status;
        int             valid;
        unsigned int    *lenp;


        *lenp = 1;
        if ((status = ntohl(*p++)))
                return (-status);
        /* p = xdr_decode_wcc_data (p, res->wcc_data);
        res->count = ntohl(*p++);
        printk("count is %ld\n", res->count);
        res->committed = xdr_decode_stable_how (ntohl(*p++));
        printk("stable is %d\n", res->committed);
        p = xdr_decode_mystring (p, &res->verf, lenp,
                                        NFS3_WRITEVERFSIZE); */
        return 0;                                  
} 

/*
 *
 * Decode PATHCONF
 *
 */

 static int
 nfs_xdr_pathconfres (struct rpc_rqst  *req, u32 *p,
                                nfs3_pathconfres  *res ) {
        int     status;
        int     valid;

        if ((status = ntohl(*p++)))
                return (-status);
        if ((valid =ntohl(*p++)) == 1)
            xdr_decode_fattr (p, res->fattr);
        res->linkmax = ntohl(*p++);
        res->linkmax = ntohl(*p++);
        res->name_max = ntohl(*p++);
        res->name_max = ntohl(*p++);
        res->no_trunc = ntohl(*p++);
        res->chown_restricted = ntohl(*p++);
        return 0;                               
 } 

/*
 * Decode READDIRPLUS_3 arguments.
 */
static int
nfs_xdr_rdplusres (struct rpc_rqst *req, u32 *p,
                        struct nfs3_rdplusres *res) {
        struct iovec            *iov = req->rq_rvec;
        int                     status, nr, val,atval, hval;
        char                    *string, *start, *cstr;
        u32                     *end, *entry, stlen, next,
                                maxcount, count;
        u64                     fileid, cookie,len;
        fattr3                  *fattr;
        cookieverf3             cverf;
        unsigned int            *lenp;
        nfs_fh3                 * fh3;

        fattr = (fattr3 *) kmalloc (sizeof(fattr3), GFP_KERNEL);

        fh3 = (nfs_fh3 *) kmalloc (sizeof(nfs_fh3), GFP_KERNEL);


        if ((status = ntohl(*p++)))
                                                
 	{
                // printk("status is %d\n", status);
                return (-status);
        }

        // printk("status is %d\n", status);
        if ((void *) p != ((u8 *) iov->iov_base+iov->iov_len)) {
                /* Unexpected reply header size. Punt.  */
        printk("NFS: Odd RPC header size in readdirres reply\n");
                return (-5);
        }

        /* Get start and end address of XDR data */
        p   = (u32 *) iov[1].iov_base;
        // printk( "start is %p\n", p);
        end = (u32 *) ((u8 *) p + iov[1].iov_len);
        // printk("end is %p\n", end);
        /* Get start and end of dirent buffer */
        entry  = (u32 *) res->buffer;
        start  = (char *) res->buffer;
        string = (char *) res->buffer + res->bufsiz;

        /* get the directory attributes */       
 	if ((val = ntohl(*p++)) == 1)
                p = xdr_decode_fattr(p, fattr);

        // printk("before for loop\n");
        for (nr = 0; *p++; nr++) {
                fileid = ntohl(*p++);
                fileid = ntohl(*p++);
                // printk("fileid is %lu\n", fileid);
                len = ntohl(*p++);
                // printk("len  is %lu\n", len);

                if ((p + QUADLEN(len) + 3) > end) {
                   struct rpc_clnt *clnt = req->rq_task->tk_client;
                   printk(KERN_WARNING
                     "NFS: server %s,
                        readdir reply truncated\n",
                         clnt->cl_server);
                   printk(KERN_WARNING "NFS: nr=%d, slots=%d,
                                len=%d\n",
                                nr, (end - p), len);
                        clnt->cl_flags |= NFS_CLNTF_BUFSIZE;
                        break;
                }                              
 		if (len > NFS3_MAXNAMLEN) {
                        printk("NFS: giant filename in
                                readdir (len %x)!\n",
                                len);
                        return (-5);
                }
                string -= len;
                // printk("after string len sub\n");
                /* if ((void *) (entry+3) > (void *) string) {
                        printk("NFS: incorrect buffer size in %s!\n",
                        __FUNCTION__);
                break;
                } */
                memcpy(string, p, len);
                // printk("after memcpy\n");
                p += QUADLEN(len);
                // printk("after quadlen\n");
                cookie = ntohl(*p++) << 32;
                cookie |= ntohl(*p++);                                                          // printk("cookie is %lu\n", cookie);
                if ((hval = ntohl(*p++)) == 1)
                        p = xdr_decode_fhandle (p, fh3);                                                                                         
		/*
                 * To make everything fit, we encode the length, offset,
                 * and eof flag into 32 bits. This works for filenames
                 * up to 32K and PAGE_SIZE up to 64K.
                 */
                status = !p[0] && p[1] ? (1 << 15) : 0;  /* eof flag */
                if (entry > res->buffer + res->bufsiz) {
                printk ("error in overflow\n");
                }
                *entry++ = fileid;
                *entry++ = cookie; // loss of precision
                                   // but cookie is unused.
                *entry++ = ((string - start) << 16) | status |
                                                        (len & 0x7FFF);
                // printk("after entry %d\n", nr);
                // printk("status is %d\n", status | 0x8000);
        // kfree( fh3);
        }
        next = ntohl (*p++) << 32;
        next |= ntohl (*p++);
        // printk("next is %d\n", next);
        count = ntohl (*p++);
        // printk("count is %d\n", count);        
  	maxcount = ntohl (*p++);
        // printk("count is %d\n", maxcount);
        // handle attributes.
        /*
        printk("nfs_xdr_readdirplusres: %d entries,
                                ent sp=%d, str sp=%d\n",
        nr, ((char *) entry - start), (start + res->bufsiz - string));
        */

        //  kfree (fattr);
        // printk("before ret in xdr code\n");
        return nr;
}                                     

/*
 * Decode RENAME
 */
static int
nfs_xdr_renameres (struct rpc_rqst *req,
                   u32 *p, struct nfs3_renameres *res)
 {
        int     status;
        int     val_wcc_one, val_wcc_two;
	// struct nfs3_wcc_data  *fromattr, *toattr;

	/* 
	fromattr = 
	(nfs3_wcc_data *) kmalloc(sizeof(struct nfs3_wcc_data), GFP_KERNEL);
	 	
	toattr = 
	(nfs3_wcc_data *) kmalloc(sizeof(struct nfs3_wcc_data), GFP_KERNEL);
	*/
		
        if ((status = ntohl(*p++))){
                // printk("status is %d\n",status);
                return (-status);
        }
        // printk("rename res: after status case\n");
        p = xdr_decode_wcc_data (p, res->from);
        // printk("renameres: after resfrom\n");
  	p = xdr_decode_wcc_data (p, res->to);
        // printk("renameres: after resto\n");
	
        return 0;
}                               

/*
 *
 * decode READLINK arguments
 *
 */

static int
nfs_xdr_readlinkres(struct rpc_rqst *req, u32 *p,
                        struct nfs3_readlinkres  *res ){
        int     status;

        if ((status = ntohl(*p++)))
                return (-status);
        // xdr_decode_string2(p, res->string, res->lenp, res->maxlen);
        /* if ((valid = ntohl(*p++)) == 1)
                p = xdr_decode_fattr (p, res->fattr); */

        /* Caller takes over the buffer here to avoid extra copy
        res->buffer = req->rq_task->tk_buffer;
        req->rq_task->tk_buffer = NULL; */
        return 0;
}           
                


/*
 * NFS ernno value to local errno values which may not be the same.
 */

static struct {
	int stat;
	int errno;
} nfs_errtbl[] = {
	{ NFS3_OK,			0		},
	{ NFS3ERR_PERM,			EPERM		},
	{ NFS3ERR_NOENT,		ENOENT		},
	{ NFS3ERR_IO,			errno_NFSERR_IO	},
	{ NFS3ERR_NXIO,			ENXIO		},
	{ NFS3ERR_ACCES,		EACCES		},
	{ NFS3ERR_EXIST,		EEXIST		},
	{ NFS3ERR_XDEV,			EXDEV		},
	{ NFS3ERR_NODEV,		ENODEV		},
	{ NFS3ERR_NOTDIR,		ENOTDIR		},
	{ NFS3ERR_ISDIR,		EISDIR		},
	{ NFS3ERR_INVAL,		EINVAL		},
	{ NFS3ERR_FBIG,			EFBIG		},
	{ NFS3ERR_NOSPC,		ENOSPC		},
	{ NFS3ERR_ROFS,			EROFS		},
	{ NFS3ERR_NAMETOOLONG,		ENAMETOOLONG	},
	{ NFS3ERR_NOTEMPTY,		ENOTEMPTY	},
	{ NFS3ERR_DQUOT,		EDQUOT		},
	{ NFS3ERR_STALE,		ESTALE		},
#ifdef EWFLUSH
	{ NFS3ERR_WFLUSH,		EWFLUSH		},
#endif
	{ -1,				EIO		}
};

static int
nfs_stat_to_errno(int stat)
{
	int i;

	for (i = 0; nfs_errtbl[i].stat != -1; i++) {
		if (nfs_errtbl[i].stat == stat)
			return nfs_errtbl[i].errno;
	}
	printk("nfs_stat_to_errno: bad nfs status return value: %d\n", stat);
	return nfs_errtbl[i].errno;
}

#ifndef MAX
# define MAX(a, b)	(((a) > (b))? (a) : (b))
#endif

#define PROC(proc, argtype, restype)	\
    { "nfs_" #proc,					\
      (kxdrproc_t) nfs_xdr_##argtype,			\
      (kxdrproc_t) nfs_xdr_##restype,			\
      MAX(NFS_##argtype##_sz,NFS_##restype##_sz) << 2	\
    }

static struct rpc_procinfo	nfs_procedures[22] = {
    PROC(null,		enc_void,	dec_void),
    PROC(getattr,	fhandle,	attrstat),
    PROC(setattr,	sattrargs,	wcc_attrstat),
    PROC(lookup,	diropargs,	diropres),
    PROC(access,	accessargs,	accessres),
    PROC(readlink,	fhandle,	readlinkres),
    PROC(read,		readargs,	readres),
    PROC(write,		writeargs,	attrstat),
    PROC(create,	createargs,	dirop_wcc_datares),
    PROC(mkdir,		createargs,	dirop_wcc_datares),
    PROC(symlink,	symlinkargs,	dirop_wcc_datares),
    PROC(mknod,		createargs,	dirop_wcc_datares), 
    PROC(remove,	diropargs,	wcc_attrstat),
    PROC(rmdir,		diropargs,	wcc_attrstat),
    PROC(rename,	renameargs,	renameres),
    PROC(link,		linkargs,	wcc_data_fattr),
    PROC(readdir,	readdirargs,	readdirres),
    PROC(readdirplus,	rdplusargs,	rdplusres),
    PROC(fsstat,	fhandle,	statfsres),
    PROC(fsinfo,	fhandle,	fsinfores),
    PROC(pathconf,	fhandle,	pathconfres),
    PROC(commit,	commitargs,	commitres),
};

static struct rpc_version	nfs_version3 = {
	3,
	/* sizeof(nfs_procedures)/sizeof(nfs_procedures[0]) */
	22,
	nfs_procedures
};

static struct rpc_version *	nfs_version[] = {
	NULL,
	NULL,
	NULL,
	&nfs_version3
};

static struct rpc_stat 	nfs_stats;

struct rpc_program	nfs_program = {
	"nfs",
	NFS_PROGRAM,
	sizeof(nfs_version) / sizeof(nfs_version[0]),
	nfs_version,
	&nfs_rpcstat,
};

/*
 * RPC stats support
 */
/*   
static int
nfs_get_info(char *buffer, char **start, off_t offset, int length, int dummy)
{
	return rpcstat_get_info(&nfs_rpcstat, buffer, start, offset, length);
}
*/

/*   
static struct proc_dir_entry	proc_nfsclnt = {
	0, 3, "nfs",
	S_IFREG | S_IRUGO, 1, 0, 0,
	6, &proc_net_inode_operations,
	nfs_get_info
};
*/

 /* 
struct rpc_stat			nfs_rpcstat = {
	NULL,			// next 
	&proc_nfsclnt,		/proc/net directory entry  
	&nfs_program,		// RPC program 
};
*/
